/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.command.MoveCommand;
import germ.i18n.Messages;
import germ.model.Node;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class AlignBottomAction
extends AbstractGERMAction {
    public AlignBottomAction() {
        this.putValue("SmallIcon", this.loadIcon("arrow_down.png"));
        this.putValue("Name", Messages.getString("AlignBottomAction.0"));
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<Node> nodes = Application.getInstance().getModel().getSelectedNodes();
        if (nodes.size() < 2) {
            return;
        }
        double max = nodes.get(0).getPosition().getY() + nodes.get(0).getSize().getHeight();
        MoveCommand moveCommand = new MoveCommand();
        for (Node n : nodes) {
            if (!(n.getPosition().getY() + n.getSize().getHeight() > max)) continue;
            max = n.getPosition().getY() + n.getSize().getHeight();
        }
        for (Node n : nodes) {
            double pos = max - n.getSize().getHeight();
            n.getPosition().setLocation(n.getPosition().getX(), pos);
        }
        moveCommand.moveEnded();
        Application.getInstance().getCommandManager().doCommand(moveCommand);
        Application.getInstance().getModel().updatePerformed();
    }
}

