/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.command.MoveCommand;
import germ.i18n.Messages;
import germ.model.Node;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class AlignLeftAction
extends AbstractGERMAction {
    public AlignLeftAction() {
        this.putValue("SmallIcon", this.loadIcon("arrow_left.png"));
        this.putValue("Name", Messages.getString("AlignLeftAction.0"));
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<Node> nodes = Application.getInstance().getModel().getSelectedNodes();
        if (nodes.size() < 2) {
            return;
        }
        double min = nodes.get(0).getPosition().getX();
        MoveCommand moveCommand = new MoveCommand();
        for (Node n : nodes) {
            if (!(n.getPosition().getX() < min)) continue;
            min = n.getPosition().getX();
        }
        for (Node n : nodes) {
            double pos = min;
            n.getPosition().setLocation(pos, n.getPosition().getY());
        }
        moveCommand.moveEnded();
        Application.getInstance().getCommandManager().doCommand(moveCommand);
        Application.getInstance().getModel().updatePerformed();
    }
}

