/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.command.MoveCommand;
import germ.i18n.Messages;
import germ.model.Node;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class AlignRightAction
extends AbstractGERMAction {
    public AlignRightAction() {
        this.putValue("SmallIcon", this.loadIcon("arrow_right.png"));
        this.putValue("Name", Messages.getString("AlignRightAction.0"));
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<Node> nodes = Application.getInstance().getModel().getSelectedNodes();
        if (nodes.size() < 2) {
            return;
        }
        double max = nodes.get(0).getPosition().getX() + nodes.get(0).getSize().getWidth();
        MoveCommand moveCommand = new MoveCommand();
        for (Node n : nodes) {
            if (!(n.getPosition().getX() + n.getSize().getWidth() > max)) continue;
            max = n.getPosition().getX() + n.getSize().getWidth();
        }
        for (Node n : nodes) {
            double pos = max - n.getSize().getWidth();
            n.getPosition().setLocation(pos, n.getPosition().getY());
        }
        moveCommand.moveEnded();
        Application.getInstance().getCommandManager().doCommand(moveCommand);
        Application.getInstance().getModel().updatePerformed();
    }
}

