/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.command.MoveCommand;
import germ.i18n.Messages;
import germ.model.Node;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class AlignTopAction
extends AbstractGERMAction {
    public AlignTopAction() {
        this.putValue("SmallIcon", this.loadIcon("arrow_up.png"));
        this.putValue("Name", Messages.getString("AlignTopAction.0"));
    }

    public void actionPerformed(ActionEvent arg0) {
        ArrayList<Node> nodes = Application.getInstance().getModel().getSelectedNodes();
        if (nodes.size() < 2) {
            return;
        }
        double min = nodes.get(0).getPosition().getY();
        MoveCommand moveCommand = new MoveCommand();
        for (Node n : nodes) {
            if (!(n.getPosition().getY() < min)) continue;
            min = n.getPosition().getY();
        }
        for (Node n : nodes) {
            double pos = min;
            n.getPosition().setLocation(n.getPosition().getX(), pos);
        }
        moveCommand.moveEnded();
        Application.getInstance().getCommandManager().doCommand(moveCommand);
        Application.getInstance().getModel().updatePerformed();
    }
}

