/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.gui.windows.CreateNewDiagramWindow;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.workspace.Project;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;

public class CreateNewDiagramAction
extends AbstractGERMAction {
    private Project currentProject = null;
    private boolean nameAllreadyExists = false;

    public CreateNewDiagramAction() {
        this.putValue("Name", Messages.getString("CreateNewDiagramAction.0"));
        this.putValue("ShortDescription", Messages.getString("CreateNewDiagramAction.1"));
    }

    public void actionPerformed(ActionEvent e) {
        this.nameAllreadyExists = false;
        while (!this.nameAllreadyExists) {
            CreateNewDiagramWindow nd = new CreateNewDiagramWindow();
            if (this.currentProject != null) {
                nd.setCbProjects(this.currentProject.getName());
            }
            nd.setVisible(true);
            if (nd.isDialogResult()) {
                Project currentProject = Application.getInstance().getProject(nd.getProject());
                if (currentProject != null) {
                    File check = new File(currentProject.getProjectDir() + File.separator + nd.getEnteredName() + "." + "drm");
                    if (!check.exists()) {
                        this.nameAllreadyExists = true;
                        GERMModel newDiagram = new GERMModel(nd.getEnteredName(), currentProject);
                        currentProject.addDiagram(newDiagram);
                        newDiagram.save();
                        Application.getInstance().getMainWindow().addDiagram(newDiagram.getView());
                        Application.getInstance().getModel().updatePerformed();
                        Application.getInstance().getWorkspace().updatePerformed(null);
                        continue;
                    }
                    JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("CreateNewDiagramAction.3"), "INFORMATION", 1);
                    this.nameAllreadyExists = false;
                    continue;
                }
                JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("CreateNewDiagramAction.5"), "ERROR", 0);
                continue;
            }
            this.nameAllreadyExists = true;
        }
    }

    public void setProject(Project project) {
        this.currentProject = project;
    }
}

