/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.NewPodWindow;
import germ.i18n.Messages;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;

public class CreateNewProjectAction
extends AbstractGERMAction {
    private boolean nameAllreadyExists = false;

    public CreateNewProjectAction() {
        this.putValue("Name", Messages.getString("CreateNewProjectAction.0"));
        this.putValue("ShortDescription", Messages.getString("CreateNewProjectAction.1"));
    }

    public void actionPerformed(ActionEvent e) {
        while (!this.nameAllreadyExists) {
            NewPodWindow np = new NewPodWindow(NewPodWindow.NEW_PROJECT);
            np.setVisible(true);
            if (np.isDialogResult()) {
                File newProject = new File(String.valueOf(ConfigurationManager.getInstance().getString("workspace")) + File.separator + np.getEnteredName());
                if (!newProject.exists()) {
                    NewPodWindow nd = new NewPodWindow(NewPodWindow.NEW_DIAGRAM);
                    nd.setVisible(true);
                    if (nd.isDialogResult()) {
                        Application.getInstance().addProject(np.getEnteredName(), nd.getEnteredName());
                        Application.getInstance().getModel().updatePerformed();
                        this.nameAllreadyExists = true;
                        continue;
                    }
                    this.nameAllreadyExists = false;
                    continue;
                }
                JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("CreateNewProjectAction.3"), "INFORMATION", 1);
                this.nameAllreadyExists = false;
                continue;
            }
            this.nameAllreadyExists = true;
        }
    }
}

