/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.workspace.Project;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;

public class DeleteProjectAction
extends AbstractGERMAction {
    private Project project = null;

    public DeleteProjectAction() {
        this.putValue("Name", Messages.getString("DeleteProjectAction.0"));
        this.putValue("ShortDescription", Messages.getString("DeleteProjectAction.1"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.project != null) {
            int i = this.project.getDiagramCount() - 1;
            while (i != -1) {
                GERMModel diagram = this.project.getDiagram(i);
                int tabIndex = Application.getInstance().getMainWindow().getTab(diagram.getView());
                if (tabIndex != -1) {
                    Application.getInstance().getMainWindow().getTabs().removeTabAt(tabIndex);
                }
                this.project.deleteDiagramIndex(i);
                File diagramDir = diagram.getDiagramDir();
                if (diagramDir != null && !diagramDir.delete()) {
                    JOptionPane.showMessageDialog(Application.getInstance().getView(), String.valueOf(Messages.getString("DeleteProjectAction.2")) + diagram.getName() + Messages.getString("DeleteProjectAction.3"), Messages.getString("DeleteProjectAction.4"), 0);
                }
                --i;
            }
            Application.getInstance().removeProject(this.project);
            if (!this.project.getProjectDir().delete()) {
                JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("DeleteProjectAction.5"), Messages.getString("DeleteProjectAction.6"), 0);
            }
            Application.getInstance().getWorkspace().updateUI();
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

