/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.command.MoveCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.MainWindow;
import germ.i18n.Messages;
import germ.model.Node;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributeHorizontalAction
extends AbstractGERMAction {
    public DistributeHorizontalAction() {
        this.putValue("Name", Messages.getString("DistributeHorizontalAction.0"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (Application.getInstance().getModel().getSelectedNodes().size() < 2) {
            return;
        }
        MoveCommand moveCommand = new MoveCommand();
        ArrayList<Node> nodes = this.sort(Application.getInstance().getModel().getSelectedNodes());
        ArrayList<Point2D> newLocations = new ArrayList<Point2D>();
        double pos = nodes.get(0).getPosition().getX();
        if (ConfigurationManager.getInstance().getBoolean("animationEnabled")) {
            MainWindow mw = Application.getInstance().getMainWindow();
            mw.backupStatusBar();
            mw.setStatusBarMessage(Messages.getString("DistributeHorizontalAction.1"), 0);
            for (Node n : nodes) {
                newLocations.add(new Point2D.Double(pos, n.getPosition().getY()));
                pos += n.getSize().getWidth() + 30.0;
            }
            Application.getInstance().getMainWindow().getTimerThread().setRelocatingNodesParams(nodes, newLocations, moveCommand);
        } else {
            for (Node n : nodes) {
                n.getPosition().setLocation(pos, n.getPosition().getY());
                pos += n.getSize().getWidth() + 30.0;
            }
            moveCommand.moveEnded();
            Application.getInstance().getCommandManager().doCommand(moveCommand);
            Application.getInstance().getModel().updatePerformed();
        }
    }

    private ArrayList<Node> sort(ArrayList<Node> nodes) {
        ArrayList<Node> sorted = new ArrayList<Node>();
        while (nodes.size() != 0) {
            double min = nodes.get(0).getPosition().getX();
            int index = 0;
            for (Node n : nodes) {
                if (!(n.getPosition().getX() < min)) continue;
                min = n.getPosition().getX();
                index = nodes.indexOf(n);
            }
            sorted.add(nodes.remove(index));
        }
        return sorted;
    }
}

