/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.gui.windows.ImportExportFileChooserWindow;
import germ.i18n.Messages;
import germ.model.workspace.Project;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExportAction
extends AbstractGERMAction {
    private Project projectToExport;

    public ExportAction() {
        this.putValue("Name", Messages.getString("ExportAction.0"));
        this.putValue("ShortDescription", Messages.getString("ExportAction.1"));
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            String projectPath = this.projectToExport.getProjectDir().getCanonicalPath();
            File[] diagrams = new File[this.projectToExport.getDiagramCount()];
            int i = 0;
            while (i != this.projectToExport.getDiagramCount()) {
                diagrams[i] = new File(String.valueOf(projectPath) + File.separator + this.projectToExport.getDiagram(i).getFileName());
                ++i;
            }
            byte[] buf = new byte[1024];
            try {
                String savePath = this.getSavePath();
                if (savePath != null) {
                    String outFilename = savePath.endsWith("gar") ? savePath : String.valueOf(savePath) + "." + "gar";
                    ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
                    out.setLevel(-1);
                    int i2 = 0;
                    while (i2 < diagrams.length) {
                        int len;
                        FileInputStream in = new FileInputStream(diagrams[i2]);
                        out.putNextEntry(new ZipEntry(diagrams[i2].getName()));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                        in.close();
                        ++i2;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void setProjectToExport(Project project) {
        this.projectToExport = project;
    }

    private String getSavePath() {
        ImportExportFileChooserWindow chooser = new ImportExportFileChooserWindow();
        if (chooser.showOpenDialog(Application.getInstance().getMainWindow()) == 0) {
            String file = chooser.getSelectedFile().getAbsolutePath();
            return file;
        }
        return null;
    }
}

