/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.ImportExportFileChooserWindow;
import germ.i18n.Messages;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;

public class ImportAction
extends AbstractGERMAction {
    public ImportAction() {
        this.putValue("Name", Messages.getString("ImportAction.0"));
        this.putValue("ShortDescription", Messages.getString("ImportAction.1"));
    }

    public void actionPerformed(ActionEvent e) {
        String loadPath = this.getLoadPath();
        if (loadPath != null) {
            File archive = new File(loadPath);
            if (archive.exists()) {
                try {
                    ZipEntry entry;
                    String project = archive.getName().split("\\.")[0];
                    String workspace = ConfigurationManager.getInstance().getString("workspace");
                    File projectDir = new File(String.valueOf(workspace) + File.separator + project);
                    if (projectDir.exists()) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("ImportAction.2"), Messages.getString("ImportAction.3"), 1);
                        return;
                    }
                    projectDir.mkdir();
                    byte[] data = new byte[1024];
                    ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(archive.getCanonicalPath())));
                    BufferedOutputStream out = null;
                    while ((entry = in.getNextEntry()) != null) {
                        int len;
                        out = new BufferedOutputStream(new FileOutputStream(projectDir + File.separator + entry.getName()), 1024);
                        while ((len = in.read(data, 0, 1024)) != -1) {
                            out.write(data, 0, len);
                        }
                        out.flush();
                        out.close();
                    }
                    Application.getInstance().addProject(projectDir);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("ImportAction.4"), Messages.getString("ImportAction.5"), 1);
            }
        }
    }

    private String getLoadPath() {
        ImportExportFileChooserWindow chooser = new ImportExportFileChooserWindow();
        if (chooser.showOpenDialog(Application.getInstance().getMainWindow()) == 0) {
            String file = chooser.getSelectedFile().getAbsolutePath();
            return file;
        }
        return null;
    }
}

