/*
 * Decompiled with CFR 0.152.
 */
package germ.actions;

import germ.actions.AbstractGERMAction;
import germ.app.Application;
import germ.gui.windows.NewPodWindow;
import germ.i18n.Messages;
import germ.model.GERMModel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

public class RenameDiagramAction
extends AbstractGERMAction {
    public RenameDiagramAction() {
        this.putValue("Name", Messages.getString("RenameDiagramAction.0"));
        this.putValue("ShortDescription", Messages.getString("RenameDiagramAction.1"));
    }

    public void actionPerformed(ActionEvent e) {
        NewPodWindow rd = new NewPodWindow(NewPodWindow.EDIT_DIAGRAM);
        GERMModel current = Application.getInstance().getModel();
        rd.setEnteredName(current.toString());
        rd.setVisible(true);
        if (rd.isDialogResult()) {
            try {
                File oldDiagram = new File(current.getDiagramPath());
                File newDiagram = new File(String.valueOf(current.getProject().getProjectDir().getCanonicalPath()) + File.separator + rd.getEnteredName() + "." + "drm");
                current.setName(rd.getEnteredName());
                oldDiagram.renameTo(newDiagram);
                current.save();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("RenameDiagramAction.3"), "ERROR", 0);
            }
            Application.getInstance().getMainWindow().renameDiagram(current);
            current.updatePerformed();
        }
    }
}

