/*
 * Decompiled with CFR 0.152.
 */
package germ.app;

import germ.actions.ActionManager;
import germ.command.CommandManager;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.GERMSplashScreen;
import germ.gui.windows.MainWindow;
import germ.gui.windows.SaveDiagramsWindow;
import germ.gui.workspace.WorkspaceTree;
import germ.i18n.Messages;
import germ.model.Clipboard;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.nodes.Requirement;
import germ.model.workspace.Project;
import germ.model.workspace.Workspace;
import germ.model.workspace.WorkspaceModel;
import germ.state.StateMachine;
import germ.view.GERMView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static Application instance = null;
    private GERMModel model;
    private ActionManager actionManager;
    private StateMachine stateMachine;
    private Clipboard clipboard;
    private WorkspaceTree workspaceTree;
    private List<Project> projects;
    private ArrayList<String> previousFinds = new ArrayList();
    private ArrayList<String> previousRaplaces = new ArrayList();
    private MainWindow mainWindow;

    private Application() {
        this.setActionManager(new ActionManager());
        this.setStateMachine(new StateMachine());
        this.setClipboard(new Clipboard());
        this.initializeWorkspace();
        this.setMainWindow(new MainWindow(this, this.actionManager, this.projects.get(0).getDiagram(0).getView(), this.getWorkspace()));
        this.setModel(this.projects.get(0).getDiagram(0));
        this.projects.get(0).getDiagram(0).updatePerformed();
    }

    public GERMModel getModel() {
        return this.model;
    }

    public void setModel(GERMModel model) {
        this.model = model;
        this.getMainWindow().addDiagram(model.getView());
        this.getMainWindow().setTitle(String.valueOf(ConfigurationManager.getInstance().getString("programName")) + " -> " + model);
    }

    public GERMView getView() {
        return this.getModel().getView();
    }

    public void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public CommandManager getCommandManager() {
        return this.getModel().getCommandManager();
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public void setActionManager(ActionManager actionManager) {
        this.actionManager = actionManager;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void setMainWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public WorkspaceTree getWorkspace() {
        return this.workspaceTree;
    }

    public void setWorkspace(WorkspaceTree workspace) {
        this.workspaceTree = workspace;
    }

    public int getProjectsCount() {
        return this.projects.size();
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public Project getProject(String name) {
        Project project = null;
        int i = 0;
        while (i != this.getProjectsCount()) {
            if (this.getProjects().get(i).getName().equals(name)) {
                project = this.getProjects().get(i);
                return project;
            }
            ++i;
        }
        return project;
    }

    public void workspaceChanged() {
        this.initializeWorkspace();
        this.setModel(this.projects.get(0).getDiagram(0));
        this.getMainWindow().closeAllButLastTab();
        this.getMainWindow().setWorkspaceTree(this.getWorkspace());
    }

    private void initializeWorkspace() {
        this.setWorkspace(new WorkspaceTree());
        WorkspaceModel workspaceModel = new WorkspaceModel();
        this.getWorkspace().setModel(workspaceModel);
        this.projects = new ArrayList<Project>();
        Workspace root = (Workspace)this.getWorkspace().getModel().getRoot();
        String workspacePath = ConfigurationManager.getInstance().getString("workspace");
        File workspace = new File(workspacePath);
        if (Workspace.isValidWorkspace(workspacePath)) {
            String[] stringArray = workspace.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                try {
                    File project = new File(String.valueOf(workspace.getCanonicalPath()) + File.separator + f);
                    if (project.isDirectory()) {
                        Project p = new Project(f, project, this.getWorkspace());
                        this.projects.add(p);
                        root.addProject(p);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                ++n2;
            }
        }
        if (root.getProjectsCount() == 0) {
            File newProject = new File(String.valueOf(workspacePath) + File.separator + Messages.getString("Application.3"));
            newProject.mkdir();
            Project p = new Project(Messages.getString("Application.3"), newProject, this.getWorkspace());
            root.addProject(p);
            this.projects.add(p);
        }
        this.connectSubDiagrams();
    }

    public void addProject(String projectName, String diagramName) {
        String workspace = ConfigurationManager.getInstance().getString("workspace");
        File newProjectDir = new File(String.valueOf(workspace) + File.separator + projectName);
        if (newProjectDir.exists()) {
            JOptionPane.showMessageDialog(Application.getInstance().getMainWindow(), Messages.getString("Application.6"));
            return;
        }
        if (!newProjectDir.mkdir()) {
            JOptionPane.showMessageDialog(Application.getInstance().getMainWindow(), Messages.getString("Application.7"));
            return;
        }
        if (projectName.equals("")) {
            projectName = Messages.getString("Application.9");
        }
        ArrayList<GERMModel> diagrams = new ArrayList<GERMModel>();
        Project newProject = new Project(projectName, newProjectDir, diagrams);
        this.projects.add(newProject);
        if (diagramName.equals("")) {
            diagramName = Messages.getString("Application.11");
        }
        GERMModel d = new GERMModel(diagramName, newProject);
        d.addUpdateListener(this.getWorkspace());
        diagrams.add(d);
        d.save();
        Workspace root = (Workspace)this.getWorkspace().getModel().getRoot();
        root.addProject(newProject);
        this.getModel().updatePerformed();
    }

    public void addProject(File project) {
        Project p = new Project(project.getName(), project, this.getWorkspace());
        this.projects.add(p);
        Workspace root = (Workspace)this.getWorkspace().getModel().getRoot();
        root.addProject(p);
        this.getModel().updatePerformed();
    }

    public void removeProject(Project p) {
        Workspace root = (Workspace)this.getWorkspace().getModel().getRoot();
        root.removeProject(p);
        this.projects.remove(p);
        this.getModel().updatePerformed();
    }

    public void diagramChanged(GERMModel model) {
        this.model = model;
    }

    public void themeChanged() {
        ArrayList<GERMView> tabs = this.getMainWindow().getViewsInTabs();
        String title = this.getMainWindow().getTitle();
        this.getMainWindow().setVisible(false);
        this.actionManager = new ActionManager();
        this.setMainWindow(new MainWindow(this, this.actionManager, this.projects.get(0).getDiagram(0).getView(), this.getWorkspace()));
        this.getMainWindow().setTabs(tabs);
        this.getMainWindow().setVisible(true);
        this.getMainWindow().setTitle(title);
    }

    public void shutdown() {
        ArrayList<GERMModel> unsavedDiagrams = this.getUnsavedDiagrams();
        if (unsavedDiagrams.size() == 0) {
            this.getMainWindow().getTimerThread().setRun(false);
            ConfigurationManager.getInstance().writeFile();
            System.exit(0);
        }
        if (unsavedDiagrams.size() > 0) {
            SaveDiagramsWindow saveDiagramWindow = new SaveDiagramsWindow(this.getUnsavedDiagrams());
            saveDiagramWindow.setVisible(true);
            if (saveDiagramWindow.isDialogResult()) {
                ArrayList<GERMModel> diagramsToSave = saveDiagramWindow.getCheckedDiagrams();
                for (GERMModel m : diagramsToSave) {
                    m.save();
                }
                this.getMainWindow().getTimerThread().setRun(false);
                ConfigurationManager.getInstance().writeFile();
                System.exit(0);
            }
        }
    }

    private ArrayList<GERMModel> getUnsavedDiagrams() {
        ArrayList<GERMModel> rez = new ArrayList<GERMModel>();
        for (Project p : this.projects) {
            int i = 0;
            while (i < p.getDiagramCount()) {
                GERMModel d = p.getDiagram(i);
                if (d.isChanged()) {
                    rez.add(d);
                }
                ++i;
            }
        }
        return rez;
    }

    public static Application getInstance() {
        if (instance == null) {
            instance = new Application();
        }
        return instance;
    }

    public ArrayList<String> getPreviousFinds() {
        return this.previousFinds;
    }

    public ArrayList<String> getPreviousRaplaces() {
        return this.previousRaplaces;
    }

    private GERMModel getModelByName(String name, Node node) {
        if (!(node instanceof Requirement)) {
            return null;
        }
        GERMModel m = null;
        Project project = null;
        for (Project p : this.projects) {
            int i = 0;
            while (i < p.getDiagramCount()) {
                GERMModel d = p.getDiagram(i);
                for (Node n : d.getNodes()) {
                    if (!(n instanceof Requirement) || (n = (Requirement)n) != node) continue;
                    project = p;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < project.getDiagramCount()) {
            GERMModel d = null;
            d = project.getDiagram(i);
            if (name.equals(d.getName())) {
                m = d;
            }
            ++i;
        }
        return m;
    }

    private void connectSubDiagrams() {
        for (Project p : this.projects) {
            int i = 0;
            while (i < p.getDiagramCount()) {
                GERMModel d = p.getDiagram(i);
                for (Node n : d.getNodes()) {
                    if (!(n instanceof Requirement) || ((Requirement)n).getSubDiagramName() == null) continue;
                    GERMModel m = this.getModelByName(((Requirement)n).getSubDiagramName(), n);
                    ((Requirement)n).setSubDiagram(m);
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        GERMSplashScreen ss = new GERMSplashScreen();
        ss.showSplash();
    }
}

