/*
 * Decompiled with CFR 0.152.
 */
package germ.command;

import germ.actions.ActionManager;
import germ.app.Application;
import germ.command.Command;
import germ.configuration.ConfigurationManager;
import germ.model.GERMModel;
import java.util.Stack;

public class CommandManager {
    private Stack<Command> undoStack = new Stack();
    private Stack<Command> redoStack = new Stack();
    private int maximumStackSize = Integer.parseInt(ConfigurationManager.getInstance().getConfigParameter("undoRedoStackSize"));
    GERMModel model;

    public CommandManager(GERMModel model) {
        this.model = model;
    }

    public void doCommand(Command c) {
        c.doCommand();
        if (this.undoStack.size() == this.maximumStackSize) {
            this.undoStack.remove(0);
        }
        this.undoStack.push(c);
        this.redoStack.clear();
        this.refreshUndoRedoButtons(Application.getInstance());
        this.model.commandExecuted();
    }

    public void undoCommand() {
        if (this.undoStack.size() > 0) {
            Command c = this.undoStack.pop();
            c.undoCommand();
            if (this.redoStack.size() == this.maximumStackSize) {
                this.redoStack.remove(0);
            }
            this.redoStack.push(c);
            this.refreshUndoRedoButtons(Application.getInstance());
            this.model.commandExecuted();
        }
    }

    public void redoCommand() {
        if (this.redoStack.size() > 0) {
            Command c = this.redoStack.pop();
            c.doCommand();
            if (this.undoStack.size() == this.maximumStackSize) {
                this.undoStack.remove(0);
            }
            this.undoStack.push(c);
            this.refreshUndoRedoButtons(Application.getInstance());
            this.model.commandExecuted();
        }
    }

    public void removeLastCommand() {
        this.undoStack.pop();
        this.refreshUndoRedoButtons(Application.getInstance());
    }

    public int getCommandsCount() {
        return this.undoStack.size();
    }

    public void refreshUndoRedoButtons(Application app) {
        ActionManager am = app.getActionManager();
        if (this.undoStack.size() == 0) {
            am.getUndoAction().setEnabled(false);
        } else {
            am.getUndoAction().setEnabled(true);
        }
        if (this.redoStack.size() == 0) {
            am.getRedoAction().setEnabled(false);
        } else {
            am.getRedoAction().setEnabled(true);
        }
    }
}

