/*
 * Decompiled with CFR 0.152.
 */
package germ.command;

import germ.app.Application;
import germ.command.Command;
import germ.model.GERMModel;
import germ.model.Link;
import germ.model.Node;
import java.util.ArrayList;

public class DeleteCommand
implements Command {
    private ArrayList<Node> deletedNodes;
    private Link deletedLink;
    private boolean firstTime = true;

    public void doCommand() {
        GERMModel m = Application.getInstance().getModel();
        ArrayList nodesToDelete = null;
        Link linkToDelete = null;
        if (this.firstTime) {
            this.deletedNodes = nodesToDelete = (ArrayList)m.getSelectedNodes().clone();
            if (m.getSelectedLink() != null) {
                this.deletedLink = linkToDelete = m.getSelectedLink();
            }
        } else {
            nodesToDelete = this.deletedNodes;
            linkToDelete = this.deletedLink;
        }
        if (nodesToDelete.size() > 0) {
            for (Node item : nodesToDelete) {
                m.removeNode(item);
            }
        }
        if (linkToDelete != null) {
            m.removeLink(linkToDelete);
        }
        this.firstTime = false;
    }

    public void undoCommand() {
        GERMModel m = Application.getInstance().getModel();
        if (this.deletedNodes.size() > 0) {
            for (Node item : this.deletedNodes) {
                m.addNode(item);
            }
        }
        if (this.deletedLink != null) {
            m.addLink(this.deletedLink);
        }
    }
}

