/*
 * Decompiled with CFR 0.152.
 */
package germ.command;

import germ.app.Application;
import germ.command.Command;
import germ.gui.windows.MainWindow;
import germ.gui.windows.TimerThread;
import germ.model.GERMModel;
import germ.model.Link;
import java.awt.Point;
import java.util.ArrayList;

public class MoveBreakpointCommand
implements Command {
    private Link movedLink;
    private ArrayList<Point> startPositions = new ArrayList();
    private ArrayList<Point> endPositions = new ArrayList();
    private boolean firstTime = true;

    public MoveBreakpointCommand() {
        GERMModel m = Application.getInstance().getModel();
        this.movedLink = m.getSelectedLink();
        for (Point breakpoint : this.movedLink.getBreakPoints()) {
            this.startPositions.add((Point)breakpoint.clone());
        }
    }

    public void doCommand() {
        if (!this.firstTime) {
            GERMModel m = Application.getInstance().getModel();
            MainWindow mw = Application.getInstance().getMainWindow();
            TimerThread tt = mw.getTimerThread();
            mw.backupStatusBar();
            mw.setStatusBarMessage("Redoing move...", 0);
            tt.setRelocatingBreakpoint(this.movedLink, this.endPositions);
            m.updatePerformed();
        }
        this.firstTime = false;
    }

    public void undoCommand() {
        GERMModel m = Application.getInstance().getModel();
        MainWindow mw = Application.getInstance().getMainWindow();
        TimerThread tt = mw.getTimerThread();
        mw.backupStatusBar();
        mw.setStatusBarMessage("Undoing move...", 0);
        tt.setRelocatingBreakpoint(this.movedLink, this.startPositions);
        m.updatePerformed();
    }

    public void moveEnded() {
        for (Point breakpoint : this.movedLink.getBreakPoints()) {
            this.endPositions.add((Point)breakpoint.clone());
        }
    }
}

