/*
 * Decompiled with CFR 0.152.
 */
package germ.command;

import germ.app.Application;
import germ.command.Command;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.MainWindow;
import germ.gui.windows.TimerThread;
import germ.model.GERMModel;
import germ.model.Link;
import germ.model.Node;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class MoveCommand
implements Command {
    private ArrayList<Node> movedNodes;
    private ArrayList<Point2D> startPositions = new ArrayList();
    private ArrayList<Point2D> endPositions = new ArrayList();
    private ArrayList<Link> movedLinks;
    private ArrayList<ArrayList<Point>> breakPointStartPositions = null;
    private ArrayList<ArrayList<Point>> breakPointEndPositions = null;
    private boolean firstTime = true;

    public MoveCommand() {
        GERMModel m = Application.getInstance().getModel();
        this.movedNodes = (ArrayList)m.getSelectedNodes().clone();
        for (Node node : this.movedNodes) {
            this.startPositions.add((Point2D)node.getPosition().clone());
        }
        this.movedLinks = (ArrayList)m.loadAlteredLinks().clone();
        if (this.movedLinks.size() > 0) {
            this.breakPointStartPositions = new ArrayList();
            this.breakPointEndPositions = new ArrayList();
            for (Link link : this.movedLinks) {
                ArrayList<Point> newList = new ArrayList<Point>();
                int i = 0;
                while (i < link.getBreakPointCount()) {
                    newList.add((Point)link.getBreakPointAt(i).clone());
                    ++i;
                }
                this.breakPointStartPositions.add(newList);
            }
        }
    }

    public void doCommand() {
        if (!this.firstTime) {
            GERMModel m = Application.getInstance().getModel();
            if (ConfigurationManager.getInstance().getBoolean("animationEnabled")) {
                MainWindow mw = Application.getInstance().getMainWindow();
                TimerThread tt = mw.getTimerThread();
                mw.backupStatusBar();
                mw.setStatusBarMessage("Redoing move...", 0);
                tt.setFastZoomAndScale(true);
                tt.setRelocatingNodesParams(this.movedNodes, this.endPositions, null);
                tt.setRelocatingBreakpoints(this.movedLinks, this.breakPointEndPositions);
            } else {
                int i = 0;
                while (i < this.movedNodes.size()) {
                    this.movedNodes.get(i).setPosition(this.endPositions.get(i));
                    ++i;
                }
                int j = 0;
                while (j < this.movedLinks.size()) {
                    this.movedLinks.get(j).setBreakPoints(this.breakPointEndPositions.get(j));
                    ++j;
                }
            }
            m.updatePerformed();
        }
        this.firstTime = false;
    }

    public void undoCommand() {
        GERMModel m = Application.getInstance().getModel();
        if (ConfigurationManager.getInstance().getBoolean("animationEnabled")) {
            MainWindow mw = Application.getInstance().getMainWindow();
            TimerThread tt = mw.getTimerThread();
            mw.backupStatusBar();
            mw.setStatusBarMessage("Undoing move...", 0);
            tt.setFastZoomAndScale(true);
            tt.setRelocatingNodesParams(this.movedNodes, this.startPositions, null);
            tt.setRelocatingBreakpoints(this.movedLinks, this.breakPointStartPositions);
        } else {
            int i = 0;
            while (i < this.movedNodes.size()) {
                this.movedNodes.get(i).setPosition(this.startPositions.get(i));
                ++i;
            }
            int j = 0;
            while (j < this.movedLinks.size()) {
                this.movedLinks.get(j).setBreakPoints(this.breakPointStartPositions.get(j));
                ++j;
            }
        }
        m.updatePerformed();
    }

    public void moveEnded() {
        for (Node node : this.movedNodes) {
            this.endPositions.add((Point2D)node.getPosition().clone());
        }
        for (Link link : this.movedLinks) {
            ArrayList<Point> newList = new ArrayList<Point>();
            int i = 0;
            while (i < link.getBreakPointCount()) {
                newList.add((Point)link.getBreakPointAt(i).clone());
                ++i;
            }
            this.breakPointEndPositions.add(newList);
        }
    }
}

