/*
 * Decompiled with CFR 0.152.
 */
package germ.command;

import germ.app.Application;
import germ.command.Command;
import germ.model.Clipboard;
import germ.model.GERMModel;
import germ.model.Node;
import java.awt.Point;
import java.util.ArrayList;

public class PasteCommand
implements Command {
    private ArrayList<Node> pastedItems = new ArrayList();
    boolean firstTime = true;

    public void doCommand() {
        ArrayList<Node> items;
        GERMModel m = Application.getInstance().getModel();
        Clipboard c = Application.getInstance().getClipboard();
        int offsetX = 0;
        int offsetY = 0;
        if (this.firstTime) {
            items = c.getItems();
            Point reference = m.getView().isCursorOnCanvas() ? (Point)m.getView().lastPosition : m.getView().getCanvasCenter();
            if (items.size() > 0) {
                Node n = items.get(0);
                offsetX = (int)(reference.getX() - n.getPosition().getX() - n.getSize().getWidth() / 2.0);
                offsetY = (int)(reference.getY() - n.getPosition().getY() - n.getSize().getHeight() / 2.0);
            }
        } else {
            items = this.pastedItems;
            offsetX = 0;
            offsetY = 0;
        }
        ArrayList<Node> forClipboard = new ArrayList<Node>();
        for (Node item : items) {
            if (this.firstTime) {
                this.pastedItems.add(item);
            }
            item.setPosition(new Point((int)item.getPosition().getX() + offsetX, (int)item.getPosition().getY() + offsetY));
            m.addNode(item);
            Node newItem = (Node)item.clone();
            forClipboard.add(newItem);
        }
        c.addItems(forClipboard);
        this.firstTime = false;
    }

    public void undoCommand() {
        GERMModel m = Application.getInstance().getModel();
        for (Node item : this.pastedItems) {
            m.removeNode(item);
        }
    }
}

