/*
 * Decompiled with CFR 0.152.
 */
package germ.command;

import germ.app.Application;
import germ.command.Command;
import germ.model.GERMModel;
import germ.model.Node;
import germ.view.GERMView;
import java.awt.Point;

public class ResizeCommand
implements Command {
    private double oldScaleX;
    private double oldScaleY;
    private double newScaleX;
    private double newScaleY;
    Node resizedNode = null;
    Point startPosition = new Point();
    Point endPosition = new Point();
    private boolean firstTime = true;

    public ResizeCommand() {
        GERMView v = Application.getInstance().getView();
        this.resizedNode = v.getNodeChangingShape();
        this.startPosition.setLocation(this.resizedNode.getPosition());
        this.oldScaleX = this.resizedNode.getScaleX();
        this.oldScaleY = this.resizedNode.getScaleY();
    }

    public void doCommand() {
        if (!this.firstTime) {
            GERMModel m = Application.getInstance().getModel();
            this.resizedNode.setPosition(this.endPosition);
            this.resizedNode.setScaleX(this.newScaleX);
            this.resizedNode.setScaleY(this.newScaleY);
            m.updatePerformed();
        }
        this.firstTime = false;
    }

    public void undoCommand() {
        GERMModel m = Application.getInstance().getModel();
        this.resizedNode.setPosition(new Point(this.startPosition));
        this.resizedNode.setScaleX(this.oldScaleX);
        this.resizedNode.setScaleY(this.oldScaleY);
        m.updatePerformed();
    }

    public void resizeEnded() {
        this.endPosition.setLocation(this.resizedNode.getPosition());
        this.newScaleX = this.resizedNode.getScaleX();
        this.newScaleY = this.resizedNode.getScaleY();
    }
}

