/*
 * Decompiled with CFR 0.152.
 */
package germ.command;

import germ.app.Application;
import germ.command.Command;
import germ.model.GERMModel;
import germ.model.Node;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPropertiesCommand
implements Command {
    private HashMap<String, Object> oldProperties;
    private HashMap<String, Object> newProperties;
    private ArrayList<Node> nodes;

    public SetPropertiesCommand(ArrayList<Node> nodes, HashMap<String, Object> oldProperties, HashMap<String, Object> newProperties) {
        this.nodes = nodes;
        this.oldProperties = oldProperties;
        this.newProperties = newProperties;
    }

    @Override
    public void doCommand() {
        GERMModel m = Application.getInstance().getModel();
        for (Node node : this.nodes) {
            node.setProperties(this.newProperties);
        }
        m.updatePerformed();
    }

    @Override
    public void undoCommand() {
        GERMModel m = Application.getInstance().getModel();
        for (Node node : this.nodes) {
            node.setProperties(this.oldProperties);
        }
        m.updatePerformed();
    }

    public void setOldProperties(HashMap<String, Object> oldProperties) {
        this.oldProperties = oldProperties;
    }

    public void setNewProperties(HashMap<String, Object> newProperties) {
        this.newProperties = newProperties;
    }
}

