/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.gui.windows.PropertyWindow;
import germ.i18n.Messages;
import germ.model.nodes.ArgumentValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ArgumentProperties
extends PropertyWindow {
    private JLabel lblAuthor = new JLabel(Messages.getString("ArgumentProperties.0"));
    private JTextField tfAuthor = new JTextField(20);
    private JLabel lblValue = new JLabel(Messages.getString("ArgumentProperties.1"));
    private ButtonGroup radioGroup = new ButtonGroup();
    private JRadioButton rbtnAffirmative = new JRadioButton(Messages.getString("ArgumentProperties.2"));
    private JRadioButton rbtnNegative = new JRadioButton(Messages.getString("ArgumentProperties.3"));
    private JRadioButton rbtnNeutral = new JRadioButton(Messages.getString("ArgumentProperties.4"));
    private JTextArea taDescription = new JTextArea(5, 20);
    private JScrollPane spScroll = new JScrollPane(this.taDescription);
    private JLabel lblDescription = new JLabel(Messages.getString("ArgumentProperties.5"));
    private Box group = Box.createVerticalBox();
    private JLabel lblCreationDate = new JLabel(Messages.getString("ArgumentProperties.6"));
    private JLabel lblDateCreated = new JLabel("");
    private JLabel lblLastChangeDAte = new JLabel(Messages.getString("ArgumentProperties.8"));
    private JLabel lblDateChanged = new JLabel("");

    public ArgumentProperties() {
        this.taDescription.setLineWrap(true);
        this.setTitle(Messages.getString("ArgumentProperties.10"));
        this.setDefaultCloseOperation(1);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Container container = this.getContentPane();
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 12;
        c01.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.weightx = 1.0;
        c11.fill = 1;
        c11.anchor = 17;
        c11.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c05 = new GridBagConstraints();
        c05.gridx = 0;
        c05.gridy = 5;
        c05.anchor = 13;
        c05.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c15 = new GridBagConstraints();
        c15.gridx = 1;
        c15.gridy = 5;
        c15.weightx = 1.0;
        c15.fill = 2;
        c15.anchor = 17;
        c15.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c06 = new GridBagConstraints();
        c06.gridx = 0;
        c06.gridy = 6;
        c06.anchor = 12;
        c06.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c16 = new GridBagConstraints();
        c16.gridx = 1;
        c16.gridy = 6;
        c16.weightx = 1.0;
        c16.anchor = 17;
        c16.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c07 = new GridBagConstraints();
        c07.gridx = 0;
        c07.gridy = 7;
        c07.anchor = 13;
        c07.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c17 = new GridBagConstraints();
        c17.gridx = 1;
        c17.gridy = 7;
        c17.anchor = 17;
        c17.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c08 = new GridBagConstraints();
        c08.gridx = 0;
        c08.gridy = 8;
        c08.anchor = 13;
        c08.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c18 = new GridBagConstraints();
        c18.gridx = 1;
        c18.gridy = 8;
        c18.anchor = 17;
        c18.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c9 = new GridBagConstraints();
        c9.gridx = 0;
        c9.gridy = 9;
        c9.gridwidth = 2;
        c9.anchor = 10;
        c9.insets = new Insets(35, 0, 10, 0);
        container.add((Component)this.lblDescription, c01);
        container.add((Component)this.spScroll, c11);
        container.add((Component)this.lblAuthor, c05);
        container.add((Component)this.tfAuthor, c15);
        container.add((Component)this.lblValue, c06);
        this.radioGroup.add(this.rbtnAffirmative);
        this.radioGroup.add(this.rbtnNeutral);
        this.radioGroup.add(this.rbtnNegative);
        this.group.add(this.rbtnAffirmative);
        this.group.add(Box.createVerticalStrut(5));
        this.group.add(this.rbtnNeutral);
        this.group.add(Box.createVerticalStrut(5));
        this.group.add(this.rbtnNegative);
        container.add((Component)this.group, c16);
        container.add((Component)this.lblCreationDate, c07);
        container.add((Component)this.lblDateCreated, c17);
        container.add((Component)this.lblLastChangeDAte, c08);
        container.add((Component)this.lblDateChanged, c18);
        container.add((Component)this.okCancelBox, c9);
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public String getAuthor() {
        return this.tfAuthor.getText();
    }

    public void setAuthor(String tfAuthor) {
        this.tfAuthor.setText(tfAuthor);
    }

    public ArgumentValue getValue() {
        if (this.rbtnAffirmative.isSelected()) {
            return ArgumentValue.ARG_AFFIRMATIVE;
        }
        if (this.rbtnNegative.isSelected()) {
            return ArgumentValue.ARG_NEGATIVE;
        }
        return ArgumentValue.ARG_NEUTRAL;
    }

    public void setValue(ArgumentValue value) {
        if (value == ArgumentValue.ARG_AFFIRMATIVE) {
            this.rbtnAffirmative.setSelected(true);
        } else if (value == ArgumentValue.ARG_NEGATIVE) {
            this.rbtnNegative.setSelected(true);
        } else {
            this.rbtnNeutral.setSelected(true);
        }
    }

    public String getDescription() {
        return this.taDescription.getText();
    }

    public void setDescription(String taDescription) {
        this.taDescription.setText(taDescription);
    }

    public void setDateCreated(String dateCreated) {
        this.lblDateCreated.setText(dateCreated);
    }

    public void setDateChanged(String dateChanged) {
        this.lblDateChanged.setText(dateChanged);
    }
}

