/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.gui.windows.PropertyWindow;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.nodes.Stakeholder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AssumptionProperties
extends PropertyWindow {
    private JLabel lblProbability = new JLabel(Messages.getString("AssumptionProperties.0"));
    private JLabel lblSource = new JLabel(Messages.getString("AssumptionProperties.1"));
    private JTextField tfProbability = new JTextField(20);
    private JComboBox cbSource = new JComboBox();
    private JTextArea taDescription = new JTextArea(5, 20);
    private JScrollPane spScroll = new JScrollPane(this.taDescription);
    private JLabel lblDescription = new JLabel(Messages.getString("AssumptionProperties.2"));
    private JLabel lblCreationDate = new JLabel(Messages.getString("AssumptionProperties.3"));
    private JLabel lblDateCreated = new JLabel("");
    private JLabel lblLastChangeDAte = new JLabel(Messages.getString("AssumptionProperties.5"));
    private JLabel lblDateChanged = new JLabel("");

    public AssumptionProperties() {
        this.taDescription.setLineWrap(true);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setTitle(Messages.getString("AssumptionProperties.7"));
        this.setDefaultCloseOperation(1);
        JTextComponent editorA = (JTextComponent)this.cbSource.getEditor().getEditorComponent();
        editorA.setDocument(new AutoCompleteCombo(this.cbSource));
        this.cbSource.setEditable(true);
        this.cbSource.setPreferredSize(new Dimension(222, 20));
        Container container = this.getContentPane();
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 12;
        c01.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.weightx = 1.0;
        c11.fill = 2;
        c11.anchor = 17;
        c11.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c05 = new GridBagConstraints();
        c05.gridx = 0;
        c05.gridy = 5;
        c05.anchor = 13;
        c05.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c15 = new GridBagConstraints();
        c15.gridx = 1;
        c15.gridy = 5;
        c15.weightx = 1.0;
        c15.fill = 2;
        c15.anchor = 17;
        c15.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c06 = new GridBagConstraints();
        c06.gridx = 0;
        c06.gridy = 6;
        c06.anchor = 13;
        c06.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c16 = new GridBagConstraints();
        c16.gridx = 1;
        c16.gridy = 6;
        c16.weightx = 1.0;
        c16.fill = 2;
        c16.anchor = 17;
        c16.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c07 = new GridBagConstraints();
        c07.gridx = 0;
        c07.gridy = 7;
        c07.anchor = 13;
        c07.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c17 = new GridBagConstraints();
        c17.gridx = 1;
        c17.gridy = 7;
        c17.anchor = 17;
        c17.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c08 = new GridBagConstraints();
        c08.gridx = 0;
        c08.gridy = 8;
        c08.anchor = 13;
        c08.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c18 = new GridBagConstraints();
        c18.gridx = 1;
        c18.gridy = 8;
        c18.anchor = 17;
        c18.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c9 = new GridBagConstraints();
        c9.gridx = 0;
        c9.gridy = 9;
        c9.weightx = 0.0;
        c9.gridwidth = 2;
        c9.anchor = 10;
        c9.insets = new Insets(35, 0, 10, 0);
        container.add((Component)this.lblDescription, c01);
        container.add((Component)this.spScroll, c11);
        container.add((Component)this.lblSource, c05);
        container.add((Component)this.cbSource, c15);
        container.add((Component)this.lblProbability, c06);
        container.add((Component)this.tfProbability, c16);
        container.add((Component)this.lblCreationDate, c07);
        container.add((Component)this.lblDateCreated, c17);
        container.add((Component)this.lblLastChangeDAte, c08);
        container.add((Component)this.lblDateChanged, c18);
        container.add((Component)this.okCancelBox, c9);
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
        this.initializeSources();
    }

    public String getProbability() {
        return this.tfProbability.getText();
    }

    public void setProbability(String tfProbability) {
        this.tfProbability.setText(tfProbability);
    }

    public String getSource() {
        if (this.cbSource.getSelectedItem() == null) {
            return "";
        }
        return this.cbSource.getSelectedItem().toString();
    }

    public void setSource(String cbSource) {
        this.cbSource.setSelectedItem(cbSource);
    }

    public String getDescription() {
        return this.taDescription.getText();
    }

    public void setDescription(String taDescription) {
        this.taDescription.setText(taDescription);
    }

    public void setDateCreated(String dateCreated) {
        this.lblDateCreated.setText(dateCreated);
    }

    public void setDateChanged(String dateChanged) {
        this.lblDateChanged.setText(dateChanged);
    }

    public void initializeSources() {
        this.cbSource.removeAllItems();
        GERMModel m = Application.getInstance().getModel();
        for (Node node : m.getNodes()) {
            if (!(node instanceof Stakeholder)) continue;
            this.cbSource.addItem(node.getName());
        }
    }

    class AutoCompleteCombo
    extends PlainDocument {
        JComboBox comboBox;
        ComboBoxModel model;
        JTextComponent editor;
        boolean selecting = false;

        public AutoCompleteCombo(final JComboBox comboBox) {
            this.comboBox = comboBox;
            this.model = comboBox.getModel();
            this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
            comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!AutoCompleteCombo.this.selecting) {
                        AutoCompleteCombo.this.highlightCompletedText(0);
                    }
                }
            });
            this.editor.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (comboBox.isDisplayable()) {
                        comboBox.setPopupVisible(false);
                    }
                }
            });
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                this.setSelectedItem(item);
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            }
        }

        private void setText(String text) throws BadLocationException {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }

        private void highlightCompletedText(int start) {
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(this.getLength());
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.model.setSelectedItem(item);
            this.selecting = false;
        }

        private Object lookupItem(String pattern) {
            Object selectedItem = this.model.getSelectedItem();
            if (selectedItem != null && this.startsWith(selectedItem.toString(), pattern)) {
                return selectedItem;
            }
            int i = 0;
            int n = this.model.getSize();
            while (i < n) {
                Object currentItem = this.model.getElementAt(i);
                if (this.startsWith(currentItem.toString(), pattern)) {
                    return currentItem;
                }
                ++i;
            }
            return null;
        }

        private boolean startsWith(String str1, String str2) {
            return str1.startsWith(str2);
        }
    }
}

