/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.i18n.Messages;
import germ.util.Cursors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorWindow
extends JDialog
implements ChangeListener {
    private JColorChooser colorChooser = new JColorChooser();
    private JButton btnOK = new JButton(Messages.getString("ColorWindow.0"));
    private JButton btnCancel = new JButton(Messages.getString("ColorWindow.1"));
    private Box okCancelBox = Box.createHorizontalBox();
    private boolean dialogResult = false;
    private Color chosenColor = null;

    public ColorWindow() {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(null);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setResizable(false);
        this.setTitle(Messages.getString("ColorWindow.2"));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow.this.escapePressed();
            }
        });
        this.colorChooser.getSelectionModel().addChangeListener(this);
        this.setLayout(new GridBagLayout());
        Container container = this.getContentPane();
        GridBagConstraints c0 = new GridBagConstraints();
        c0.gridx = 0;
        c0.gridy = 0;
        c0.weightx = 1.0;
        c0.fill = 2;
        c0.anchor = 10;
        c0.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 1;
        c1.weightx = 1.0;
        c1.anchor = 10;
        c1.insets = new Insets(20, 20, 10, 20);
        container.add((Component)this.colorChooser, c0);
        this.okCancelBox.add(this.btnOK);
        this.okCancelBox.add(Box.createHorizontalStrut(40));
        this.okCancelBox.add(this.btnCancel);
        container.add((Component)this.okCancelBox, c1);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ColorWindow.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    ColorWindow.this.enterPressed();
                }
                return false;
            }
        });
        this.setCursor(Cursors.getCursor("default"));
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public void stateChanged(ChangeEvent e) {
        this.chosenColor = this.colorChooser.getColor();
    }

    public Color getColor() {
        return this.chosenColor;
    }

    public void setColor(Color choosenColor) {
        this.chosenColor = choosenColor;
        this.colorChooser.setColor(choosenColor);
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(boolean dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void enterPressed() {
        this.setDialogResult(true);
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }
}

