/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.gui.windows.NewPodWindow;
import germ.i18n.Messages;
import germ.model.workspace.Project;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class CreateNewDiagramWindow
extends NewPodWindow {
    private JComboBox cbProjects = new JComboBox();
    private JLabel lblDiagram = new JLabel(Messages.getString("CreateNewDiagramWindow.0"));

    public CreateNewDiagramWindow() {
        super(1);
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.initializeProjects();
        Container container = this.getContentPane();
        GridBagConstraints c00 = new GridBagConstraints();
        c00.gridx = 0;
        c00.gridy = 0;
        c00.anchor = 13;
        c00.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 1;
        c10.gridy = 0;
        c10.weightx = 1.0;
        c10.fill = 2;
        c10.anchor = 17;
        c10.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 13;
        c01.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.weightx = 1.0;
        c11.fill = 2;
        c11.anchor = 17;
        c11.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 0;
        c2.gridy = 2;
        c2.gridwidth = 2;
        c2.anchor = 10;
        c2.insets = new Insets(35, 0, 10, 0);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    CreateNewDiagramWindow.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    CreateNewDiagramWindow.this.enterPressed();
                }
                return false;
            }
        });
        container.add((Component)this.lblNew, c00);
        container.add((Component)this.cbProjects, c10);
        container.add((Component)this.lblDiagram, c01);
        container.add((Component)this.tfNew, c11);
        container.add((Component)this.okCancelBox, c2);
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public void initializeProjects() {
        int projectsCount = Application.getInstance().getProjectsCount();
        List<Project> projects = Application.getInstance().getProjects();
        int i = 0;
        while (i != projectsCount) {
            this.cbProjects.addItem(projects.get(i));
            ++i;
        }
    }

    public String getProject() {
        return this.cbProjects.getSelectedItem().toString();
    }

    public void setCbProjects(String project) {
        this.cbProjects.setEditable(true);
        this.cbProjects.setSelectedItem(project);
        this.cbProjects.setEditable(false);
    }

    public void disableCbProjects() {
        this.cbProjects.setEnabled(false);
    }
}

