/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.nodes.Argument;
import germ.model.nodes.Assumption;
import germ.model.nodes.Decision;
import germ.model.nodes.Position;
import germ.model.nodes.Requirement;
import germ.model.nodes.Stakeholder;
import germ.model.nodes.Topic;
import germ.model.workspace.Project;
import germ.util.Cursors;
import germ.view.GERMView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class FindReplaceWindow
extends JDialog {
    private String[] types = new String[]{"", Messages.getString("FindReplaceWindow.1"), Messages.getString("FindReplaceWindow.2"), Messages.getString("FindReplaceWindow.3"), Messages.getString("FindReplaceWindow.4"), Messages.getString("FindReplaceWindow.5"), Messages.getString("FindReplaceWindow.6"), Messages.getString("FindReplaceWindow.7")};
    private JLabel lblFind = new JLabel(Messages.getString("FindReplaceWindow.8"));
    private JLabel lblReplace = new JLabel(Messages.getString("FindReplaceWindow.9"));
    private JLabel lblType = new JLabel(Messages.getString("FindReplaceWindow.10"));
    private JLabel lblOptions = new JLabel(Messages.getString("FindReplaceWindow.11"));
    private JComboBox cbFind = new JComboBox();
    private JComboBox cbReplace = new JComboBox();
    private JComboBox cbType = new JComboBox<String>(this.types);
    private JCheckBox chbCaseSensitive = new JCheckBox(Messages.getString("FindReplaceWindow.12"));
    private JCheckBox chbWholeWord = new JCheckBox(Messages.getString("FindReplaceWindow.13"));
    private JCheckBox chbWholeProject = new JCheckBox(Messages.getString("FindReplaceWindow.14"));
    private JButton btnFindNext = new JButton(Messages.getString("FindReplaceWindow.15"));
    private JButton btnReplace = new JButton(Messages.getString("FindReplaceWindow.16"));
    private JButton btnReplaceAll = new JButton(Messages.getString("FindReplaceWindow.17"));
    private JButton btnClose = new JButton(Messages.getString("FindReplaceWindow.18"));
    private Box upperBox = Box.createHorizontalBox();
    private Box lowerBox = Box.createHorizontalBox();
    private Box wholeBox = Box.createVerticalBox();
    private int nodeIndex = 0;
    private GERMModel currentDiagram = Application.getInstance().getModel();
    private Project currentProject = this.currentDiagram.getProject();
    private int startingDiagramIndex;
    private int newDiagram = this.startingDiagramIndex = this.currentProject.getDiagramIndex(this.currentDiagram);
    private int diagramIndex = this.startingDiagramIndex;
    private int diagramCount = this.currentProject.getDiagramCount();
    private ArrayList<String> pReplaces = Application.getInstance().getPreviousRaplaces();
    private ArrayList<String> pFinds = Application.getInstance().getPreviousFinds();

    public FindReplaceWindow() {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        JTextComponent editorF = (JTextComponent)this.cbFind.getEditor().getEditorComponent();
        JTextComponent editorR = (JTextComponent)this.cbReplace.getEditor().getEditorComponent();
        editorF.setDocument(new AutoCompleteCombo(this.cbFind));
        editorR.setDocument(new AutoCompleteCombo(this.cbReplace));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setTitle(Messages.getString("FindReplaceWindow.19"));
        this.setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(1);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.cbFind.setEditable(true);
        this.cbReplace.setEditable(true);
        this.initializeComboBoxes();
        Container container = this.getContentPane();
        GridBagConstraints c00 = new GridBagConstraints();
        c00.gridx = 0;
        c00.gridy = 0;
        c00.anchor = 13;
        c00.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 1;
        c10.gridy = 0;
        c10.weightx = 1.0;
        c10.fill = 2;
        c10.anchor = 17;
        c10.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 13;
        c01.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.weightx = 1.0;
        c11.fill = 2;
        c11.anchor = 17;
        c11.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c02 = new GridBagConstraints();
        c02.gridx = 0;
        c02.gridy = 2;
        c02.anchor = 13;
        c02.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c12 = new GridBagConstraints();
        c12.gridx = 1;
        c12.gridy = 2;
        c12.weightx = 1.0;
        c12.fill = 2;
        c12.anchor = 17;
        c12.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 0;
        c3.gridy = 3;
        c3.gridwidth = 2;
        c3.anchor = 17;
        c3.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c4 = new GridBagConstraints();
        c4.gridx = 0;
        c4.gridy = 4;
        c4.gridwidth = 2;
        c4.anchor = 17;
        c4.insets = new Insets(0, 75, 0, 0);
        GridBagConstraints c5 = new GridBagConstraints();
        c5.gridx = 0;
        c5.gridy = 5;
        c5.gridwidth = 2;
        c5.anchor = 17;
        c5.insets = new Insets(0, 75, 0, 0);
        GridBagConstraints c6 = new GridBagConstraints();
        c6.gridx = 0;
        c6.gridy = 6;
        c6.gridwidth = 2;
        c6.anchor = 17;
        c6.insets = new Insets(0, 75, 0, 0);
        GridBagConstraints c7 = new GridBagConstraints();
        c7.gridx = 0;
        c7.gridy = 7;
        c7.gridwidth = 2;
        c7.anchor = 10;
        c7.insets = new Insets(35, 20, 10, 20);
        this.upperBox.add(Box.createHorizontalGlue());
        this.upperBox.add(this.btnFindNext);
        this.upperBox.add(Box.createHorizontalStrut(20));
        this.upperBox.add(this.btnReplace);
        this.upperBox.add(Box.createHorizontalGlue());
        this.lowerBox.add(Box.createHorizontalGlue());
        this.lowerBox.add(this.btnReplaceAll);
        this.lowerBox.add(Box.createHorizontalStrut(20));
        this.lowerBox.add(this.btnClose);
        this.lowerBox.add(Box.createHorizontalGlue());
        this.wholeBox.add(this.upperBox);
        this.wholeBox.add(Box.createVerticalStrut(15));
        this.wholeBox.add(this.lowerBox);
        container.add((Component)this.lblFind, c00);
        container.add((Component)this.cbFind, c10);
        container.add((Component)this.lblReplace, c01);
        container.add((Component)this.cbReplace, c11);
        container.add((Component)this.lblType, c02);
        container.add((Component)this.cbType, c12);
        container.add((Component)this.lblOptions, c3);
        container.add((Component)this.chbCaseSensitive, c4);
        container.add((Component)this.chbWholeWord, c5);
        container.add((Component)this.chbWholeProject, c6);
        container.add((Component)this.wholeBox, c7);
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceWindow.this.escapePressed();
            }
        });
        this.btnFindNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceWindow.this.findNext();
            }
        });
        this.btnReplace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String find = FindReplaceWindow.this.getFind();
                    String replace = FindReplaceWindow.this.getReplace();
                    if (!FindReplaceWindow.this.pReplaces.contains(replace)) {
                        FindReplaceWindow.this.pReplaces.add(replace);
                    }
                    GERMModel m = Application.getInstance().getModel();
                    Node node = m.getSelectedNodes().get(0);
                    String name = node.getName().toLowerCase();
                    String newName = name.replaceAll(find.toLowerCase(), replace);
                    node.setName(newName);
                    node.setLastChangeDate(Calendar.getInstance());
                    m.updatePerformed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnReplaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!FindReplaceWindow.this.pReplaces.contains(FindReplaceWindow.this.getReplace())) {
                    FindReplaceWindow.this.pReplaces.add(FindReplaceWindow.this.getReplace());
                }
                if (!FindReplaceWindow.this.pFinds.contains(FindReplaceWindow.this.getFind())) {
                    FindReplaceWindow.this.pFinds.add(FindReplaceWindow.this.getFind());
                }
                FindReplaceWindow.this.replaceAll();
            }
        });
        ChangeListener change = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FindReplaceWindow.this.nodeIndex = 0;
            }
        };
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceWindow.this.nodeIndex = 0;
            }
        };
        this.chbCaseSensitive.addChangeListener(change);
        this.chbWholeProject.addChangeListener(change);
        this.chbWholeWord.addChangeListener(change);
        this.cbFind.addActionListener(action);
        this.cbType.addActionListener(action);
        this.cbReplace.addActionListener(action);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    FindReplaceWindow.this.escapePressed();
                }
                return false;
            }
        });
        this.setCursor(Cursors.getCursor(Messages.getString("FindReplaceWindow.20")));
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public String getFind() {
        return this.cbFind.getSelectedItem().toString();
    }

    public String getReplace() {
        return this.cbReplace.getSelectedItem().toString();
    }

    public String getType() {
        return this.cbType.getSelectedItem().toString();
    }

    public boolean isCaseSensitive() {
        return this.chbCaseSensitive.isSelected();
    }

    public boolean isWholeWord() {
        return this.chbWholeWord.isSelected();
    }

    public boolean isWholeProject() {
        return this.chbWholeProject.isSelected();
    }

    public void findNext() {
        block31: {
            boolean caseSensitive;
            boolean wholeWord;
            GERMView v;
            String find;
            int type;
            block32: {
                block35: {
                    block33: {
                        block34: {
                            type = this.cbType.getSelectedIndex();
                            find = this.getFind();
                            v = Application.getInstance().getView();
                            boolean wholeProject = this.isWholeProject();
                            wholeWord = this.isWholeWord();
                            caseSensitive = this.isCaseSensitive();
                            if (find.length() == 0) break block31;
                            if (!this.pFinds.contains(find)) {
                                this.pFinds.add(find);
                            }
                            if (wholeProject) break block32;
                            if (wholeWord) break block33;
                            if (caseSensitive) break block34;
                            int i = this.nodeIndex;
                            while (i != this.currentDiagram.getNodeCount()) {
                                ++this.nodeIndex;
                                Node node = this.currentDiagram.getNodeAt(i);
                                if (this.checkType(node, type) && node.getName().toLowerCase().contains(find.toLowerCase())) {
                                    this.currentDiagram.deselectAllNodes();
                                    this.currentDiagram.selectNode(node);
                                    v.centerNode(node);
                                    break;
                                }
                                ++i;
                            }
                            if (this.nodeIndex + 1 < this.currentDiagram.getNodeCount()) break block31;
                            this.nodeIndex = 0;
                            JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("FindReplaceWindow.21"), Messages.getString("FindReplaceWindow.22"), 1);
                            this.btnReplace.setEnabled(false);
                            break block31;
                        }
                        int i = this.nodeIndex;
                        while (i != this.currentDiagram.getNodeCount()) {
                            ++this.nodeIndex;
                            Node node = this.currentDiagram.getNodeAt(i);
                            if (this.checkType(node, type) && node.getName().contains(find)) {
                                this.currentDiagram.deselectAllNodes();
                                this.currentDiagram.selectNode(node);
                                v.centerNode(node);
                                break;
                            }
                            ++i;
                        }
                        if (this.nodeIndex + 1 < this.currentDiagram.getNodeCount()) break block31;
                        this.nodeIndex = 0;
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("FindReplaceWindow.23"), Messages.getString("FindReplaceWindow.22"), 1);
                        this.btnReplace.setEnabled(false);
                        break block31;
                    }
                    if (caseSensitive) break block35;
                    int i = this.nodeIndex;
                    while (i != this.currentDiagram.getNodeCount()) {
                        ++this.nodeIndex;
                        Node node = this.currentDiagram.getNodeAt(i);
                        if (this.checkType(node, type) && node.getName().toLowerCase().equals(find.toLowerCase())) {
                            this.currentDiagram.deselectAllNodes();
                            this.currentDiagram.selectNode(node);
                            v.centerNode(node);
                            break;
                        }
                        ++i;
                    }
                    if (this.nodeIndex + 1 < this.currentDiagram.getNodeCount()) break block31;
                    this.nodeIndex = 0;
                    JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("FindReplaceWindow.25"), Messages.getString("FindReplaceWindow.22"), 1);
                    this.btnReplace.setEnabled(false);
                    break block31;
                }
                int i = this.nodeIndex;
                while (i != this.currentDiagram.getNodeCount()) {
                    ++this.nodeIndex;
                    Node node = this.currentDiagram.getNodeAt(i);
                    if (this.checkType(node, type) && node.getName().equals(find)) {
                        this.currentDiagram.deselectAllNodes();
                        this.currentDiagram.selectNode(node);
                        v.centerNode(node);
                        break;
                    }
                    ++i;
                }
                if (this.nodeIndex + 1 < this.currentDiagram.getNodeCount()) break block31;
                this.nodeIndex = 0;
                JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("FindReplaceWindow.27"), Messages.getString("FindReplaceWindow.22"), 1);
                this.btnReplace.setEnabled(false);
                break block31;
            }
            if (!wholeWord) {
                if (!caseSensitive) {
                    if (this.nodeIndex >= this.currentDiagram.getNodeCount()) {
                        this.newDiagram = this.changeDiagram(++this.diagramIndex);
                    }
                    int i = this.nodeIndex;
                    while (i != this.currentDiagram.getNodeCount()) {
                        ++this.nodeIndex;
                        Node node = this.currentDiagram.getNodeAt(i);
                        if (this.checkType(node, type) && node.getName().toLowerCase().contains(find.toLowerCase())) {
                            if (Application.getInstance().getModel() != this.currentProject.getDiagram(this.newDiagram)) {
                                Application.getInstance().setModel(this.currentProject.getDiagram(this.newDiagram));
                            }
                            this.currentDiagram.deselectAllNodes();
                            this.currentDiagram.selectNode(node);
                            v.centerNode(node);
                            break;
                        }
                        ++i;
                    }
                } else {
                    if (this.nodeIndex >= this.currentDiagram.getNodeCount()) {
                        this.newDiagram = this.changeDiagram(++this.diagramIndex);
                    }
                    int i = this.nodeIndex;
                    while (i != this.currentDiagram.getNodeCount()) {
                        ++this.nodeIndex;
                        Node node = this.currentDiagram.getNodeAt(i);
                        if (this.checkType(node, type) && node.getName().contains(find)) {
                            if (Application.getInstance().getModel() != this.currentProject.getDiagram(this.newDiagram)) {
                                Application.getInstance().setModel(this.currentProject.getDiagram(this.newDiagram));
                            }
                            this.currentDiagram.deselectAllNodes();
                            this.currentDiagram.selectNode(node);
                            v.centerNode(node);
                            break;
                        }
                        ++i;
                    }
                }
            } else if (!caseSensitive) {
                if (this.nodeIndex >= this.currentDiagram.getNodeCount()) {
                    this.newDiagram = this.changeDiagram(++this.diagramIndex);
                }
                int i = this.nodeIndex;
                while (i != this.currentDiagram.getNodeCount()) {
                    ++this.nodeIndex;
                    Node node = this.currentDiagram.getNodeAt(i);
                    if (this.checkType(node, type) && node.getName().toLowerCase().equals(find.toLowerCase())) {
                        if (Application.getInstance().getModel() != this.currentProject.getDiagram(this.newDiagram)) {
                            Application.getInstance().setModel(this.currentProject.getDiagram(this.newDiagram));
                        }
                        this.currentDiagram.deselectAllNodes();
                        this.currentDiagram.selectNode(node);
                        v.centerNode(node);
                        break;
                    }
                    ++i;
                }
            } else {
                if (this.nodeIndex >= this.currentDiagram.getNodeCount()) {
                    this.newDiagram = this.changeDiagram(++this.diagramIndex);
                }
                int i = this.nodeIndex;
                while (i != this.currentDiagram.getNodeCount()) {
                    ++this.nodeIndex;
                    Node node = this.currentDiagram.getNodeAt(i);
                    if (this.checkType(node, type) && node.getName().equals(find)) {
                        if (Application.getInstance().getModel() != this.currentProject.getDiagram(this.newDiagram)) {
                            Application.getInstance().setModel(this.currentProject.getDiagram(this.newDiagram));
                        }
                        this.currentDiagram.deselectAllNodes();
                        this.currentDiagram.selectNode(node);
                        v.centerNode(node);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public boolean checkType(Node node, int type) {
        boolean adequateType = true;
        switch (type) {
            case 0: {
                adequateType = true;
                break;
            }
            case 1: {
                if (node instanceof Argument) {
                    adequateType = true;
                    break;
                }
                adequateType = false;
                break;
            }
            case 2: {
                if (node instanceof Assumption) {
                    adequateType = true;
                    break;
                }
                adequateType = false;
                break;
            }
            case 3: {
                if (node instanceof Decision) {
                    adequateType = true;
                    break;
                }
                adequateType = false;
                break;
            }
            case 4: {
                if (node instanceof Position) {
                    adequateType = true;
                    break;
                }
                adequateType = false;
                break;
            }
            case 5: {
                if (node instanceof Requirement) {
                    adequateType = true;
                    break;
                }
                adequateType = false;
                break;
            }
            case 6: {
                if (node instanceof Stakeholder) {
                    adequateType = true;
                    break;
                }
                adequateType = false;
                break;
            }
            case 7: {
                adequateType = node instanceof Topic;
            }
        }
        return adequateType;
    }

    public void replaceAll() {
        int replacedNodes = 0;
        String find = this.getFind();
        String replace = this.getReplace();
        boolean wholeProject = this.isWholeProject();
        boolean wholeWord = this.isWholeWord();
        boolean caseSensitive = this.isCaseSensitive();
        int type = this.cbType.getSelectedIndex();
        if (find.length() != 0) {
            GERMModel m = Application.getInstance().getModel();
            if (!wholeProject) {
                if (caseSensitive) {
                    if (wholeWord) {
                        int i = this.nodeIndex;
                        while (i != m.getNodeCount()) {
                            Node node = m.getNodeAt(i);
                            if (this.checkType(node, type) && node.getName().equals(find)) {
                                String name = node.getName().toLowerCase();
                                String newName = name.replaceAll(find.toLowerCase(), replace);
                                node.setName(newName);
                                node.setLastChangeDate(Calendar.getInstance());
                                ++replacedNodes;
                            }
                            ++i;
                        }
                    } else {
                        int i = this.nodeIndex;
                        while (i != m.getNodeCount()) {
                            ++this.nodeIndex;
                            Node node = m.getNodeAt(i);
                            if (this.checkType(node, type) && node.getName().contains(find)) {
                                String name = node.getName().toLowerCase();
                                String newName = name.replaceAll(find.toLowerCase(), replace);
                                node.setName(newName);
                                node.setLastChangeDate(Calendar.getInstance());
                                ++replacedNodes;
                            }
                            ++i;
                        }
                    }
                } else if (wholeWord) {
                    int i = this.nodeIndex;
                    while (i != m.getNodeCount()) {
                        ++this.nodeIndex;
                        Node node = m.getNodeAt(i);
                        if (this.checkType(node, type) && node.getName().toLowerCase().equals(find.toLowerCase())) {
                            String name = node.getName().toLowerCase();
                            String newName = name.replaceAll(find.toLowerCase(), replace);
                            node.setName(newName);
                            node.setLastChangeDate(Calendar.getInstance());
                            ++replacedNodes;
                        }
                        ++i;
                    }
                } else {
                    int i = this.nodeIndex;
                    while (i != m.getNodeCount()) {
                        ++this.nodeIndex;
                        Node node = m.getNodeAt(i);
                        if (this.checkType(node, type) && node.getName().toLowerCase().contains(find.toLowerCase())) {
                            String name = node.getName().toLowerCase();
                            String newName = name.replaceAll(find.toLowerCase(), replace);
                            node.setName(newName);
                            node.setLastChangeDate(Calendar.getInstance());
                            ++replacedNodes;
                        }
                        ++i;
                    }
                }
            } else if (caseSensitive) {
                if (wholeWord) {
                    int j = 0;
                    while (j != this.diagramCount) {
                        m = this.currentProject.getDiagram(j);
                        int i = this.nodeIndex = 0;
                        while (i != m.getNodeCount()) {
                            Node node = m.getNodeAt(i);
                            if (this.checkType(node, type) && node.getName().equals(this.getFind())) {
                                String name = node.getName().toLowerCase();
                                String newName = name.replaceAll(find.toLowerCase(), replace);
                                node.setName(newName);
                                node.setLastChangeDate(Calendar.getInstance());
                                ++replacedNodes;
                            }
                            ++i;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j != this.diagramCount) {
                        m = this.currentProject.getDiagram(j);
                        int i = this.nodeIndex = 0;
                        while (i != m.getNodeCount()) {
                            ++this.nodeIndex;
                            Node node = m.getNodeAt(i);
                            if (this.checkType(node, type) && node.getName().contains(this.getFind())) {
                                String name = node.getName().toLowerCase();
                                String newName = name.replaceAll(find.toLowerCase(), replace);
                                node.setName(newName);
                                node.setLastChangeDate(Calendar.getInstance());
                                ++replacedNodes;
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            } else if (wholeWord) {
                int j = 0;
                while (j != this.diagramCount) {
                    m = this.currentProject.getDiagram(j);
                    int i = this.nodeIndex = 0;
                    while (i != m.getNodeCount()) {
                        ++this.nodeIndex;
                        Node node = m.getNodeAt(i);
                        if (this.checkType(node, type) && node.getName().toLowerCase().equals(this.getFind().toLowerCase())) {
                            String name = node.getName().toLowerCase();
                            String newName = name.replaceAll(find.toLowerCase(), replace);
                            node.setName(newName);
                            node.setLastChangeDate(Calendar.getInstance());
                            ++replacedNodes;
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j != this.diagramCount) {
                    m = this.currentProject.getDiagram(j);
                    int i = this.nodeIndex = 0;
                    while (i != m.getNodeCount()) {
                        ++this.nodeIndex;
                        Node node = m.getNodeAt(i);
                        if (this.checkType(node, type) && node.getName().toLowerCase().contains(this.getFind().toLowerCase())) {
                            String name = node.getName().toLowerCase();
                            String newName = name.replaceAll(find.toLowerCase(), replace);
                            node.setName(newName);
                            node.setLastChangeDate(Calendar.getInstance());
                            ++replacedNodes;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            JOptionPane.showMessageDialog(Application.getInstance().getView(), String.valueOf(Messages.getString("FindReplaceWindow.29")) + replacedNodes + Messages.getString("FindReplaceWindow.30"), Messages.getString("FindReplaceWindow.22"), 1);
            m.updatePerformed();
        }
    }

    public void initializeComboBoxes() {
        this.cbFind.removeAllItems();
        this.cbReplace.removeAllItems();
        if (this.pFinds.size() > 0) {
            int i = this.pFinds.size() - 1;
            while (i != -1) {
                this.cbFind.addItem(this.pFinds.get(i));
                --i;
            }
            this.cbFind.setSelectedIndex(i);
        } else {
            this.cbFind.setSelectedItem("");
        }
        if (this.pReplaces.size() > 0) {
            int j = this.pReplaces.size() - 1;
            while (j != -1) {
                this.cbReplace.addItem(this.pReplaces.get(j));
                --j;
            }
            this.cbReplace.setSelectedIndex(j);
        } else {
            this.cbReplace.setSelectedItem("");
        }
    }

    public int changeDiagram(int index) {
        GERMModel nextDiagram;
        int nextDiagramIndex = 0;
        this.nodeIndex = 0;
        nextDiagramIndex = index > this.diagramCount - 1 ? index - this.diagramCount : index;
        if (nextDiagramIndex == this.startingDiagramIndex) {
            JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("FindReplaceWindow.34"), Messages.getString("FindReplaceWindow.22"), 1);
            this.btnReplace.setEnabled(false);
            return this.startingDiagramIndex;
        }
        this.currentDiagram = nextDiagram = Application.getInstance().getModel().getProject().getDiagram(nextDiagramIndex);
        return nextDiagramIndex;
    }

    public void escapePressed() {
        this.nodeIndex = 0;
        this.setVisible(false);
    }

    class AutoCompleteCombo
    extends PlainDocument {
        JComboBox comboBox;
        ComboBoxModel model;
        JTextComponent editor;
        boolean selecting = false;

        public AutoCompleteCombo(final JComboBox comboBox) {
            this.comboBox = comboBox;
            this.model = comboBox.getModel();
            this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
            comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!AutoCompleteCombo.this.selecting) {
                        AutoCompleteCombo.this.highlightCompletedText(0);
                    }
                }
            });
            this.editor.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (comboBox.isDisplayable()) {
                        comboBox.setPopupVisible(false);
                    }
                }
            });
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                this.setSelectedItem(item);
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            }
        }

        private void setText(String text) throws BadLocationException {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }

        private void highlightCompletedText(int start) {
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(this.getLength());
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.model.setSelectedItem(item);
            this.selecting = false;
        }

        private Object lookupItem(String pattern) {
            Object selectedItem = this.model.getSelectedItem();
            if (selectedItem != null && this.startsWith(selectedItem.toString(), pattern)) {
                return selectedItem;
            }
            int i = 0;
            int n = this.model.getSize();
            while (i < n) {
                Object currentItem = this.model.getElementAt(i);
                if (this.startsWith(currentItem.toString(), pattern)) {
                    return currentItem;
                }
                ++i;
            }
            return null;
        }

        private boolean startsWith(String str1, String str2) {
            return str1.startsWith(str2);
        }
    }
}

