/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.MainWindow;
import germ.gui.windows.WorkspaceChooserWindow;
import germ.model.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class GERMSplashScreen
extends JWindow {
    private JProgressBar progressBar = new JProgressBar();
    private int sleepTime = 100;

    public GERMSplashScreen() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(6);
    }

    public void showSplash() {
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(Color.white);
        int width = 520;
        int height = 230;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.setBounds(x, y, width, height);
        JLabel label = new JLabel(new ImageIcon("germ/gui/windows/images/novi.png"));
        content.add((Component)label, "Center");
        content.add((Component)this.progressBar, "South");
        this.toFront();
        this.setVisible(true);
        try {
            this.progressBar.setValue(0);
            Thread.sleep(this.sleepTime);
            ConfigurationManager cm = ConfigurationManager.getInstance();
            String themesFolderPath = "germ/actions/images";
            ArrayList<String> themes = new ArrayList<String>();
            File themesFolder = new File(themesFolderPath);
            String[] stringArray = themesFolder.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String theme = stringArray[n2];
                File f = new File(themesFolder + "/" + theme);
                if (f.isDirectory() && !theme.startsWith(".")) {
                    themes.add(theme);
                }
                ++n2;
            }
            this.progressBar.setValue(1);
            Thread.sleep(this.sleepTime);
            cm.setStringArray("allThemes", themes);
            this.progressBar.setValue(2);
            Thread.sleep(this.sleepTime);
            Class.forName("germ.util.Cursors");
            this.progressBar.setValue(3);
            Thread.sleep(this.sleepTime);
            Class.forName("germ.gui.workspace.CustomIconRenderer");
            this.progressBar.setValue(4);
            Thread.sleep(this.sleepTime);
            Class.forName("germ.configuration.ConfigurationManager");
            this.progressBar.setValue(5);
            Thread.sleep(this.sleepTime);
            String possibleWorkspace = ConfigurationManager.getInstance().getString("workspace");
            if (!ConfigurationManager.getInstance().getBoolean("defaultWorkspace") || !Workspace.isValidWorkspace(possibleWorkspace)) {
                WorkspaceChooserWindow wcw = new WorkspaceChooserWindow();
                this.setAlwaysOnTop(false);
                this.toBack();
                wcw.setAlwaysOnTop(true);
                wcw.setVisible(true);
                wcw.toFront();
                if (wcw.isDialogResult()) {
                    MainWindow mw = Application.getInstance().getMainWindow();
                    mw.setDefaultCloseOperation(0);
                    mw.setAlwaysOnTop(true);
                    mw.setSize(1024, 768);
                    mw.setVisible(true);
                    mw.setAlwaysOnTop(false);
                    mw.setLocationRelativeTo(null);
                } else {
                    System.exit(0);
                }
            } else {
                MainWindow mw = Application.getInstance().getMainWindow();
                mw.setDefaultCloseOperation(0);
                mw.setAlwaysOnTop(true);
                mw.setSize(1024, 768);
                mw.setVisible(true);
                mw.setAlwaysOnTop(false);
                mw.setLocationRelativeTo(null);
            }
            Application.getInstance();
            this.progressBar.setValue(6);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.setVisible(false);
    }
}

