/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.actions.ActionManager;
import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.ColorWindow;
import germ.gui.windows.TimerThread;
import germ.gui.workspace.WorkspaceTree;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.util.Cursors;
import germ.view.GERMView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow
extends JFrame {
    private Application app;
    private JMenuBar menu;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu addMenu;
    private JMenu viewMenu;
    private JMenu settingsMenu;
    private JMenu selectMenu;
    private JMenu helpMenu;
    private JPopupMenu popupMenu;
    private JPopupMenu tabPop;
    private JPopupMenu treePopNode;
    private JPopupMenu treePopDiagram;
    private JPopupMenu treePopProject;
    private JPopupMenu treePopWorkspace;
    private JToolBar toolbarMain;
    private JToolBar toolbarElements;
    private JPanel statusBar;
    private String statusBarBackup = "";
    private JSplitPane spliter;
    private JTabbedPane tabs;
    private JSlider zoomSlide;
    private ActionManager actionManager;
    private GERMView view;
    private Integer scrollOffsetX = 0;
    private Integer scrollOffsetY = 0;
    TimerThread timerThread;
    JPanel viewPanel;
    private JLabel[] labels;
    public transient ColorWindow colorWindow;

    public MainWindow(Application app, ActionManager actionManager, GERMView view, WorkspaceTree tree) {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.app = app;
        this.actionManager = actionManager;
        this.view = view;
        this.initialiseMenu();
        this.initialiseToolBar();
        this.initialiseStatusBar();
        this.initializeTabs();
        this.colorWindow = new ColorWindow();
        this.tabPop = new JPopupMenu();
        this.tabPop.add(actionManager.getTabCloseAction());
        this.tabPop.add(actionManager.getTabCloseOthersAction());
        this.tabPop.addSeparator();
        this.tabPop.add(actionManager.getRenameDiagramAction());
        this.tabPop.add(actionManager.getDeleteDiagramAction());
        this.spliter = new JSplitPane(1);
        this.spliter.setDividerLocation(ConfigurationManager.getInstance().getInt("treeSize"));
        this.spliter.add(new JScrollPane(tree));
        this.spliter.add(this.tabs);
        this.getContentPane().add(this.spliter);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                if (MainWindow.this.view != null) {
                    MainWindow.this.view.requestFocusInWindow();
                }
            }

            public void windowClosing(WindowEvent e) {
                Application.getInstance().shutdown();
            }
        });
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    Application.getInstance().getStateMachine().keyPressed(e);
                }
                return false;
            }
        });
        this.timerThread = new TimerThread(this.scrollOffsetX, this.scrollOffsetY);
        this.timerThread.start();
        this.setCursor(Cursors.getCursor("default"));
        this.setExtendedState(this.getExtendedState() | 6);
    }

    private String getTabName(GERMModel m) {
        return String.valueOf(m.getName()) + " " + (m.isChanged() ? "*" : "");
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public JPopupMenu getTreePopNode() {
        return this.treePopNode;
    }

    public JPopupMenu getTreePopDiagram() {
        return this.treePopDiagram;
    }

    public JPopupMenu getTreePopProject() {
        return this.treePopProject;
    }

    public JPopupMenu getTreePopWorkspace() {
        return this.treePopWorkspace;
    }

    public JSlider getZoomSlide() {
        return this.zoomSlide;
    }

    public JSplitPane getSpliter() {
        return this.spliter;
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    public ArrayList<GERMView> getViewsInTabs() {
        ArrayList<GERMView> views = new ArrayList<GERMView>();
        int i = 0;
        while (i < this.tabs.getTabCount()) {
            GERMView view = (GERMView)((JPanel)this.tabs.getComponent(i)).getComponent(2);
            views.add(view);
            ++i;
        }
        return views;
    }

    public void setTabs(ArrayList<GERMView> views) {
        for (GERMView view : views) {
            this.addDiagram(view);
        }
    }

    private void initializeTabs() {
        this.tabs = new JTabbedPane();
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTabbedPane source = (JTabbedPane)e.getSource();
                JPanel viewPanel = (JPanel)source.getSelectedComponent();
                GERMView view = (GERMView)viewPanel.getComponent(2);
                MainWindow.this.view = view;
                MainWindow.this.app.diagramChanged(view.getModel());
                MainWindow.this.app.getStateMachine().modelChanged();
                view.getModel().getCommandManager().refreshUndoRedoButtons(MainWindow.this.app);
                view.getModel().updateActionButtons(MainWindow.this.app);
            }
        });
        this.tabs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    Application.getInstance().getActionManager().getDeleteDiagramAction().setDiagram(Application.getInstance().getModel());
                    MainWindow.this.tabPop.show(MainWindow.this.tabs, e.getX(), e.getY());
                }
                if (e.getButton() == 2 && MainWindow.this.tabs.getComponentCount() > 1) {
                    MainWindow.this.tabs.remove(MainWindow.this.tabs.getSelectedIndex());
                }
            }
        });
    }

    public int getTab(GERMView view) {
        Component[] components = this.tabs.getComponents();
        int i = 0;
        while (i < components.length) {
            JPanel panel = (JPanel)components[i];
            if (panel.getComponent(2) == view) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public GERMView getTab() {
        return (GERMView)((JPanel)this.tabs.getSelectedComponent()).getComponent(2);
    }

    public void addDiagram(GERMView view) {
        int tab = this.getTab(view);
        if (tab != -1) {
            this.tabs.setSelectedIndex(tab);
        } else {
            JPanel viewPanel = this.createViewPanel(view);
            this.tabs.addTab(this.getTabName(view.getModel()), viewPanel);
            this.tabs.setSelectedComponent(viewPanel);
            view.getModel().getCommandManager().refreshUndoRedoButtons(this.app);
            view.getModel().updateActionButtons(this.app);
        }
    }

    private JPanel createViewPanel(GERMView view) {
        JPanel viewPanel = new JPanel(new BorderLayout());
        JScrollBar hbar = new JScrollBar(0, 25, 50, 0, 100);
        JScrollBar vbar = new JScrollBar(1, 25, 50, 0, 100);
        vbar.addAdjustmentListener(new ScrollController(1));
        hbar.addAdjustmentListener(new ScrollController(2));
        vbar.addMouseListener(new ScrollMouseListener(vbar));
        hbar.addMouseListener(new ScrollMouseListener(hbar));
        viewPanel.add((Component)hbar, "South");
        viewPanel.add((Component)vbar, "East");
        viewPanel.add(view);
        return viewPanel;
    }

    public void closeAllButLastTab() {
        int i = 0;
        while (i < this.tabs.getComponentCount() - 1) {
            this.tabs.remove(i);
            ++i;
        }
    }

    public void renameDiagram(GERMModel newDiagram) {
        int tab = this.getTab(newDiagram.getView());
        if (tab != -1) {
            this.tabs.setTitleAt(tab, this.getTabName(newDiagram));
        }
    }

    private void initialiseToolBar() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.toolbarMain = new JToolBar();
        this.toolbarElements = new JToolBar();
        this.toolbarMain.add(this.actionManager.getFileSaveAction());
        this.toolbarMain.addSeparator();
        this.toolbarMain.add(this.actionManager.getUndoAction());
        this.toolbarMain.add(this.actionManager.getRedoAction());
        this.toolbarMain.addSeparator();
        this.toolbarMain.add(this.actionManager.getCutAction());
        this.toolbarMain.add(this.actionManager.getCopyAction());
        this.toolbarMain.add(this.actionManager.getPasteAction());
        this.toolbarMain.add(this.actionManager.getDeleteAction());
        this.toolbarMain.addSeparator();
        this.toolbarMain.add(this.actionManager.getZoomAction());
        this.toolbarMain.add(this.actionManager.getZoomBestFitAction());
        this.toolbarMain.add(this.actionManager.getZoomBestFitSelectionAction());
        this.toolbarMain.add(this.actionManager.getZoomLasoAction());
        this.toolbarMain.addSeparator();
        this.zoomSlide = new JSlider(0, -100, 100, 0);
        this.zoomSlide.addMouseListener(new ZoomSlideListener(this.zoomSlide));
        this.zoomSlide.addChangeListener(new ZoomSliderController());
        this.zoomSlide.setSnapToTicks(true);
        this.toolbarMain.addSeparator();
        this.toolbarMain.add(this.zoomSlide);
        this.toolbarMain.add(Box.createHorizontalGlue());
        this.toolbarElements.add(this.actionManager.getArgumentAction());
        this.toolbarElements.add(this.actionManager.getAssumptionAction());
        this.toolbarElements.add(this.actionManager.getDecisionAction());
        this.toolbarElements.add(this.actionManager.getPositionAction());
        this.toolbarElements.add(this.actionManager.getRequirementAction());
        this.toolbarElements.add(this.actionManager.getStakeholderAction());
        this.toolbarElements.add(this.actionManager.getTopicAction());
        this.toolbarElements.addSeparator();
        this.toolbarElements.add(this.actionManager.getLinkAction());
        this.toolbarMain.setAlignmentX(0.0f);
        this.toolbarElements.setAlignmentX(0.0f);
        panel.add(this.toolbarMain);
        panel.add(this.toolbarElements);
        this.getContentPane().add((Component)panel, "North");
    }

    public void stopScroll() {
        if (this.timerThread.getOffsetX() != 0 || this.timerThread.getOffsetY() != 0) {
            this.timerThread.setOffset(0, 0);
            JPanel p = (JPanel)this.tabs.getComponent(this.getTab(this.getTab()));
            ((JScrollBar)p.getComponent(0)).setValue(25);
            ((JScrollBar)p.getComponent(1)).setValue(25);
        }
    }

    private void initialiseStatusBar() {
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new BoxLayout(this.statusBar, 0));
        this.labels = new JLabel[3];
        this.labels[0] = new JLabel(Messages.getString("MainWindow.2"));
        this.labels[1] = new JLabel(" ");
        this.labels[2] = new JLabel("<Default State>");
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.statusBar.add(this.labels[0]);
        this.statusBar.add(Box.createHorizontalGlue());
        this.statusBar.add(this.labels[1]);
        this.statusBar.add(Box.createHorizontalGlue());
        this.statusBar.add(this.labels[2]);
        this.statusBar.add(Box.createHorizontalStrut(5));
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    private void initialiseMenu() {
        this.menu = new JMenuBar();
        this.fileMenu = new JMenu(Messages.getString("MainWindow.5"));
        this.fileMenu.setMnemonic(70);
        this.editMenu = new JMenu(Messages.getString("MainWindow.6"));
        this.editMenu.setMnemonic(69);
        this.addMenu = new JMenu(Messages.getString("MainWindow.7"));
        this.addMenu.setMnemonic(68);
        this.viewMenu = new JMenu(Messages.getString("MainWindow.8"));
        this.viewMenu.setMnemonic(86);
        this.selectMenu = new JMenu(Messages.getString("MainWindow.9"));
        this.selectMenu.setMnemonic(83);
        this.settingsMenu = new JMenu(Messages.getString("MainWindow.10"));
        this.settingsMenu.setMnemonic(84);
        this.helpMenu = new JMenu(Messages.getString("MainWindow.11"));
        this.helpMenu.setMnemonic(72);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.actionManager.getCutAction());
        this.popupMenu.add(this.actionManager.getCopyAction());
        this.popupMenu.add(this.actionManager.getPasteAction());
        this.popupMenu.add(this.actionManager.getDeleteAction());
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.actionManager.getOpenSubDiagramAction());
        this.popupMenu.add(this.actionManager.getFlipAction());
        this.popupMenu.add(this.actionManager.getSelectLinkedAction());
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.actionManager.getShowPropertyAction());
        this.popupMenu.add(this.actionManager.getShowColorPropertiesAction());
        this.initializeTreePopupMenus();
        JMenu zoomMenu = new JMenu(Messages.getString("MainWindow.12"));
        zoomMenu.add(this.actionManager.getZoomAction());
        zoomMenu.add(this.actionManager.getZoomBestFitAction());
        zoomMenu.add(this.actionManager.getZoomBestFitSelectionAction());
        zoomMenu.add(this.actionManager.getZoomLasoAction());
        this.viewMenu.add(zoomMenu);
        JMenu alignMenu = new JMenu(Messages.getString("MainWindow.17"));
        alignMenu.add(this.actionManager.getAlignTopAction());
        alignMenu.add(this.actionManager.getAlignBottomAction());
        alignMenu.add(this.actionManager.getAlignLeftAction());
        alignMenu.add(this.actionManager.getAlignRightAction());
        alignMenu.addSeparator();
        alignMenu.add(this.actionManager.getDistributeHorizontalAction());
        alignMenu.add(this.actionManager.getDistributeVerticalAction());
        this.viewMenu.add(alignMenu);
        JCheckBoxMenuItem showGrid = new JCheckBoxMenuItem(this.actionManager.getSwitchShowGridAction());
        showGrid.setSelected(ConfigurationManager.getInstance().getBoolean("showGrid"));
        this.viewMenu.add(showGrid);
        this.addMenu.add(this.actionManager.getArgumentAction());
        this.addMenu.add(this.actionManager.getAssumptionAction());
        this.addMenu.add(this.actionManager.getDecisionAction());
        this.addMenu.add(this.actionManager.getPositionAction());
        this.addMenu.add(this.actionManager.getRequirementAction());
        this.addMenu.add(this.actionManager.getStakeholderAction());
        this.addMenu.add(this.actionManager.getTopicAction());
        this.addMenu.addSeparator();
        JMenu addLink = new JMenu(Messages.getString("MainWindow.14"));
        addLink.add(this.actionManager.getLinkAuthorAction());
        addLink.add(this.actionManager.getLinkSupportAction());
        addLink.add(this.actionManager.getLinkInterestAction());
        addLink.add(this.actionManager.getLinkRefineAction());
        addLink.add(this.actionManager.getLinkDependencyAction());
        this.addMenu.add(addLink);
        this.editMenu.add(this.actionManager.getUndoAction());
        this.editMenu.add(this.actionManager.getRedoAction());
        this.editMenu.addSeparator();
        this.editMenu.add(this.actionManager.getFindReplaceAction());
        this.editMenu.addSeparator();
        this.editMenu.add(this.actionManager.getCutAction());
        this.editMenu.add(this.actionManager.getCopyAction());
        this.editMenu.add(this.actionManager.getPasteAction());
        this.editMenu.add(this.actionManager.getDeleteAction());
        this.selectMenu.add(this.actionManager.getSelectAllAction());
        this.selectMenu.add(this.actionManager.getInverseSelectionAction());
        JMenu selectAll = new JMenu(Messages.getString("MainWindow.15"));
        selectAll.add(this.actionManager.getSelectAllArgumentsAction());
        selectAll.add(this.actionManager.getSelectAllAssumptionsAction());
        selectAll.add(this.actionManager.getSelectAllDecisionsAction());
        selectAll.add(this.actionManager.getSelectAllPositionsAction());
        selectAll.add(this.actionManager.getSelectAllRequirementsAction());
        selectAll.add(this.actionManager.getSelectAllStakeholdersAction());
        selectAll.add(this.actionManager.getSelectAllTopicsAction());
        this.selectMenu.add(selectAll);
        this.fileMenu.add(this.actionManager.getCreateNewProjectAction());
        this.fileMenu.add(this.actionManager.getCreateNewDiagramAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.actionManager.getFileSaveAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.actionManager.getChangeWorkspaceAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.actionManager.getImportAction());
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.actionManager.getQuitAction());
        this.settingsMenu.add(this.actionManager.getSettingsAction());
        this.helpMenu.add(this.actionManager.getHelpAction());
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.actionManager.getAboutAction());
        this.menu.add(this.fileMenu);
        this.menu.add(this.editMenu);
        this.menu.add(this.addMenu);
        this.menu.add(this.viewMenu);
        this.menu.add(this.selectMenu);
        this.menu.add(this.settingsMenu);
        this.menu.add(Box.createHorizontalGlue());
        this.menu.add(this.helpMenu);
        this.setJMenuBar(this.menu);
    }

    private void initializeTreePopupMenus() {
        this.treePopNode = new JPopupMenu();
        this.treePopNode.add(this.actionManager.getCutAction());
        this.treePopNode.add(this.actionManager.getCopyAction());
        this.treePopNode.add(this.actionManager.getPasteAction());
        this.treePopNode.addSeparator();
        this.treePopNode.add(this.actionManager.getDeleteAction());
        this.treePopNode.addSeparator();
        this.treePopNode.add(this.actionManager.getCenterNodeAction());
        this.treePopDiagram = new JPopupMenu();
        this.treePopDiagram.add(this.actionManager.getRenameDiagramAction());
        this.treePopDiagram.add(this.actionManager.getDeleteDiagramAction());
        this.treePopProject = new JPopupMenu();
        this.treePopProject.add(this.actionManager.getCreateNewDiagramAction());
        this.treePopProject.addSeparator();
        this.treePopProject.add(this.actionManager.getRenameProjectAction());
        this.treePopProject.add(this.actionManager.getDeleteProjectAction());
        this.treePopProject.addSeparator();
        this.treePopProject.add(this.actionManager.getExportACtion());
        this.treePopWorkspace = new JPopupMenu();
        this.treePopWorkspace.add(this.actionManager.getCreateNewProjectAction());
        this.treePopWorkspace.add(this.actionManager.getImportAction());
        this.treePopWorkspace.add(this.actionManager.getChangeWorkspaceAction());
    }

    public void setStatusBarMessage(String message, int index) {
        if (index > 2 || index < 0) {
            return;
        }
        if (index == 2) {
            this.labels[2].setText("<" + message + ">");
        } else {
            this.labels[index].setText(message);
        }
    }

    public void setWorkspaceTree(WorkspaceTree newTree) {
        int oldSpliterLocation = this.spliter.getDividerLocation();
        this.spliter.setLeftComponent(newTree);
        this.spliter.setDividerLocation(oldSpliterLocation);
        this.spliter.validate();
    }

    public void backupStatusBar() {
        this.statusBarBackup = this.labels[0].getText();
    }

    public void restoreStatusBar() {
        this.labels[0].setText(this.statusBarBackup);
    }

    public GERMView getView() {
        return this.view;
    }

    public JToolBar getToolbarElements() {
        return this.toolbarElements;
    }

    public TimerThread getTimerThread() {
        return this.timerThread;
    }

    private class ScrollController
    implements AdjustmentListener {
        private int type;

        public ScrollController(int type) {
            this.type = type;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (this.type == 1) {
                MainWindow.this.scrollOffsetX = 0;
                MainWindow.this.scrollOffsetY = (int)((double)(-(e.getValue() - 25)) / Math.abs(MainWindow.this.getView().getTransform().getScaleY()));
            } else if (this.type == 2) {
                MainWindow.this.scrollOffsetX = (int)((double)(-(e.getValue() - 25)) / Math.abs(MainWindow.this.getView().getTransform().getScaleX()));
                MainWindow.this.scrollOffsetY = 0;
            }
            MainWindow.this.timerThread.setOffset(MainWindow.this.scrollOffsetX, MainWindow.this.scrollOffsetY);
        }
    }

    private class ScrollMouseListener
    extends MouseAdapter {
        JScrollBar bar;

        public ScrollMouseListener(JScrollBar bar) {
            this.bar = bar;
        }

        public void mouseReleased(MouseEvent e) {
            this.bar.setValue(25);
        }
    }

    private class ZoomSlideListener
    extends MouseAdapter {
        JSlider bar;

        public ZoomSlideListener(JSlider bar) {
            this.bar = bar;
        }

        public void mouseReleased(MouseEvent e) {
            this.bar.setValue(0);
        }
    }

    private class ZoomSliderController
    implements ChangeListener {
        private ZoomSliderController() {
        }

        public void stateChanged(ChangeEvent arg0) {
            MainWindow.this.timerThread.setZoomSliderValue((double)MainWindow.this.zoomSlide.getValue() / 2000.0);
        }
    }
}

