/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.i18n.Messages;
import germ.util.Cursors;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NewPodWindow
extends JDialog {
    public static int NEW_PROJECT = 0;
    public static int NEW_DIAGRAM = 1;
    public static int EDIT_PROJECT = 2;
    public static int EDIT_DIAGRAM = 3;
    protected JLabel lblNew = new JLabel();
    protected JTextField tfNew = new JTextField(20);
    protected JButton btnOK = new JButton(Messages.getString("NewPodWindow.0"));
    protected JButton btnCancel = new JButton(Messages.getString("NewPodWindow.1"));
    protected Box okCancelBox = Box.createHorizontalBox();
    protected boolean dialogResult = false;

    public NewPodWindow(int pod) {
        switch (pod) {
            case 0: {
                this.lblNew.setText(Messages.getString("NewPodWindow.2"));
                this.setTitle(Messages.getString("NewPodWindow.3"));
                break;
            }
            case 1: {
                this.lblNew.setText(Messages.getString("NewPodWindow.4"));
                this.setTitle(Messages.getString("NewPodWindow.5"));
                break;
            }
            case 2: {
                this.lblNew.setText(Messages.getString("NewPodWindow.6"));
                this.setTitle(Messages.getString("NewPodWindow.7"));
                break;
            }
            case 3: {
                this.lblNew.setText(Messages.getString("NewPodWindow.8"));
                this.setTitle(Messages.getString("NewPodWindow.9"));
            }
        }
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewPodWindow.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewPodWindow.this.escapePressed();
            }
        });
        this.okCancelBox.add(this.btnOK);
        this.okCancelBox.add(Box.createHorizontalStrut(40));
        this.okCancelBox.add(this.btnCancel);
        this.setLayout(new GridBagLayout());
        Container container = this.getContentPane();
        GridBagConstraints c00 = new GridBagConstraints();
        c00.gridx = 0;
        c00.gridy = 0;
        c00.anchor = 12;
        c00.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 1;
        c10.gridy = 0;
        c10.weightx = 1.0;
        c10.fill = 2;
        c10.anchor = 18;
        c10.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 0;
        c2.gridy = 2;
        c2.gridwidth = 2;
        c2.anchor = 10;
        c2.insets = new Insets(25, 0, 10, 0);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    NewPodWindow.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    NewPodWindow.this.enterPressed();
                }
                return false;
            }
        });
        container.add((Component)this.lblNew, c00);
        container.add((Component)this.tfNew, c10);
        container.add((Component)this.okCancelBox, c2);
        this.setCursor(Cursors.getCursor("default"));
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(boolean dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void enterPressed() {
        this.setDialogResult(true);
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }

    public String getEnteredName() {
        return this.tfNew.getText();
    }

    public void setEnteredName(String oldName) {
        this.tfNew.setText(oldName);
    }
}

