/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.gui.windows.ColorWindow;
import germ.i18n.Messages;
import germ.util.Cursors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NodeColorProperties
extends JDialog {
    private Double[] items = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
    private JLabel lblStroke = new JLabel(Messages.getString("NodeColorProperties.0"));
    private JLabel lblFill = new JLabel(Messages.getString("NodeColorProperties.1"));
    private JLabel lblThickness = new JLabel(Messages.getString("NodeColorProperties.2"));
    private JButton btnStrokeColor = new JButton(Messages.getString("NodeColorProperties.3"));
    private JCheckBox chbGradient = new JCheckBox(Messages.getString("NodeColorProperties.4"));
    private JButton btnFillPrimColor = new JButton(Messages.getString("NodeColorProperties.5"));
    private JButton btnFillSecColor = new JButton(Messages.getString("NodeColorProperties.6"));
    private Box fill = Box.createHorizontalBox();
    private JComboBox cbStrokeThickness = new JComboBox<Double>(this.items);
    private Box stroke = Box.createHorizontalBox();
    private JButton btnOK = new JButton(Messages.getString("NodeColorProperties.7"));
    private JButton btnCancel = new JButton(Messages.getString("NodeColorProperties.8"));
    private Box okCancelBox = Box.createHorizontalBox();
    protected boolean dialogResult = false;
    protected Color strokeColor = null;
    protected Color fillPrimColor = null;
    protected Color fillSecColor = null;
    protected float strokeThickness = 0.0f;

    public NodeColorProperties() {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.cbStrokeThickness.setEditable(true);
        this.cbStrokeThickness.setPreferredSize(new Dimension(50, 20));
        this.cbStrokeThickness.setMaximumSize(new Dimension(50, 20));
        this.chbGradient.setSelected(false);
        this.btnFillSecColor.setEnabled(false);
        this.setResizable(false);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocationRelativeTo(null);
        this.setTitle(Messages.getString("NodeColorProperties.9"));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeColorProperties.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeColorProperties.this.escapePressed();
            }
        });
        this.btnStrokeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    NodeColorProperties.this.setStrokeColor(cw.getColor());
                }
            }
        });
        this.btnFillPrimColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    NodeColorProperties.this.setFillPrimColor(cw.getColor());
                }
            }
        });
        this.btnFillSecColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    NodeColorProperties.this.setFillSecColor(cw.getColor());
                }
            }
        });
        this.cbStrokeThickness.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    NodeColorProperties.this.strokeThickness = Float.parseFloat(NodeColorProperties.this.cbStrokeThickness.getSelectedItem().toString());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("NodeColorProperties.10"), Messages.getString("NodeColorProperties.11"), 1);
                    NodeColorProperties.this.cbStrokeThickness.setSelectedItem(Float.valueOf(NodeColorProperties.this.strokeThickness));
                }
            }
        });
        this.chbGradient.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (NodeColorProperties.this.chbGradient.isSelected()) {
                    NodeColorProperties.this.btnFillSecColor.setEnabled(true);
                } else {
                    NodeColorProperties.this.btnFillSecColor.setEnabled(false);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        Container container = this.getContentPane();
        GridBagConstraints c00 = new GridBagConstraints();
        c00.gridx = 0;
        c00.gridy = 0;
        c00.anchor = 13;
        c00.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 1;
        c10.gridy = 0;
        c10.weightx = 1.0;
        c10.fill = 2;
        c10.anchor = 17;
        c10.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 13;
        c01.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.weightx = 1.0;
        c11.anchor = 17;
        c11.insets = new Insets(10, 15, 0, 20);
        GridBagConstraints c12 = new GridBagConstraints();
        c12.gridx = 1;
        c12.gridy = 2;
        c12.weightx = 1.0;
        c12.anchor = 17;
        c12.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 0;
        c3.gridy = 3;
        c3.weightx = 1.0;
        c3.gridwidth = 2;
        c3.anchor = 10;
        c3.insets = new Insets(20, 20, 10, 20);
        container.add((Component)this.lblStroke, c00);
        this.stroke.add(this.btnStrokeColor);
        this.stroke.add(Box.createGlue());
        this.stroke.add(this.lblThickness);
        this.stroke.add(Box.createHorizontalStrut(15));
        this.stroke.add(this.cbStrokeThickness);
        container.add((Component)this.stroke, c10);
        container.add((Component)this.lblFill, c01);
        container.add((Component)this.chbGradient, c11);
        this.fill.add(this.btnFillPrimColor);
        this.fill.add(Box.createHorizontalStrut(20));
        this.fill.add(this.btnFillSecColor);
        container.add((Component)this.fill, c12);
        this.okCancelBox.add(this.btnOK);
        this.okCancelBox.add(Box.createHorizontalStrut(40));
        this.okCancelBox.add(this.btnCancel);
        container.add((Component)this.okCancelBox, c3);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    NodeColorProperties.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    NodeColorProperties.this.enterPressed();
                }
                return false;
            }
        });
        this.setCursor(Cursors.getCursor("default"));
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(boolean dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public Color getFillPrimColor() {
        return this.fillPrimColor;
    }

    public void setFillPrimColor(Color fillColor) {
        this.fillPrimColor = fillColor;
    }

    public Color getFillSecColor() {
        return this.fillSecColor;
    }

    public void setFillSecColor(Color fillColor) {
        this.fillSecColor = fillColor;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setStrokeThickness(float strokeThickness) {
        this.strokeThickness = strokeThickness;
    }

    public float getCbStrokeThickness() {
        return Float.parseFloat(this.cbStrokeThickness.getSelectedItem().toString());
    }

    public void setCbStrokeThickness(float strokeThickness) {
        this.cbStrokeThickness.setSelectedItem(Float.valueOf(strokeThickness));
    }

    public boolean isGradient() {
        return this.chbGradient.isSelected();
    }

    public void setGradient(boolean check) {
        this.chbGradient.setSelected(check);
    }

    public void enterPressed() {
        this.setDialogResult(true);
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }
}

