/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.gui.windows.ColorWindow;
import germ.i18n.Messages;
import germ.util.Cursors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public abstract class PropertyWindow
extends JDialog {
    private Double[] items = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
    private JLabel lblName = new JLabel(Messages.getString("PropertyWindow.0"));
    private JLabel lblStroke = new JLabel(Messages.getString("PropertyWindow.1"));
    private JLabel lblFill = new JLabel(Messages.getString("PropertyWindow.2"));
    private JLabel lblThickness = new JLabel(Messages.getString("PropertyWindow.3"));
    private JTextField tfName = new JTextField(20);
    private JButton btnStrokeColor = new JButton(Messages.getString("PropertyWindow.4"));
    private JCheckBox chbGradient = new JCheckBox(Messages.getString("PropertyWindow.5"));
    private JButton btnFillPrimColor = new JButton(Messages.getString("PropertyWindow.6"));
    private JButton btnFillSecColor = new JButton(Messages.getString("PropertyWindow.7"));
    private Box fill = Box.createHorizontalBox();
    private JComboBox cbStrokeThickness = new JComboBox<Double>(this.items);
    private Box stroke = Box.createHorizontalBox();
    protected JButton btnOK = new JButton(Messages.getString("PropertyWindow.8"));
    protected JButton btnCancel = new JButton(Messages.getString("PropertyWindow.9"));
    protected Box okCancelBox = Box.createHorizontalBox();
    protected boolean dialogResult = false;
    protected Color strokeColor = null;
    protected Color fillPrimColor = null;
    protected Color fillSecColor = null;
    protected float strokeThickness = 0.0f;

    public PropertyWindow() {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.cbStrokeThickness.setEditable(true);
        this.cbStrokeThickness.setPreferredSize(new Dimension(50, 20));
        this.cbStrokeThickness.setSelectedIndex(2);
        this.chbGradient.setSelected(false);
        this.setResizable(false);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyWindow.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyWindow.this.escapePressed();
            }
        });
        this.okCancelBox.add(this.btnOK);
        this.okCancelBox.add(Box.createHorizontalStrut(40));
        this.okCancelBox.add(this.btnCancel);
        this.btnStrokeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setColor(PropertyWindow.this.getStrokeColor());
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    PropertyWindow.this.setStrokeColor(cw.getColor());
                }
            }
        });
        this.btnFillPrimColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setColor(PropertyWindow.this.getFillPrimColor());
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    PropertyWindow.this.setFillPrimColor(cw.getColor());
                }
            }
        });
        this.btnFillSecColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setColor(PropertyWindow.this.getFillSecColor());
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    PropertyWindow.this.setFillSecColor(cw.getColor());
                }
            }
        });
        this.cbStrokeThickness.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    PropertyWindow.this.strokeThickness = Float.parseFloat(PropertyWindow.this.cbStrokeThickness.getSelectedItem().toString());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("PropertyWindow.10"), Messages.getString("PropertyWindow.11"), 1);
                    PropertyWindow.this.cbStrokeThickness.setSelectedItem(Float.valueOf(PropertyWindow.this.strokeThickness));
                }
            }
        });
        this.chbGradient.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PropertyWindow.this.btnFillSecColor.setEnabled(PropertyWindow.this.chbGradient.isSelected());
            }
        });
        this.setLayout(new GridBagLayout());
        Container container = this.getContentPane();
        GridBagConstraints c00 = new GridBagConstraints();
        c00.gridx = 0;
        c00.gridy = 0;
        c00.anchor = 12;
        c00.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 1;
        c10.gridy = 0;
        c10.weightx = 1.0;
        c10.fill = 2;
        c10.anchor = 17;
        c10.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c02 = new GridBagConstraints();
        c02.gridx = 0;
        c02.gridy = 2;
        c02.anchor = 13;
        c02.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c12 = new GridBagConstraints();
        c12.gridx = 1;
        c12.gridy = 2;
        c12.weightx = 1.0;
        c12.fill = 2;
        c12.anchor = 17;
        c12.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c03 = new GridBagConstraints();
        c03.gridx = 0;
        c03.gridy = 3;
        c03.anchor = 13;
        c03.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c13 = new GridBagConstraints();
        c13.gridx = 1;
        c13.gridy = 3;
        c13.weightx = 1.0;
        c13.anchor = 17;
        c13.insets = new Insets(10, 15, 0, 20);
        GridBagConstraints c14 = new GridBagConstraints();
        c14.gridx = 1;
        c14.gridy = 4;
        c14.weightx = 1.0;
        c14.anchor = 17;
        c14.insets = new Insets(10, 20, 0, 20);
        container.add((Component)this.lblName, c00);
        container.add((Component)this.tfName, c10);
        container.add((Component)this.lblStroke, c02);
        this.stroke.add(this.btnStrokeColor);
        this.stroke.add(Box.createGlue());
        this.stroke.add(this.lblThickness);
        this.stroke.add(Box.createHorizontalStrut(15));
        this.stroke.add(this.cbStrokeThickness);
        container.add((Component)this.stroke, c12);
        container.add((Component)this.lblFill, c03);
        container.add((Component)this.chbGradient, c13);
        this.fill.add(this.btnFillPrimColor);
        this.fill.add(Box.createHorizontalStrut(20));
        this.fill.add(this.btnFillSecColor);
        container.add((Component)this.fill, c14);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    PropertyWindow.this.escapePressed();
                } else if (e.getKeyCode() == 10 && !e.isShiftDown()) {
                    PropertyWindow.this.enterPressed();
                }
                return false;
            }
        });
        this.setCursor(Cursors.getCursor("default"));
        this.btnFillSecColor.setEnabled(this.isGradient());
    }

    public String getName() {
        return this.tfName.getText();
    }

    public void setName(String tfName) {
        this.tfName.setText(tfName);
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(boolean dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public Color getFillPrimColor() {
        return this.fillPrimColor;
    }

    public void setFillPrimColor(Color fillColor) {
        this.fillPrimColor = fillColor;
    }

    public Color getFillSecColor() {
        return this.fillSecColor;
    }

    public void setFillSecColor(Color fillColor) {
        this.fillSecColor = fillColor;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setStrokeThickness(float strokeThickness) {
        this.strokeThickness = strokeThickness;
    }

    public float getCbStrokeThickness() {
        return Float.parseFloat(this.cbStrokeThickness.getSelectedItem().toString());
    }

    public void setCbStrokeThickness(float strokeThickness) {
        this.cbStrokeThickness.setSelectedItem(Float.valueOf(strokeThickness));
    }

    public boolean isGradient() {
        return this.chbGradient.isSelected();
    }

    public void setGradient(boolean check) {
        this.chbGradient.setSelected(check);
    }

    public void enterPressed() {
        this.setDialogResult(true);
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }
}

