/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.nodes.Requirement;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesWindow
extends JDialog {
    private JLabel lblReferences = new JLabel(Messages.getString("ReferencesWindow.0"));
    private JButton btnUpdate = new JButton(Messages.getString("ReferencesWindow.1"));
    private ArrayList<JCheckBox> checkBoxes = new ArrayList();
    private ArrayList<String> checked = new ArrayList();

    ReferencesWindow(ArrayList<String> previousReferences, String currentRequirement) {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle(Messages.getString("ReferencesWindow.2"));
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setDefaultCloseOperation(1);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GERMModel m = Application.getInstance().getModel();
        this.btnUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ReferencesWindow.this.checked.clear();
                for (JCheckBox box : ReferencesWindow.this.checkBoxes) {
                    if (!box.isSelected()) continue;
                    ReferencesWindow.this.checked.add(box.getName());
                }
                ReferencesWindow.this.setVisible(false);
            }
        });
        Container container = this.getContentPane();
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 0;
        c01.anchor = 17;
        c01.insets = new Insets(10, 10, 5, 0);
        container.add((Component)this.lblReferences, c01);
        int g = 0;
        int i = 0;
        while (i != m.getNodeCount()) {
            Node node = m.getNodeAt(i);
            if (node instanceof Requirement && !node.getName().equals(currentRequirement)) {
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = ++g;
                c.anchor = 17;
                c.insets = new Insets(5, 15, 0, 15);
                JCheckBox chbReference = new JCheckBox(node.getName());
                chbReference.setName(node.getName());
                this.checkBoxes.add(chbReference);
                container.add((Component)chbReference, c);
            }
            ++i;
        }
        GridBagConstraints c02 = new GridBagConstraints();
        c02.gridx = 0;
        c02.gridy = g + 1;
        c02.anchor = 13;
        c02.insets = new Insets(20, 0, 10, 15);
        container.add((Component)this.btnUpdate, c02);
        for (JCheckBox boxes : this.checkBoxes) {
            for (String refs : previousReferences) {
                if (!refs.equals(boxes.getName())) continue;
                boxes.setSelected(true);
            }
        }
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public ArrayList<String> getReferences() {
        return this.checked;
    }
}

