/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.gui.windows.CreateNewDiagramWindow;
import germ.gui.windows.PropertyWindow;
import germ.gui.windows.ReferencesWindow;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.nodes.Requirement;
import germ.model.nodes.Stakeholder;
import germ.model.workspace.Project;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.List;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementProperties
extends PropertyWindow {
    private JTextArea taDescription = new JTextArea(5, 20);
    private JLabel lblDescription = new JLabel(Messages.getString("RequirementProperties.2"));
    private JScrollPane spScrollDesc = new JScrollPane(this.taDescription);
    private JLabel lblSource = new JLabel(Messages.getString("RequirementProperties.10"));
    private JTextField tfSource = new JTextField(20);
    private JLabel lblPriority = new JLabel(Messages.getString("RequirementProperties.0"));
    private ButtonGroup priorityGroup = new ButtonGroup();
    private JRadioButton rbHigh = new JRadioButton(Messages.getString("RequirementProperties.11"));
    private JRadioButton rbMedium = new JRadioButton(Messages.getString("RequirementProperties.12"));
    private JRadioButton rbLow = new JRadioButton(Messages.getString("RequirementProperties.13"));
    private JCheckBox chbComplex = new JCheckBox();
    private JTextArea taRequirements = new JTextArea(5, 20);
    private JLabel lblRequirements = new JLabel(Messages.getString("RequirementProperties.14"));
    private JScrollPane spScrollRequ = new JScrollPane(this.taRequirements);
    private JLabel lblReferences = new JLabel(Messages.getString("RequirementProperties.15"));
    private List lReferences = new List(7);
    private JButton btnAddReferences = new JButton(Messages.getString("RequirementProperties.16"));
    private JScrollPane spScrollRefe = new JScrollPane(this.lReferences);
    private JComboBox cbAuthor = new JComboBox();
    private JLabel lblAuthor = new JLabel(Messages.getString("RequirementProperties.17"));
    private JTextField tfVersion = new JTextField(20);
    private JLabel lblVersion = new JLabel(Messages.getString("RequirementProperties.18"));
    private ButtonGroup statusGroup = new ButtonGroup();
    private JLabel lblStatus = new JLabel(Messages.getString("RequirementProperties.19"));
    private JRadioButton rbStatusApproved = new JRadioButton(Messages.getString("RequirementProperties.20"));
    private JRadioButton rbStatusWaiting = new JRadioButton(Messages.getString("RequirementProperties.21"));
    private JRadioButton rbStatusReview = new JRadioButton(Messages.getString("RequirementProperties.22"));
    private JRadioButton rbStatusVerified = new JRadioButton(Messages.getString("RequirementProperties.23"));
    private JRadioButton rbStatusValidated = new JRadioButton(Messages.getString("RequirementProperties.24"));
    private JRadioButton rbStatusRejected = new JRadioButton(Messages.getString("RequirementProperties.25"));
    private JLabel lblSubDiagram = new JLabel(Messages.getString("RequirementProperties.7"));
    private JComboBox cbDiagrams = new JComboBox();
    private JButton btnNewDiagram = new JButton("...");
    private Box diagramBox = Box.createHorizontalBox();
    private JLabel lblCreationDate = new JLabel(Messages.getString("RequirementProperties.3"));
    private JLabel lblDateCreated = new JLabel("");
    private JLabel lblLastChangeDAte = new JLabel(Messages.getString("RequirementProperties.5"));
    private JLabel lblDateChanged = new JLabel("");
    private String requirementName = "";

    public RequirementProperties() {
        this.taDescription.setLineWrap(true);
        this.taRequirements.setLineWrap(true);
        this.chbComplex.setEnabled(false);
        this.enableLineBreaking();
        JTextComponent editorA = (JTextComponent)this.cbAuthor.getEditor().getEditorComponent();
        editorA.setDocument(new AutoCompleteCombo(this.cbAuthor));
        this.cbAuthor.setEditable(true);
        this.lReferences.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String selected = RequirementProperties.this.lReferences.getSelectedItem();
                    GERMModel m = Application.getInstance().getModel();
                    for (Node node : m.getNodes()) {
                        if (!(node instanceof Requirement) || !node.getName().equals(selected)) continue;
                        RequirementProperties property = ((Requirement)node).getNewPropertyWindow();
                        property.setLocation(property.getLocation().x + 30, property.getLocation().y + 30);
                        property.setVisible(true);
                    }
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.btnAddReferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrayList<String> references = new ArrayList<String>();
                String[] stringArray = RequirementProperties.this.lReferences.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String listItem = stringArray[n2];
                    references.add(listItem);
                    ++n2;
                }
                ReferencesWindow rw = new ReferencesWindow(references, RequirementProperties.this.getRequirementName());
                rw.setVisible(true);
                RequirementProperties.this.updateReferences(rw.getReferences());
            }
        });
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setTitle(Messages.getString("RequirementProperties.9"));
        this.setDefaultCloseOperation(1);
        this.initializeRadioButtons();
        Container container = this.getContentPane();
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 12;
        c01.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.weightx = 1.0;
        c11.fill = 2;
        c11.anchor = 17;
        c11.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c05 = new GridBagConstraints();
        c05.gridx = 0;
        c05.gridy = 5;
        c05.anchor = 12;
        c05.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c15 = new GridBagConstraints();
        c15.gridx = 1;
        c15.gridy = 5;
        c15.weightx = 1.0;
        c15.fill = 2;
        c15.anchor = 17;
        c15.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c06 = new GridBagConstraints();
        c06.gridx = 0;
        c06.gridy = 6;
        c06.anchor = 12;
        c06.insets = new Insets(12, 20, 0, 0);
        GridBagConstraints c16 = new GridBagConstraints();
        c16.gridx = 1;
        c16.gridy = 6;
        c16.weightx = 1.0;
        c16.anchor = 17;
        c16.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c07 = new GridBagConstraints();
        c07.gridx = 0;
        c07.gridy = 7;
        c07.anchor = 12;
        c07.insets = new Insets(13, 20, 0, 0);
        GridBagConstraints c17 = new GridBagConstraints();
        c17.gridx = 1;
        c17.gridy = 7;
        c17.fill = 2;
        c17.anchor = 17;
        c17.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c20 = new GridBagConstraints();
        c20.gridx = 3;
        c20.gridy = 0;
        c20.anchor = 13;
        c20.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c30 = new GridBagConstraints();
        c30.gridx = 4;
        c30.gridy = 0;
        c30.fill = 2;
        c30.anchor = 17;
        c30.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c21 = new GridBagConstraints();
        c21.gridx = 3;
        c21.gridy = 1;
        c21.anchor = 13;
        c21.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c31 = new GridBagConstraints();
        c31.gridx = 4;
        c31.gridy = 1;
        c31.weightx = 1.0;
        c31.fill = 2;
        c31.anchor = 10;
        c31.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c22 = new GridBagConstraints();
        c22.gridx = 3;
        c22.gridy = 2;
        c22.anchor = 13;
        c22.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c32 = new GridBagConstraints();
        c32.gridx = 4;
        c32.gridy = 2;
        c32.weightx = 1.0;
        c32.fill = 2;
        c32.anchor = 10;
        c32.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c23 = new GridBagConstraints();
        c23.gridx = 3;
        c23.gridy = 3;
        c23.anchor = 13;
        c23.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c33 = new GridBagConstraints();
        c33.gridx = 4;
        c33.gridy = 3;
        c33.weightx = 1.0;
        c33.fill = 2;
        c33.anchor = 10;
        c33.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c24 = new GridBagConstraints();
        c24.gridx = 3;
        c24.gridy = 4;
        c24.anchor = 13;
        c24.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c34 = new GridBagConstraints();
        c34.gridx = 4;
        c34.gridy = 4;
        c34.weightx = 1.0;
        c34.fill = 2;
        c34.anchor = 10;
        c34.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c25 = new GridBagConstraints();
        c25.gridx = 3;
        c25.gridy = 5;
        c25.gridheight = 2;
        c25.anchor = 12;
        c25.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c35 = new GridBagConstraints();
        c35.gridx = 4;
        c35.gridy = 5;
        c35.gridheight = 2;
        c35.weightx = 1.0;
        c35.fill = 2;
        c35.anchor = 18;
        c35.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c27 = new GridBagConstraints();
        c27.gridx = 3;
        c27.gridy = 7;
        c27.anchor = 12;
        c27.insets = new Insets(12, 20, 0, 0);
        GridBagConstraints c37 = new GridBagConstraints();
        c37.gridx = 4;
        c37.gridy = 7;
        c37.weightx = 1.0;
        c37.fill = 2;
        c37.anchor = 10;
        c37.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints cOK = new GridBagConstraints();
        cOK.gridx = 0;
        cOK.gridy = 8;
        cOK.gridwidth = 5;
        cOK.anchor = 10;
        cOK.insets = new Insets(20, 0, 10, 0);
        GridBagConstraints s = new GridBagConstraints();
        s.gridx = 2;
        s.gridy = 0;
        s.gridheight = 8;
        s.anchor = 10;
        s.fill = 3;
        s.insets = new Insets(20, 0, 0, 0);
        this.diagramBox.add(this.cbDiagrams);
        this.diagramBox.add(Box.createHorizontalStrut(10));
        this.diagramBox.add(this.btnNewDiagram);
        container.add((Component)this.lblSubDiagram, c01);
        container.add((Component)this.diagramBox, c11);
        container.add((Component)this.lblDescription, c05);
        container.add((Component)this.spScrollDesc, c15);
        Box priorityBox = Box.createVerticalBox();
        priorityBox.add(this.rbHigh);
        priorityBox.add(Box.createVerticalStrut(5));
        priorityBox.add(this.rbMedium);
        priorityBox.add(Box.createVerticalStrut(5));
        priorityBox.add(this.rbLow);
        this.priorityGroup.add(this.rbHigh);
        this.priorityGroup.add(this.rbMedium);
        this.priorityGroup.add(this.rbLow);
        container.add((Component)this.lblPriority, c06);
        container.add((Component)priorityBox, c16);
        container.add((Component)this.lblRequirements, c07);
        container.add((Component)this.spScrollRequ, c17);
        JSeparator separator = new JSeparator(1);
        container.add((Component)separator, s);
        container.add((Component)this.lblAuthor, c20);
        container.add((Component)this.cbAuthor, c30);
        container.add((Component)this.lblVersion, c21);
        container.add((Component)this.tfVersion, c31);
        container.add((Component)this.lblCreationDate, c22);
        container.add((Component)this.lblDateCreated, c32);
        container.add((Component)this.lblLastChangeDAte, c23);
        container.add((Component)this.lblDateChanged, c33);
        container.add((Component)this.lblSource, c24);
        container.add((Component)this.tfSource, c34);
        Box referencesBox = Box.createVerticalBox();
        referencesBox.add(this.spScrollRefe);
        referencesBox.add(Box.createVerticalStrut(130));
        referencesBox.add(this.btnAddReferences);
        container.add((Component)this.lblReferences, c25);
        container.add((Component)referencesBox, c35);
        container.add((Component)this.lblReferences, c25);
        container.add((Component)this.spScrollRefe, c35);
        Box statusBox1 = Box.createVerticalBox();
        statusBox1.add(this.rbStatusApproved);
        statusBox1.add(Box.createVerticalStrut(5));
        statusBox1.add(this.rbStatusWaiting);
        statusBox1.add(Box.createVerticalStrut(5));
        statusBox1.add(this.rbStatusRejected);
        Box statusBox2 = Box.createVerticalBox();
        statusBox2.add(this.rbStatusReview);
        statusBox2.add(Box.createVerticalStrut(5));
        statusBox2.add(this.rbStatusValidated);
        statusBox2.add(Box.createVerticalStrut(5));
        statusBox2.add(this.rbStatusVerified);
        Box statusBox = Box.createHorizontalBox();
        statusBox.add(statusBox1);
        statusBox.add(Box.createHorizontalStrut(10));
        statusBox.add(statusBox2);
        this.statusGroup.add(this.rbStatusApproved);
        this.statusGroup.add(this.rbStatusWaiting);
        this.statusGroup.add(this.rbStatusRejected);
        this.statusGroup.add(this.rbStatusReview);
        this.statusGroup.add(this.rbStatusValidated);
        this.statusGroup.add(this.rbStatusVerified);
        container.add((Component)this.lblStatus, c27);
        container.add((Component)statusBox, c37);
        container.add((Component)this.okCancelBox, cOK);
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public String getPriority() {
        String priority = "";
        if (this.rbHigh.isSelected()) {
            priority = this.rbHigh.getName();
        }
        if (this.rbMedium.isSelected()) {
            priority = this.rbMedium.getName();
        }
        if (this.rbLow.isSelected()) {
            priority = this.rbLow.getName();
        }
        return priority;
    }

    public void setPriority(String priority) {
        if (this.rbHigh.getName().equals(priority)) {
            this.rbHigh.setSelected(true);
        } else if (this.rbMedium.getName().equals(priority)) {
            this.rbMedium.setSelected(true);
        } else {
            this.rbLow.setSelected(true);
        }
    }

    public boolean getComplex() {
        return this.chbComplex.isSelected();
    }

    public void setComplex(boolean chbComplex) {
        this.chbComplex.setSelected(chbComplex);
    }

    public String getDescription() {
        return this.taDescription.getText();
    }

    public void setDescription(String taDescription) {
        this.taDescription.setText(taDescription);
    }

    public void setDateCreated(String dateCreated) {
        this.lblDateCreated.setText(dateCreated);
    }

    public void setDateChanged(String dateChanged) {
        this.lblDateChanged.setText(dateChanged);
    }

    public String getSubDiagram() {
        try {
            return this.cbDiagrams.getSelectedItem().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSubDiagram(String name) {
        this.cbDiagrams.setEditable(true);
        this.cbDiagrams.setSelectedItem(name);
        this.cbDiagrams.setEditable(false);
    }

    public String getSource() {
        return this.tfSource.getText();
    }

    public void setSource(String source) {
        this.tfSource.setText(source);
    }

    public String getRequirements() {
        return this.taRequirements.getText();
    }

    public void setRequirements(String requirements) {
        this.taRequirements.setText(requirements);
    }

    public ArrayList<String> getReferences() {
        ArrayList<String> references = new ArrayList<String>();
        String[] stringArray = this.lReferences.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String reference = stringArray[n2];
            references.add(reference);
            ++n2;
        }
        return references;
    }

    public void setReferences(ArrayList<String> references) {
        this.lReferences.removeAll();
        if (references != null) {
            for (String reference : references) {
                this.lReferences.add(reference);
            }
        }
    }

    public String getAuthor() {
        if (this.cbAuthor.getSelectedItem() != null) {
            return this.cbAuthor.getSelectedItem().toString();
        }
        return "";
    }

    public void setAuthor(String author) {
        this.cbAuthor.setSelectedItem(author);
    }

    public String getVersion() {
        return this.tfVersion.getText();
    }

    public void setVersion(String version) {
        this.tfVersion.setText(version);
    }

    public String getStatus() {
        String status = "";
        if (this.rbStatusApproved.isSelected()) {
            status = this.rbStatusApproved.getName();
        } else if (this.rbStatusRejected.isSelected()) {
            status = this.rbStatusRejected.getName();
        } else if (this.rbStatusReview.isSelected()) {
            status = this.rbStatusReview.getName();
        } else if (this.rbStatusValidated.isSelected()) {
            status = this.rbStatusValidated.getName();
        } else if (this.rbStatusVerified.isSelected()) {
            status = this.rbStatusVerified.getName();
        } else if (this.rbStatusWaiting.isSelected()) {
            status = this.rbStatusWaiting.getName();
        }
        return status;
    }

    public void setStatus(String status) {
        if (this.rbStatusApproved.getName().equals(status)) {
            this.rbStatusApproved.setSelected(true);
        } else if (this.rbStatusRejected.getName().equals(status)) {
            this.rbStatusRejected.setSelected(true);
        } else if (this.rbStatusValidated.getName().equals(status)) {
            this.rbStatusValidated.setSelected(true);
        } else if (this.rbStatusVerified.getName().equals(status)) {
            this.rbStatusVerified.setSelected(true);
        } else if (this.rbStatusWaiting.getName().equals(status)) {
            this.rbStatusWaiting.setSelected(true);
        } else {
            this.rbStatusReview.setSelected(true);
        }
    }

    public String getRequirementName() {
        return this.requirementName;
    }

    public void setRequirementName(String requirementName) {
        this.requirementName = requirementName;
    }

    public void initializeDiagrams() {
        int diagram = 0;
        this.cbDiagrams.removeAllItems();
        Project currentProject = Application.getInstance().getModel().getProject();
        int i = 0;
        while (i != currentProject.getDiagramCount()) {
            if (currentProject.getDiagram(i).getName().equals(Application.getInstance().getModel().getName())) {
                diagram = i;
            }
            this.cbDiagrams.insertItemAt(currentProject.getDiagram(i), i);
            ++i;
        }
        this.cbDiagrams.removeItemAt(diagram);
    }

    public void initializeNewDiagramListener() {
        if (this.btnNewDiagram.getActionListeners().length > 0) {
            this.btnNewDiagram.removeActionListener(this.btnNewDiagram.getActionListeners()[0]);
        }
        this.btnNewDiagram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project currentProject = Application.getInstance().getModel().getProject();
                CreateNewDiagramWindow nd = new CreateNewDiagramWindow();
                nd.setCbProjects(currentProject.getName());
                nd.disableCbProjects();
                nd.setVisible(true);
                if (nd.isDialogResult()) {
                    RequirementProperties.this.cbDiagrams.insertItemAt(nd.getEnteredName(), RequirementProperties.this.cbDiagrams.getItemCount());
                    RequirementProperties.this.cbDiagrams.setEditable(true);
                    RequirementProperties.this.cbDiagrams.setSelectedItem(nd.getEnteredName());
                    RequirementProperties.this.cbDiagrams.setEditable(false);
                    GERMModel newDiagram = new GERMModel(nd.getEnteredName(), currentProject);
                    newDiagram.addUpdateListener(Application.getInstance().getWorkspace());
                    currentProject.addDiagram(newDiagram);
                    newDiagram.save();
                    Application.getInstance().getModel().updatePerformed();
                }
            }
        });
    }

    public void initializeRadioButtons() {
        this.rbHigh.setName("High");
        this.rbMedium.setName("Medium");
        this.rbLow.setName("Low");
        this.rbStatusApproved.setName("Approved");
        this.rbStatusWaiting.setName("Waiting");
        this.rbStatusReview.setName("Review");
        this.rbStatusVerified.setName("Verified");
        this.rbStatusValidated.setName("Validated");
        this.rbStatusRejected.setName("Rejected");
    }

    public void updateReferences(ArrayList<String> newReferences) {
        this.lReferences.removeAll();
        for (String ref : newReferences) {
            this.lReferences.add(ref);
        }
    }

    public void enableLineBreaking() {
        JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(10, 64), "insert-break")};
        JTextArea c = new JTextArea();
        Keymap k = c.getKeymap();
        JTextArea.loadKeymap(k, defaultBindings, c.getActions());
        JTextArea.loadKeymap(k, defaultBindings, c.getActions());
    }

    public void initializeAuthors() {
        this.cbAuthor.removeAllItems();
        GERMModel m = Application.getInstance().getModel();
        for (Node node : m.getNodes()) {
            if (!(node instanceof Stakeholder)) continue;
            this.cbAuthor.addItem(node.getName());
        }
    }

    public void checkRequirements() {
        int noOfRequirements = 0;
        GERMModel m = Application.getInstance().getModel();
        for (Node node : m.getNodes()) {
            if (!(node instanceof Requirement)) continue;
            ++noOfRequirements;
        }
        if (noOfRequirements > 1) {
            this.btnAddReferences.setEnabled(true);
        } else {
            this.btnAddReferences.setEnabled(false);
        }
    }

    class AutoCompleteCombo
    extends PlainDocument {
        JComboBox comboBox;
        ComboBoxModel model;
        JTextComponent editor;
        boolean selecting = false;

        public AutoCompleteCombo(final JComboBox comboBox) {
            this.comboBox = comboBox;
            this.model = comboBox.getModel();
            this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
            comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!AutoCompleteCombo.this.selecting) {
                        AutoCompleteCombo.this.highlightCompletedText(0);
                    }
                }
            });
            this.editor.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (comboBox.isDisplayable()) {
                        comboBox.setPopupVisible(false);
                    }
                }
            });
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                this.setSelectedItem(item);
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            }
        }

        private void setText(String text) throws BadLocationException {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }

        private void highlightCompletedText(int start) {
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(this.getLength());
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.model.setSelectedItem(item);
            this.selecting = false;
        }

        private Object lookupItem(String pattern) {
            Object selectedItem = this.model.getSelectedItem();
            if (selectedItem != null && this.startsWith(selectedItem.toString(), pattern)) {
                return selectedItem;
            }
            int i = 0;
            int n = this.model.getSize();
            while (i < n) {
                Object currentItem = this.model.getElementAt(i);
                if (this.startsWith(currentItem.toString(), pattern)) {
                    return currentItem;
                }
                ++i;
            }
            return null;
        }

        private boolean startsWith(String str1, String str2) {
            return str1.startsWith(str2);
        }
    }
}

