/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.i18n.Messages;
import germ.model.GERMModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveDiagramsWindow
extends JDialog {
    private ArrayList<GERMModel> unsaved;
    private ArrayList<GERMModel> checked = new ArrayList();
    private JLabel lblSave = new JLabel(Messages.getString("SaveDiagramsWindow.0"));
    private ArrayList<JCheckBox> checkBoxes = new ArrayList();
    private JCheckBox chbSaveAll = new JCheckBox(Messages.getString("SaveDiagramsWindow.1"));
    private JButton btnOK = new JButton(Messages.getString("SaveDiagramsWindow.2"));
    private JButton btnCancel = new JButton(Messages.getString("SaveDiagramsWindow.3"));
    private Box btnBox = Box.createHorizontalBox();
    private boolean dialogResult = false;

    public SaveDiagramsWindow(ArrayList<GERMModel> unsavedDiagrams) {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i = 0;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setTitle(Messages.getString("SaveDiagramsWindow.4"));
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        Container container = this.getContentPane();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(20, 20, 10, 20);
        container.add((Component)this.lblSave, c);
        this.unsaved = unsavedDiagrams;
        i = 0;
        while (i != this.unsaved.size()) {
            GridBagConstraints name = new GridBagConstraints();
            name.gridx = 0;
            name.gridy = i + 1;
            name.weightx = 1.0;
            name.anchor = 13;
            name.insets = new Insets(5, 0, 0, 10);
            GridBagConstraints check = new GridBagConstraints();
            check.gridx = 1;
            check.gridy = i + 1;
            check.weightx = 1.0;
            check.anchor = 17;
            check.insets = new Insets(5, 10, 0, 0);
            container.add((Component)new JLabel(this.unsaved.get(i).getName()), name);
            JCheckBox chbSave = new JCheckBox();
            chbSave.setName("" + i);
            container.add((Component)chbSave, check);
            this.checkBoxes.add(chbSave);
            ++i;
        }
        GridBagConstraints ce0 = new GridBagConstraints();
        ce0.gridx = 0;
        ce0.gridy = i + 1;
        ce0.weightx = 1.0;
        ce0.gridwidth = 2;
        ce0.anchor = 17;
        ce0.insets = new Insets(10, 20, 20, 0);
        GridBagConstraints ce1 = new GridBagConstraints();
        ce1.gridx = 1;
        ce1.gridy = i + 1;
        ce1.weightx = 1.0;
        ce1.gridwidth = 2;
        ce1.anchor = 13;
        ce1.insets = new Insets(10, 0, 20, 20);
        container.add((Component)this.chbSaveAll, ce0);
        this.btnBox.add(this.btnOK);
        this.btnBox.add(Box.createHorizontalStrut(20));
        this.btnBox.add(this.btnCancel);
        container.add((Component)this.btnBox, ce1);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveDiagramsWindow.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveDiagramsWindow.this.escapePressed();
            }
        });
        this.chbSaveAll.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (SaveDiagramsWindow.this.chbSaveAll.isSelected()) {
                    for (JCheckBox checks : SaveDiagramsWindow.this.checkBoxes) {
                        checks.setSelected(true);
                    }
                } else {
                    for (JCheckBox checks : SaveDiagramsWindow.this.checkBoxes) {
                        checks.setSelected(false);
                    }
                }
            }
        });
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SaveDiagramsWindow.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    SaveDiagramsWindow.this.enterPressed();
                }
                return false;
            }
        });
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public void enterPressed() {
        this.checked.clear();
        for (JCheckBox checks : this.checkBoxes) {
            if (!checks.isSelected()) continue;
            this.checked.add(this.unsaved.get(Integer.parseInt(checks.getName())));
        }
        this.setDialogResult(true);
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }

    public void setDialogResult(boolean result) {
        this.dialogResult = result;
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public ArrayList<GERMModel> getCheckedDiagrams() {
        return this.checked;
    }
}

