/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.ColorWindow;
import germ.gui.windows.defaultNodeProperties;
import germ.i18n.Messages;
import germ.util.Cursors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.MaskFormatter;

public class SettingsWindow
extends JDialog {
    private JLabel lblURStackSize = new JLabel(Messages.getString("SettingsWindow.0"));
    private JFormattedTextField tfURStackSize;
    private JLabel lblTheme = new JLabel(Messages.getString("SettingsWindow.1"));
    private JLabel lblArrowMoveStep = new JLabel(Messages.getString("SettingsWindow.2"));
    private JFormattedTextField tfArrowMoveStep;
    private JLabel lblShowGrid = new JLabel(Messages.getString("SettingsWindow.3"));
    private JCheckBox chbShowGrid = new JCheckBox();
    private JLabel lblTreeSize = new JLabel(Messages.getString("SettingsWindow.5"));
    private JFormattedTextField tfTreeSize;
    private JLabel lblNodes = new JLabel(Messages.getString("SettingsWindow.6"));
    private JButton btnNodeProperties = new JButton(Messages.getString("SettingsWindow.7"));
    private Box okCancelBox = Box.createHorizontalBox();
    private JButton btnOK = new JButton(Messages.getString("SettingsWindow.8"));
    private JButton btnCancel = new JButton(Messages.getString("SettingsWindow.9"));
    private JLabel lblShadow = new JLabel(Messages.getString("SettingsWindow.11"));
    private JCheckBox chbShadow = new JCheckBox();
    private JLabel lblLasoOverNode = new JLabel(Messages.getString("SettingsWindow.12"));
    private JCheckBox chbLaso = new JCheckBox();
    private JLabel lblBacgroundColor = new JLabel(Messages.getString("SettingsWindow.13"));
    private JButton btnBackColor = new JButton(Messages.getString("SettingsWindow.14"));
    private JLabel lblGridColor = new JLabel(Messages.getString("SettingsWindow.15"));
    private JButton btnGridColor = new JButton(Messages.getString("SettingsWindow.16"));
    private JLabel lblAnimation = new JLabel(Messages.getString("SettingsWindow.18"));
    private JCheckBox chbAnimation = new JCheckBox();
    protected boolean dialogResult = false;
    private ArrayList<String> themeItems = ConfigurationManager.getInstance().getStringArray("allThemes");
    private JComboBox cbTheme = new JComboBox();
    private String theme = ConfigurationManager.getInstance().getString("theme");
    private int urStackSize = ConfigurationManager.getInstance().getInt("undoRedoStackSize");
    private int arrowMoveStep = ConfigurationManager.getInstance().getInt("arrowMoveStep");
    private int treeSize = ConfigurationManager.getInstance().getInt("treeSize");
    private boolean showGrid = ConfigurationManager.getInstance().getBoolean("showGrid");
    private JLabel lblLanguage = new JLabel(Messages.getString("SettingsWindow.10"));
    private ImageIcon[] flags;
    private String[] languages = new String[]{"ENG", "FRA", "GER", "HUN", "ITA", "SER", "\u0421\u0420\u0411", "ESP"};
    private JComboBox cbLanguages;
    private String language = ConfigurationManager.getInstance().getString("language");
    private boolean showLaso = ConfigurationManager.getInstance().getBoolean("lasoOverNodeShow");
    private boolean showShadow = ConfigurationManager.getInstance().getBoolean("nodeShadow");
    private Color backgroundColor = ConfigurationManager.getInstance().getColor("background");
    private Color gridColor = ConfigurationManager.getInstance().getColor("gridColor");
    private boolean showAnimation = ConfigurationManager.getInstance().getBoolean("animationEnabled");

    public SettingsWindow() {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(1);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setTitle(Messages.getString("SettingsWindow.17"));
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        this.comboFlags();
        this.cbTheme.setEditable(false);
        this.cbTheme.setPreferredSize(new Dimension(65, 20));
        for (String s : this.themeItems) {
            this.cbTheme.addItem(s);
        }
        this.btnNodeProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                defaultNodeProperties dn = new defaultNodeProperties();
                dn.setVisible(true);
                if (dn.isDialogResult()) {
                    SettingsWindow.this.setNewSettings(dn);
                }
            }
        });
        this.btnGridColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setColor(SettingsWindow.this.gridColor);
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    SettingsWindow.this.setGridColor(cw.getColor());
                }
            }
        });
        this.btnBackColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                cw.setColor(SettingsWindow.this.backgroundColor);
                cw.setVisible(true);
                if (cw.isDialogResult()) {
                    SettingsWindow.this.setBackgroundColor(cw.getColor());
                }
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsWindow.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsWindow.this.escapePressed();
            }
        });
        try {
            MaskFormatter mask0 = new MaskFormatter("#***");
            mask0.setValidCharacters("0123456789 ");
            this.tfURStackSize = new JFormattedTextField(mask0);
            this.tfURStackSize.setColumns(5);
            MaskFormatter mask1 = new MaskFormatter("#***");
            mask1.setValidCharacters("0123456789 ");
            this.tfArrowMoveStep = new JFormattedTextField(mask1);
            this.tfArrowMoveStep.setColumns(5);
            MaskFormatter mask2 = new MaskFormatter("#***");
            mask2.setValidCharacters("0123456789 ");
            this.tfTreeSize = new JFormattedTextField(mask2);
            this.tfTreeSize.setColumns(5);
        }
        catch (ParseException mask0) {
            // empty catch block
        }
        Container container = this.getContentPane();
        GridBagConstraints c00 = new GridBagConstraints();
        c00.gridx = 0;
        c00.gridy = 0;
        c00.anchor = 12;
        c00.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 1;
        c10.gridy = 0;
        c10.anchor = 17;
        c10.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 13;
        c01.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.anchor = 17;
        c11.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c02 = new GridBagConstraints();
        c02.gridx = 0;
        c02.gridy = 2;
        c02.anchor = 13;
        c02.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c12 = new GridBagConstraints();
        c12.gridx = 1;
        c12.gridy = 2;
        c12.anchor = 17;
        c12.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c03 = new GridBagConstraints();
        c03.gridx = 0;
        c03.gridy = 3;
        c03.anchor = 13;
        c03.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c13 = new GridBagConstraints();
        c13.gridx = 1;
        c13.gridy = 3;
        c13.anchor = 17;
        c13.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c04 = new GridBagConstraints();
        c04.gridx = 0;
        c04.gridy = 4;
        c04.anchor = 13;
        c04.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c14 = new GridBagConstraints();
        c14.gridx = 1;
        c14.gridy = 4;
        c14.anchor = 17;
        c14.insets = new Insets(10, 17, 0, 20);
        GridBagConstraints c05 = new GridBagConstraints();
        c05.gridx = 0;
        c05.gridy = 5;
        c05.anchor = 13;
        c05.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c15 = new GridBagConstraints();
        c15.gridx = 1;
        c15.gridy = 5;
        c15.anchor = 17;
        c15.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c06 = new GridBagConstraints();
        c06.gridx = 0;
        c06.gridy = 6;
        c06.anchor = 13;
        c06.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c16 = new GridBagConstraints();
        c16.gridx = 1;
        c16.gridy = 6;
        c16.anchor = 17;
        c16.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c07 = new GridBagConstraints();
        c07.gridx = 0;
        c07.gridy = 7;
        c07.anchor = 13;
        c07.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c17 = new GridBagConstraints();
        c17.gridx = 1;
        c17.gridy = 7;
        c17.anchor = 17;
        c17.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints c08 = new GridBagConstraints();
        c08.gridx = 0;
        c08.gridy = 8;
        c08.anchor = 13;
        c08.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c18 = new GridBagConstraints();
        c18.gridx = 1;
        c18.gridy = 8;
        c18.anchor = 17;
        c18.insets = new Insets(10, 17, 0, 20);
        GridBagConstraints c09 = new GridBagConstraints();
        c09.gridx = 0;
        c09.gridy = 9;
        c09.anchor = 13;
        c09.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c19 = new GridBagConstraints();
        c19.gridx = 1;
        c19.gridy = 9;
        c19.anchor = 17;
        c19.insets = new Insets(10, 17, 0, 20);
        GridBagConstraints c010 = new GridBagConstraints();
        c010.gridx = 0;
        c010.gridy = 10;
        c010.anchor = 13;
        c010.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c110 = new GridBagConstraints();
        c110.gridx = 1;
        c110.gridy = 10;
        c110.anchor = 17;
        c110.insets = new Insets(10, 17, 0, 20);
        GridBagConstraints c011 = new GridBagConstraints();
        c011.gridx = 0;
        c011.gridy = 11;
        c011.anchor = 13;
        c011.insets = new Insets(10, 20, 0, 0);
        GridBagConstraints c111 = new GridBagConstraints();
        c111.gridx = 1;
        c111.gridy = 11;
        c111.anchor = 17;
        c111.insets = new Insets(10, 20, 0, 20);
        GridBagConstraints cOK = new GridBagConstraints();
        cOK.gridx = 0;
        cOK.gridy = 12;
        cOK.gridwidth = 2;
        cOK.anchor = 10;
        cOK.insets = new Insets(35, 0, 10, 0);
        this.okCancelBox.add(this.btnOK);
        this.okCancelBox.add(Box.createHorizontalStrut(40));
        this.okCancelBox.add(this.btnCancel);
        container.add((Component)this.lblTheme, c00);
        container.add((Component)this.cbTheme, c10);
        container.add((Component)this.lblURStackSize, c01);
        container.add((Component)this.tfURStackSize, c11);
        container.add((Component)this.lblArrowMoveStep, c02);
        container.add((Component)this.tfArrowMoveStep, c12);
        container.add((Component)this.lblTreeSize, c03);
        container.add((Component)this.tfTreeSize, c13);
        container.add((Component)this.lblShowGrid, c04);
        container.add((Component)this.chbShowGrid, c14);
        container.add((Component)this.lblGridColor, c05);
        container.add((Component)this.btnGridColor, c15);
        container.add((Component)this.lblBacgroundColor, c06);
        container.add((Component)this.btnBackColor, c16);
        container.add((Component)this.lblNodes, c07);
        container.add((Component)this.btnNodeProperties, c17);
        container.add((Component)this.lblShadow, c08);
        container.add((Component)this.chbShadow, c18);
        container.add((Component)this.lblLasoOverNode, c09);
        container.add((Component)this.chbLaso, c19);
        container.add((Component)this.lblAnimation, c010);
        container.add((Component)this.chbAnimation, c110);
        container.add((Component)this.lblLanguage, c011);
        container.add((Component)this.cbLanguages, c111);
        container.add((Component)this.okCancelBox, cOK);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SettingsWindow.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    SettingsWindow.this.enterPressed();
                }
                return false;
            }
        });
        this.setCursor(Cursors.getCursor("default"));
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(boolean dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setNewSettings(defaultNodeProperties dn) {
        try {
            dn.getTabs().setArgumentSize(new Dimension(Integer.parseInt(dn.getTabs().getArgumentWidth().trim().replaceAll(" ", "")), Integer.parseInt(dn.getTabs().getArgumentHeight().trim().replaceAll(" ", ""))));
            dn.getTabs().setAssumptionSize(new Dimension(Integer.parseInt(dn.getTabs().getAssumptionWidth().trim().replaceAll(" ", "")), Integer.parseInt(dn.getTabs().getAssumptionHeight().trim().replaceAll(" ", ""))));
            dn.getTabs().setDecisionSize(new Dimension(Integer.parseInt(dn.getTabs().getDecisionWidth().trim().replaceAll(" ", "")), Integer.parseInt(dn.getTabs().getDecisionHeight().trim().replaceAll(" ", ""))));
            dn.getTabs().setPositionSize(new Dimension(Integer.parseInt(dn.getTabs().getPositionWidth().trim().replaceAll(" ", "")), Integer.parseInt(dn.getTabs().getPositionHeight().trim().replaceAll(" ", ""))));
            dn.getTabs().setStakeholderSize(new Dimension(Integer.parseInt(dn.getTabs().getStakeholderWidth().trim().replaceAll(" ", "")), Integer.parseInt(dn.getTabs().getStakeholderHeight().trim().replaceAll(" ", ""))));
            dn.getTabs().setTopicSize(new Dimension(Integer.parseInt(dn.getTabs().getTopicWidth().trim().replaceAll(" ", "")), Integer.parseInt(dn.getTabs().getTopicHeight().trim().replaceAll(" ", ""))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigurationManager.getInstance().setColor("argumentStrokeColor", dn.getTabs().getArgumentStrokeColor());
        ConfigurationManager.getInstance().setColor("argumentFillPrimColor", dn.getTabs().getArgumentPrimaryColor());
        ConfigurationManager.getInstance().setColor("argumentFillSecColor", dn.getTabs().getArgumentSecondaryColor());
        ConfigurationManager.getInstance().setFloat("argumentStrokeThickness", Float.valueOf(dn.getTabs().getArgumentStrokeThickness()));
        ConfigurationManager.getInstance().setDimention("argumentSize", dn.getTabs().getArgumentSize());
        ConfigurationManager.getInstance().setColor("assumptionStrokeColor", dn.getTabs().getAssumptionStrokeColor());
        ConfigurationManager.getInstance().setColor("assumptionFillPrimColor", dn.getTabs().getAssumptionPrimaryColor());
        ConfigurationManager.getInstance().setColor("assumptionFillSecColor", dn.getTabs().getAssumptionSecondaryColor());
        ConfigurationManager.getInstance().setFloat("assumptionStrokeThickness", Float.valueOf(dn.getTabs().getAssumptionStrokeThickness()));
        ConfigurationManager.getInstance().setDimention("assumptionSize", dn.getTabs().getAssumptionSize());
        ConfigurationManager.getInstance().setColor("decisionStrokeColor", dn.getTabs().getDecisionStrokeColor());
        ConfigurationManager.getInstance().setColor("decisionFillPrimColor", dn.getTabs().getDecisionPrimaryColor());
        ConfigurationManager.getInstance().setColor("decisionFillSecColor", dn.getTabs().getDecisionSecondaryColor());
        ConfigurationManager.getInstance().setFloat("decisionStrokeThickness", Float.valueOf(dn.getTabs().getDecisionStrokeThickness()));
        ConfigurationManager.getInstance().setDimention("decisionSize", dn.getTabs().getDecisionSize());
        ConfigurationManager.getInstance().setColor("positionStrokeColor", dn.getTabs().getPositionStrokeColor());
        ConfigurationManager.getInstance().setColor("positionFillPrimColor", dn.getTabs().getPositionPrimaryColor());
        ConfigurationManager.getInstance().setColor("positionFillSecColor", dn.getTabs().getPositionSecondaryColor());
        ConfigurationManager.getInstance().setFloat("positionStrokeThickness", Float.valueOf(dn.getTabs().getPositionStrokeThickness()));
        ConfigurationManager.getInstance().setDimention("positionSize", dn.getTabs().getPositionSize());
        ConfigurationManager.getInstance().setColor("stakeholderStrokeColor", dn.getTabs().getStakeholderStrokeColor());
        ConfigurationManager.getInstance().setColor("stakeholderFillPrimColor", dn.getTabs().getStakeholderPrimaryColor());
        ConfigurationManager.getInstance().setColor("stakeholderFillSecColor", dn.getTabs().getStakeholderSecondaryColor());
        ConfigurationManager.getInstance().setFloat("stakeholderStrokeThickness", Float.valueOf(dn.getTabs().getStakeholderStrokeThickness()));
        ConfigurationManager.getInstance().setDimention("stakeholderSize", dn.getTabs().getStakeholderSize());
        ConfigurationManager.getInstance().setColor("topicStrokeColor", dn.getTabs().getTopicStrokeColor());
        ConfigurationManager.getInstance().setColor("topicFillPrimColor", dn.getTabs().getTopicPrimaryColor());
        ConfigurationManager.getInstance().setColor("topicFillSecColor", dn.getTabs().getTopicSecondaryColor());
        ConfigurationManager.getInstance().setFloat("topicStrokeThickness", Float.valueOf(dn.getTabs().getTopicStrokeThickness()));
        ConfigurationManager.getInstance().setDimention("topicSize", dn.getTabs().getTopicSize());
        dn.getTabs().setRequirementSize(new Dimension(Integer.parseInt(dn.getTabs().getRequirementWidth().trim().replaceAll(" ", "")), Integer.parseInt(dn.getTabs().getRequirementHeight().trim().replaceAll(" ", ""))));
        ConfigurationManager.getInstance().setColor("requirementStrokeColor", dn.getTabs().getRequirementStrokeColor());
        ConfigurationManager.getInstance().setColor("requirementFillPrimColor", dn.getTabs().getRequirementPrimaryColor());
        ConfigurationManager.getInstance().setColor("requirementFillSecColor", dn.getTabs().getRequirementSecondaryColor());
        ConfigurationManager.getInstance().setFloat("requirementStrokeThickness", Float.valueOf(dn.getTabs().getRequirementStrokeThickness()));
        ConfigurationManager.getInstance().setDimention("requirementSize", dn.getTabs().getRequirementSize());
    }

    public void enterPressed() {
        this.setDialogResult(true);
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }

    public String getURStackSize() {
        return this.tfURStackSize.getText();
    }

    public void setURStackSize(String urStackSize) {
        this.tfURStackSize.setText(urStackSize);
    }

    public String getTheme() {
        return String.valueOf(this.cbTheme.getSelectedItem().toString().trim()) + "/";
    }

    public void setTheme(String theme) {
        this.cbTheme.setEditable(true);
        this.cbTheme.setSelectedItem(theme.replace('/', ' '));
        this.cbTheme.setEditable(false);
    }

    public String getArrowMoveStep() {
        return this.tfArrowMoveStep.getText();
    }

    public void setArrowMoveStep(String arrowMoveStep) {
        this.tfArrowMoveStep.setText(arrowMoveStep);
    }

    public boolean isShowGrid() {
        return this.chbShowGrid.isSelected();
    }

    public void setShowGrid(boolean showGrid) {
        this.chbShowGrid.setSelected(showGrid);
    }

    public boolean isAnimation() {
        return this.chbAnimation.isSelected();
    }

    public void setAnimation(boolean animation) {
        this.chbAnimation.setSelected(animation);
    }

    public String getTreeSize() {
        return this.tfTreeSize.getText();
    }

    public void setTreeSize(String treeSize) {
        this.tfTreeSize.setText(treeSize);
    }

    public String getLanguage(int index) {
        return this.languages[index];
    }

    public String getLanguageCurrent() {
        return this.cbLanguages.getSelectedItem().getClass().getName();
    }

    public void setLanguageCurrent(int index) {
        this.cbLanguages.setSelectedIndex(index);
    }

    public boolean isShadow() {
        return this.chbShadow.isSelected();
    }

    public void setShadow(boolean showShadow) {
        this.chbShadow.setSelected(showShadow);
    }

    public boolean isLaso() {
        return this.chbLaso.isSelected();
    }

    public void setLaso(boolean showLaso) {
        this.chbLaso.setSelected(showLaso);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public void getSettings() {
        this.setArrowMoveStep("" + this.arrowMoveStep);
        this.setTreeSize("" + this.treeSize);
        this.setURStackSize("" + this.urStackSize);
        this.setShowGrid(this.showGrid);
        this.setTheme(this.theme.substring(0, this.theme.length() - 1));
        int i = 0;
        while (i != this.languages.length) {
            if (this.language.equals(this.languages[i])) {
                this.setLanguageCurrent(i);
            }
            ++i;
        }
        this.setShadow(this.showShadow);
        this.setLaso(this.showLaso);
        this.setAnimation(this.showAnimation);
    }

    public void setSettings() {
        ConfigurationManager cm = ConfigurationManager.getInstance();
        cm.setBoolean("showGrid", this.isShowGrid());
        try {
            cm.setInt("undoRedoStackSize", Integer.parseInt(this.getURStackSize().trim().replaceAll(" ", "")));
            cm.setInt("arrowMoveStep", Integer.parseInt(this.getArrowMoveStep().trim().replaceAll(" ", "")));
            cm.setInt("treeSize", Integer.parseInt(this.getTreeSize().trim().replaceAll(" ", "")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        cm.setString("theme", this.getTheme());
        cm.setString("language", this.getLanguage(Integer.parseInt(this.cbLanguages.getSelectedItem().toString())));
        cm.setBoolean("nodeShadow", this.isShadow());
        cm.setBoolean("lasoOverNodeShow", this.isLaso());
        cm.setColor("background", this.getBackgroundColor());
        cm.setColor("gridColor", this.getGridColor());
        cm.setBoolean("animationEnabled", this.isAnimation());
    }

    public void initializeFlags() {
        this.flags = new ImageIcon[8];
        this.flags[0] = new ImageIcon("germ/gui/windows/images/flags/english.jpg");
        this.flags[1] = new ImageIcon("germ/gui/windows/images/flags/france.jpg");
        this.flags[2] = new ImageIcon("germ/gui/windows/images/flags/german.jpg");
        this.flags[3] = new ImageIcon("germ/gui/windows/images/flags/hungarian.jpg");
        this.flags[4] = new ImageIcon("germ/gui/windows/images/flags/italy.jpg");
        this.flags[5] = new ImageIcon("germ/gui/windows/images/flags/serbian.jpg");
        this.flags[6] = new ImageIcon("germ/gui/windows/images/flags/serbian.jpg");
        this.flags[7] = new ImageIcon("germ/gui/windows/images/flags/spain.jpg");
    }

    public void comboFlags() {
        this.initializeFlags();
        Integer[] intArray = new Integer[this.languages.length];
        int i = 0;
        while (i < this.languages.length) {
            intArray[i] = new Integer(i);
            ++i;
        }
        this.cbLanguages = new JComboBox<Integer>(intArray);
        ComboBoxRenderer renderer = new ComboBoxRenderer();
        this.cbLanguages.setRenderer(renderer);
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = (Integer)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ImageIcon icon = SettingsWindow.this.flags[selectedIndex];
            String pet = SettingsWindow.this.languages[selectedIndex];
            this.setIcon(icon);
            if (icon != null) {
                this.setText(pet);
                this.setFont(list.getFont());
            }
            return this;
        }
    }
}

