/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.command.MoveCommand;
import germ.model.Link;
import germ.model.Node;
import germ.view.GERMView;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerThread
extends Thread {
    private boolean run = true;
    private Integer offsetX;
    private Integer offsetY;
    private double zoomSliderValue;
    private Point2D relocate = null;
    private ArrayList<Node> relocatingNodes = null;
    private ArrayList<Point2D> relocNodesPos = null;
    private ArrayList<Link> relocatingLinks = null;
    private ArrayList<ArrayList<Point>> breakPointsPos = null;
    private boolean fastZoomAndScale = false;
    private boolean ignoreMinStepLimit = false;
    private MoveCommand moveCommand = null;
    private double newScale = -1.0;

    public TimerThread(Integer offsetX, Integer offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.zoomSliderValue = 0.0;
    }

    @Override
    public void run() {
        while (this.run) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            GERMView v = Application.getInstance().getMainWindow().getView();
            if (this.offsetX != 0 || this.offsetY != 0) {
                v.moveWorkspace(this.offsetX * 1, this.offsetY * 1);
            }
            if (this.zoomSliderValue != 0.0) {
                v.zoom(this.zoomSliderValue * v.getTransform().getScaleX() * 2.0);
            }
            if (this.newScale > 0.0) {
                double oldScale = v.getTransform().getScaleX();
                double step = 0.05;
                if (this.fastZoomAndScale) {
                    step *= 3.0;
                }
                step *= oldScale;
                if (Math.abs(oldScale - this.newScale) < step && Math.abs(oldScale - this.newScale) >= step / 2.0) {
                    step /= 2.0;
                }
                if (Math.abs(oldScale - this.newScale) < step && !this.ignoreMinStepLimit) {
                    this.newScale = -1.0;
                    if (this.relocate == null) {
                        this.fastZoomAndScale = false;
                    }
                } else if (oldScale < this.newScale) {
                    v.zoom(step);
                } else {
                    v.zoom(-step);
                }
                this.ignoreMinStepLimit = false;
            }
            if (this.relocatingNodes != null) {
                int unmovedNodesCounter = 0;
                Point2D.Double locationDiff = new Point2D.Double();
                int i = 0;
                while (i < this.relocatingNodes.size()) {
                    this.relocateCalculator(this.relocatingNodes.get(i).getPosition(), this.relocNodesPos.get(i), locationDiff);
                    this.relocatingNodes.get(i).getPosition().setLocation(this.relocatingNodes.get(i).getPosition().getX() - locationDiff.x, this.relocatingNodes.get(i).getPosition().getY() - locationDiff.y);
                    if (locationDiff.x == 0.0 && locationDiff.y == 0.0) {
                        ++unmovedNodesCounter;
                    }
                    ++i;
                }
                if (this.relocatingLinks == null) {
                    v.repaint();
                }
                if (unmovedNodesCounter == this.relocatingNodes.size()) {
                    this.relocatingNodes = null;
                    this.relocNodesPos = null;
                    Application.getInstance().getMainWindow().restoreStatusBar();
                    if (this.moveCommand != null) {
                        this.moveCommand.moveEnded();
                        Application.getInstance().getCommandManager().doCommand(this.moveCommand);
                    }
                }
            }
            if (this.relocatingLinks != null) {
                double totalMove = 0.0;
                Point2D.Double locationDiff = new Point2D.Double();
                int i = 0;
                while (i < this.relocatingLinks.size()) {
                    int j = 0;
                    while (j < this.breakPointsPos.get(i).size()) {
                        Point currentBreakpoint = this.relocatingLinks.get(i).getBreakPointAt(j);
                        this.relocateCalculator(currentBreakpoint, this.breakPointsPos.get(i).get(j), locationDiff);
                        currentBreakpoint.setLocation(currentBreakpoint.getX() - ((Point2D)locationDiff).getX(), currentBreakpoint.getY() - ((Point2D)locationDiff).getY());
                        totalMove += Math.abs(((Point2D)locationDiff).getX()) + Math.abs(((Point2D)locationDiff).getY());
                        ++j;
                    }
                    ++i;
                }
                v.repaint();
                if (totalMove == 0.0) {
                    this.relocatingLinks = null;
                    this.breakPointsPos = null;
                    Application.getInstance().getMainWindow().restoreStatusBar();
                }
            }
            if (this.relocate == null) continue;
            Point screenCenter = v.getCanvasCenter();
            Point2D.Double pos = new Point2D.Double();
            this.relocateCalculator(screenCenter, this.relocate, pos);
            v.moveWorkspace(pos.x, pos.y);
            if (pos.x != 0.0 || pos.y != 0.0) continue;
            if (this.newScale == -1.0) {
                this.fastZoomAndScale = false;
            }
            this.relocate = null;
            Application.getInstance().getMainWindow().restoreStatusBar();
        }
        return;
    }

    public void relocateCalculator(Point2D currentPos, Point2D destination, Point2D diffPos) {
        double xTranslate = 0.0;
        double yTranslate = 0.0;
        double scaleFactor = 1.0 / Math.sqrt(Math.sqrt(Math.sqrt(Application.getInstance().getView().getTransform().getScaleX())));
        double precision = 5.0 * scaleFactor;
        double stepX = precision * Math.abs(currentPos.getX() - destination.getX()) / 50.0;
        double stepY = precision * Math.abs(currentPos.getY() - destination.getY()) / 50.0;
        if (this.fastZoomAndScale) {
            stepX *= 2.0;
            stepY *= 2.0;
        }
        if (stepX < precision) {
            stepX = precision;
        }
        if (stepX > precision * 30.0 && !this.fastZoomAndScale) {
            stepX = precision * 30.0;
        }
        if (stepY < precision) {
            stepY = precision;
        }
        if (stepY > precision * 30.0 && !this.fastZoomAndScale) {
            stepY = precision * 30.0;
        }
        xTranslate *= scaleFactor;
        yTranslate *= scaleFactor;
        if (Math.abs(currentPos.getX() - destination.getX()) < stepX) {
            xTranslate = 0.0;
        } else if (currentPos.getX() < destination.getX()) {
            xTranslate = -stepX;
        } else if (currentPos.getX() > destination.getX()) {
            xTranslate = stepX;
        }
        if (Math.abs(currentPos.getY() - destination.getY()) < stepY) {
            yTranslate = 0.0;
        } else if (currentPos.getY() < destination.getY()) {
            yTranslate = -stepY;
        } else if (currentPos.getY() > destination.getY()) {
            yTranslate = stepY;
        }
        diffPos.setLocation(xTranslate, yTranslate);
    }

    public void setOffset(Integer offsetX, Integer offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setZoomSliderValue(double zoomSliderValue) {
        this.zoomSliderValue = zoomSliderValue;
    }

    public void setRun(boolean value) {
        this.run = value;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setNewScale(double newScale) {
        this.newScale = newScale;
    }

    public void setRelocate(Point2D.Double relocate) {
        this.relocate = relocate;
    }

    public void setFastZoomAndScale(boolean fzas) {
        this.fastZoomAndScale = fzas;
    }

    public void setRelocatingNodesParams(ArrayList<Node> relocatingNodes, ArrayList<Point2D> relocNodesPos, MoveCommand moveCommand) {
        this.finalizeNodesMove();
        this.relocatingNodes = relocatingNodes;
        this.relocNodesPos = relocNodesPos;
        this.moveCommand = moveCommand;
    }

    public void setRelocatingBreakpoints(ArrayList<Link> relocatingLinks, ArrayList<ArrayList<Point>> breakPointsPos) {
        this.finalizeBreakpointsMove();
        if (relocatingLinks != null && relocatingLinks.size() > 0) {
            this.relocatingLinks = relocatingLinks;
        }
        if (breakPointsPos != null && breakPointsPos.size() > 0) {
            this.breakPointsPos = breakPointsPos;
        }
    }

    public void finalizeNodesMove() {
        if (this.relocatingNodes == null || this.relocNodesPos == null) {
            return;
        }
        int i = 0;
        while (i < this.relocatingNodes.size()) {
            this.relocatingNodes.get(i).getPosition().setLocation(this.relocNodesPos.get(i).getX(), this.relocNodesPos.get(i).getY());
            ++i;
        }
        Application.getInstance().getMainWindow().restoreStatusBar();
    }

    public void finalizeBreakpointsMove() {
        if (this.relocatingLinks == null || this.breakPointsPos == null) {
            return;
        }
        int i = 0;
        while (i < this.relocatingLinks.size()) {
            int j = 0;
            while (j < this.breakPointsPos.get(i).size()) {
                this.relocatingLinks.get(i).getBreakPointAt(j).setLocation(this.breakPointsPos.get(i).get(j).getX(), this.breakPointsPos.get(i).get(j).getY());
                ++j;
            }
            ++i;
        }
        Application.getInstance().getMainWindow().restoreStatusBar();
    }

    public void setRelocatingBreakpoint(Link link, ArrayList<Point> newPositions) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(link);
        ArrayList<ArrayList<Point>> breakpoints = new ArrayList<ArrayList<Point>>();
        breakpoints.add(newPositions);
        this.relocatingLinks = links;
        this.breakPointsPos = breakpoints;
    }

    public void setIgnoreMinStepLimit(boolean ignoreMinStepLimit) {
        this.ignoreMinStepLimit = ignoreMinStepLimit;
    }
}

