/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.i18n.Messages;
import germ.model.workspace.Workspace;
import germ.util.Cursors;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class WorkspaceChooserWindow
extends JDialog {
    private JLabel lblWorkspace = new JLabel(Messages.getString("WorkspaceChooserWindow.0"));
    private JTextField tfWorkspace = new JTextField();
    private JButton btnBrowse = new JButton(Messages.getString("WorkspaceChooserWindow.1"));
    private JCheckBox chbUseAsDefault = new JCheckBox(Messages.getString("WorkspaceChooserWindow.2"));
    private JButton btnOK = new JButton(Messages.getString("WorkspaceChooserWindow.3"));
    private JButton btnCancel = new JButton(Messages.getString("WorkspaceChooserWindow.4"));
    private Box okCancelBox = Box.createHorizontalBox();
    private Box workspaceBox = Box.createHorizontalBox();
    private boolean dialogResult = false;

    public WorkspaceChooserWindow() {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setTitle(Messages.getString("WorkspaceChooserWindow.5"));
        this.setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(1);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        String currentWorkspace = ConfigurationManager.getInstance().getString("workspace");
        if (Workspace.isValidWorkspace(currentWorkspace)) {
            this.setWorkspace(currentWorkspace);
        } else {
            currentWorkspace = String.valueOf(System.getProperty("user.home")) + File.separator + "GERM";
            this.setWorkspace(currentWorkspace);
        }
        Container container = this.getContentPane();
        GridBagConstraints c0 = new GridBagConstraints();
        c0.gridx = 0;
        c0.gridy = 0;
        c0.gridwidth = 2;
        c0.fill = 2;
        c0.anchor = 17;
        c0.insets = new Insets(20, 20, 0, 20);
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.anchor = 17;
        c01.insets = new Insets(20, 20, 0, 0);
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridx = 1;
        c11.gridy = 1;
        c11.anchor = 13;
        c11.insets = new Insets(20, 20, 10, 20);
        this.okCancelBox.add(this.btnOK);
        this.okCancelBox.add(Box.createHorizontalStrut(20));
        this.okCancelBox.add(this.btnCancel);
        this.workspaceBox.add(this.lblWorkspace);
        this.workspaceBox.add(Box.createHorizontalStrut(10));
        this.workspaceBox.add(this.tfWorkspace);
        this.workspaceBox.add(Box.createHorizontalStrut(15));
        this.workspaceBox.add(this.btnBrowse);
        container.add((Component)this.workspaceBox, c0);
        container.add((Component)this.chbUseAsDefault, c01);
        container.add((Component)this.okCancelBox, c11);
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkspaceChooserWindow.this.setWorkspace(Workspace.workspaceChooser(WorkspaceChooserWindow.this));
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkspaceChooserWindow.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkspaceChooserWindow.this.escapePressed();
            }
        });
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    WorkspaceChooserWindow.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    WorkspaceChooserWindow.this.enterPressed();
                }
                return false;
            }
        });
        this.setCursor(Cursors.getCursor("default"));
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public String getWorkspace() {
        return this.tfWorkspace.getText();
    }

    public void setWorkspace(String workspace) {
        this.tfWorkspace.setText(workspace);
    }

    public boolean isUseAsDefault() {
        return this.chbUseAsDefault.isSelected();
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(boolean dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void enterPressed() {
        this.setDialogResult(true);
        File newProjectDir = new File(this.getWorkspace());
        if (!newProjectDir.exists() && !newProjectDir.mkdirs()) {
            this.setAlwaysOnTop(false);
            JOptionPane.showMessageDialog(Application.getInstance().getMainWindow(), Messages.getString("WorkspaceChooserWindow.10"));
        }
        ConfigurationManager.getInstance().setString("workspace", this.getWorkspace());
        if (this.isUseAsDefault()) {
            ConfigurationManager.getInstance().setBoolean("defaultWorkspace", true);
        }
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }
}

