/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.windows;

import germ.app.Application;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.ColorWindow;
import germ.i18n.Messages;
import germ.util.Cursors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.ParseException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MaskFormatter;

public class defaultNodeProperties
extends JDialog {
    private Box okCancelBox = Box.createHorizontalBox();
    private JButton btnOK = new JButton(Messages.getString("defaultNodeProperties.0"));
    private JButton btnCancel = new JButton(Messages.getString("defaultNodeProperties.1"));
    private Tabs tabs = new Tabs();
    protected boolean dialogResult = false;

    public defaultNodeProperties() {
        try {
            this.setIconImage(ImageIO.read(new File("germ/gui/windows/images/programIcon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(1);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setTitle(Messages.getString("defaultNodeProperties.142"));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setLayout(new GridBagLayout());
        this.tabs.fillAllFields();
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                defaultNodeProperties.this.enterPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                defaultNodeProperties.this.escapePressed();
            }
        });
        Container container = this.getContentPane();
        GridBagConstraints c00 = new GridBagConstraints();
        c00.gridx = 0;
        c00.gridy = 0;
        c00.fill = 2;
        c00.anchor = 10;
        c00.insets = new Insets(10, 10, 10, 10);
        GridBagConstraints c01 = new GridBagConstraints();
        c01.gridx = 0;
        c01.gridy = 1;
        c01.weightx = 1.0;
        c01.anchor = 10;
        c01.insets = new Insets(0, 0, 10, 0);
        container.add((Component)this.tabs, c00);
        this.okCancelBox.add(this.btnOK);
        this.okCancelBox.add(Box.createHorizontalStrut(40));
        this.okCancelBox.add(this.btnCancel);
        container.add((Component)this.okCancelBox, c01);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    defaultNodeProperties.this.escapePressed();
                } else if (e.getKeyCode() == 10) {
                    defaultNodeProperties.this.enterPressed();
                }
                return false;
            }
        });
        this.setCursor(Cursors.getCursor("default"));
        this.pack();
        this.setLocation(center.x - this.getSize().width / 2, center.y - this.getSize().height / 2);
    }

    public boolean isDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(boolean dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Tabs getTabs() {
        return this.tabs;
    }

    public void enterPressed() {
        this.setDialogResult(true);
        this.setVisible(false);
    }

    public void escapePressed() {
        this.setDialogResult(false);
        this.setVisible(false);
    }

    public class Tabs
    extends JPanel {
        private JTabbedPane tpNodes = new JTabbedPane();
        private JPanel pArgument = new JPanel(new GridBagLayout());
        private JPanel pAssumption = new JPanel(new GridBagLayout());
        private JPanel pDecision = new JPanel(new GridBagLayout());
        private JPanel pPosition = new JPanel(new GridBagLayout());
        private JPanel pStakeholder = new JPanel(new GridBagLayout());
        private JPanel pTopic = new JPanel(new GridBagLayout());
        private JPanel pRequirement = new JPanel(new GridBagLayout());
        private Double[] items = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        private JLabel lblArgumentSize = new JLabel(Messages.getString("defaultNodeProperties.2"));
        private JLabel lblArgumentWidth = new JLabel(Messages.getString("defaultNodeProperties.3"));
        private JFormattedTextField tfArgumentWidth;
        private JLabel lblArgumentHeight = new JLabel(Messages.getString("defaultNodeProperties.4"));
        private JFormattedTextField tfArgumentHeight;
        private JLabel lblArgumentFill = new JLabel(Messages.getString("defaultNodeProperties.5"));
        private JCheckBox chbArgumentGradient = new JCheckBox(Messages.getString("defaultNodeProperties.6"));
        private JButton btnArgumentPrimary = new JButton(Messages.getString("defaultNodeProperties.7"));
        private JButton btnArgumentSecondary = new JButton(Messages.getString("defaultNodeProperties.8"));
        private JLabel lblArgumentStroke = new JLabel(Messages.getString("defaultNodeProperties.9"));
        private JButton btnArgumentStrokeColor = new JButton(Messages.getString("defaultNodeProperties.10"));
        private JLabel lblArgumentThickness = new JLabel(Messages.getString("defaultNodeProperties.11"));
        private JComboBox cbArgumentStrokeThickness = new JComboBox<Double>(this.items);
        private Box argumentSizeBox = Box.createHorizontalBox();
        private Box argumentFillBox = Box.createHorizontalBox();
        private Box argumentStroke = Box.createHorizontalBox();
        private JLabel lblAssumptionSize = new JLabel(Messages.getString("defaultNodeProperties.12"));
        private JLabel lblAssumptionWidth = new JLabel(Messages.getString("defaultNodeProperties.13"));
        private JFormattedTextField tfAssumptionWidth;
        private JLabel lblAssumptionHeight = new JLabel(Messages.getString("defaultNodeProperties.14"));
        private JFormattedTextField tfAssumptionHeight;
        private JLabel lblAssumptionFill = new JLabel(Messages.getString("defaultNodeProperties.15"));
        private JCheckBox chbAssumptionGradient = new JCheckBox(Messages.getString("defaultNodeProperties.16"));
        private JButton btnAssumptionPrimary = new JButton(Messages.getString("defaultNodeProperties.17"));
        private JButton btnAssumptionSecondary = new JButton(Messages.getString("defaultNodeProperties.18"));
        private JLabel lblAssumptionStroke = new JLabel(Messages.getString("defaultNodeProperties.19"));
        private JButton btnAssumptionStrokeColor = new JButton(Messages.getString("defaultNodeProperties.20"));
        private JLabel lblAssumptionThickness = new JLabel(Messages.getString("defaultNodeProperties.21"));
        private JComboBox cbAssumptionStrokeThickness = new JComboBox<Double>(this.items);
        private Box assumptionSizeBox = Box.createHorizontalBox();
        private Box assumptionFillBox = Box.createHorizontalBox();
        private Box assumptionStroke = Box.createHorizontalBox();
        private JLabel lblDecisionSize = new JLabel(Messages.getString("defaultNodeProperties.22"));
        private JLabel lblDecisionWidth = new JLabel(Messages.getString("defaultNodeProperties.23"));
        private JFormattedTextField tfDecisionWidth;
        private JLabel lblDecisionHeight = new JLabel(Messages.getString("defaultNodeProperties.24"));
        private JFormattedTextField tfDecisionHeight;
        private JLabel lblDecisionFill = new JLabel(Messages.getString("defaultNodeProperties.25"));
        private JCheckBox chbDecisionGradient = new JCheckBox(Messages.getString("defaultNodeProperties.26"));
        private JButton btnDecisionPrimary = new JButton(Messages.getString("defaultNodeProperties.27"));
        private JButton btnDecisionSecondary = new JButton(Messages.getString("defaultNodeProperties.28"));
        private JLabel lblDecisionStroke = new JLabel(Messages.getString("defaultNodeProperties.29"));
        private JButton btnDecisionStrokeColor = new JButton(Messages.getString("defaultNodeProperties.30"));
        private JLabel lblDecisionThickness = new JLabel(Messages.getString("defaultNodeProperties.31"));
        private JComboBox cbDecisionStrokeThickness = new JComboBox<Double>(this.items);
        private Box decisionSizeBox = Box.createHorizontalBox();
        private Box decisionFillBox = Box.createHorizontalBox();
        private Box decisionStroke = Box.createHorizontalBox();
        private JLabel lblPositionSize = new JLabel(Messages.getString("defaultNodeProperties.32"));
        private JLabel lblPositionWidth = new JLabel(Messages.getString("defaultNodeProperties.33"));
        private JFormattedTextField tfPositionWidth;
        private JLabel lblPositionHeight = new JLabel(Messages.getString("defaultNodeProperties.34"));
        private JFormattedTextField tfPositionHeight;
        private JLabel lblPositionFill = new JLabel(Messages.getString("defaultNodeProperties.35"));
        private JCheckBox chbPositionGradient = new JCheckBox(Messages.getString("defaultNodeProperties.36"));
        private JButton btnPositionPrimary = new JButton(Messages.getString("defaultNodeProperties.37"));
        private JButton btnPositionSecondary = new JButton(Messages.getString("defaultNodeProperties.38"));
        private JLabel lblPositionStroke = new JLabel(Messages.getString("defaultNodeProperties.39"));
        private JButton btnPositionStrokeColor = new JButton(Messages.getString("defaultNodeProperties.40"));
        private JLabel lblPositionThickness = new JLabel(Messages.getString("defaultNodeProperties.41"));
        private JComboBox cbPositionStrokeThickness = new JComboBox<Double>(this.items);
        private Box positionSizeBox = Box.createHorizontalBox();
        private Box positionFillBox = Box.createHorizontalBox();
        private Box positionStroke = Box.createHorizontalBox();
        private JLabel lblRequirementSize = new JLabel(Messages.getString("defaultNodeProperties.42"));
        private JLabel lblRequirementWidth = new JLabel(Messages.getString("defaultNodeProperties.43"));
        private JFormattedTextField tfRequirementWidth;
        private JLabel lblRequirementHeight = new JLabel(Messages.getString("defaultNodeProperties.44"));
        private JFormattedTextField tfRequirementHeight;
        private JLabel lblRequirementFill = new JLabel(Messages.getString("defaultNodeProperties.45"));
        private JCheckBox chbRequirementGradient = new JCheckBox(Messages.getString("defaultNodeProperties.46"));
        private JButton btnRequirementPrimary = new JButton(Messages.getString("defaultNodeProperties.47"));
        private JButton btnRequirementSecondary = new JButton(Messages.getString("defaultNodeProperties.48"));
        private JLabel lblRequirementStroke = new JLabel(Messages.getString("defaultNodeProperties.49"));
        private JButton btnRequirementStrokeColor = new JButton(Messages.getString("defaultNodeProperties.50"));
        private JLabel lblRequirementThickness = new JLabel(Messages.getString("defaultNodeProperties.51"));
        private JComboBox cbRequirementStrokeThickness = new JComboBox<Double>(this.items);
        private Box requirementSizeBox = Box.createHorizontalBox();
        private Box requirementFillBox = Box.createHorizontalBox();
        private Box requirementStroke = Box.createHorizontalBox();
        private JLabel lblStakeholderSize = new JLabel(Messages.getString("defaultNodeProperties.52"));
        private JLabel lblStakeholderWidth = new JLabel(Messages.getString("defaultNodeProperties.53"));
        private JFormattedTextField tfStakeholderWidth;
        private JLabel lblStakeholderHeight = new JLabel(Messages.getString("defaultNodeProperties.54"));
        private JFormattedTextField tfStakeholderHeight;
        private JLabel lblStakeholderFill = new JLabel(Messages.getString("defaultNodeProperties.55"));
        private JCheckBox chbStakeholderGradient = new JCheckBox(Messages.getString("defaultNodeProperties.56"));
        private JButton btnStakeholderPrimary = new JButton(Messages.getString("defaultNodeProperties.57"));
        private JButton btnStakeholderSecondary = new JButton(Messages.getString("defaultNodeProperties.58"));
        private JLabel lblStakeholderStroke = new JLabel(Messages.getString("defaultNodeProperties.59"));
        private JButton btnStakeholderStrokeColor = new JButton(Messages.getString("defaultNodeProperties.60"));
        private JLabel lblStakeholderThickness = new JLabel(Messages.getString("defaultNodeProperties.61"));
        private JComboBox cbStakeholderStrokeThickness = new JComboBox<Double>(this.items);
        private Box stakeholderSizeBox = Box.createHorizontalBox();
        private Box stakeholderFillBox = Box.createHorizontalBox();
        private Box stakeholderStroke = Box.createHorizontalBox();
        private JLabel lblTopicSize = new JLabel(Messages.getString("defaultNodeProperties.62"));
        private JLabel lblTopicWidth = new JLabel(Messages.getString("defaultNodeProperties.63"));
        private JFormattedTextField tfTopicWidth;
        private JLabel lblTopicHeight = new JLabel(Messages.getString("defaultNodeProperties.64"));
        private JFormattedTextField tfTopicHeight;
        private JLabel lblTopicFill = new JLabel(Messages.getString("defaultNodeProperties.65"));
        private JCheckBox chbTopicGradient = new JCheckBox(Messages.getString("defaultNodeProperties.66"));
        private JButton btnTopicPrimary = new JButton(Messages.getString("defaultNodeProperties.67"));
        private JButton btnTopicSecondary = new JButton(Messages.getString("defaultNodeProperties.68"));
        private JLabel lblTopicStroke = new JLabel(Messages.getString("defaultNodeProperties.69"));
        private JButton btnTopicStrokeColor = new JButton(Messages.getString("defaultNodeProperties.70"));
        private JLabel lblTopicThickness = new JLabel(Messages.getString("defaultNodeProperties.71"));
        private JComboBox cbTopicStrokeThickness = new JComboBox<Double>(this.items);
        private Box topicSizeBox = Box.createHorizontalBox();
        private Box topicFillBox = Box.createHorizontalBox();
        private Box topicStroke = Box.createHorizontalBox();
        private Color argumentStrokeColor = ConfigurationManager.getInstance().getColor("argumentStrokeColor");
        private Color argumentPrimaryColor = ConfigurationManager.getInstance().getColor("argumentFillPrimColor");
        private Color argumentSecondaryColor = ConfigurationManager.getInstance().getColor("argumentFillSecColor");
        private float argumentStrokeThickness = ConfigurationManager.getInstance().getFloat("argumentStrokeThickness");
        private Dimension argumentSize = ConfigurationManager.getInstance().getDimension("argumentSize");
        private Color assumptionStrokeColor = ConfigurationManager.getInstance().getColor("assumptionStrokeColor");
        private Color assumptionPrimaryColor = ConfigurationManager.getInstance().getColor("assumptionFillPrimColor");
        private Color assumptionSecondaryColor = ConfigurationManager.getInstance().getColor("assumptionFillSecColor");
        private float assumptionStrokeThickness = ConfigurationManager.getInstance().getFloat("assumptionStrokeThickness");
        private Dimension assumptionSize = ConfigurationManager.getInstance().getDimension("assumptionSize");
        private Color decisionStrokeColor = ConfigurationManager.getInstance().getColor("decisionStrokeColor");
        private Color decisionPrimaryColor = ConfigurationManager.getInstance().getColor("decisionFillPrimColor");
        private Color decisionSecondaryColor = ConfigurationManager.getInstance().getColor("decisionFillSecColor");
        private float decisionStrokeThickness = ConfigurationManager.getInstance().getFloat("decisionStrokeThickness");
        private Dimension decisionSize = ConfigurationManager.getInstance().getDimension("decisionSize");
        private Color positionStrokeColor = ConfigurationManager.getInstance().getColor("positionStrokeColor");
        private Color positionPrimaryColor = ConfigurationManager.getInstance().getColor("positionFillPrimColor");
        private Color positionSecondaryColor = ConfigurationManager.getInstance().getColor("positionFillSecColor");
        private float positionStrokeThickness = ConfigurationManager.getInstance().getFloat("positionStrokeThickness");
        private Dimension positionSize = ConfigurationManager.getInstance().getDimension("positionSize");
        private Color requirementStrokeColor = ConfigurationManager.getInstance().getColor("requirementStrokeColor");
        private Color requirementPrimaryColor = ConfigurationManager.getInstance().getColor("requirementFillPrimColor");
        private Color requirementSecondaryColor = ConfigurationManager.getInstance().getColor("requirementFillSecColor");
        private float requirementStrokeThickness = ConfigurationManager.getInstance().getFloat("requirementStrokeThickness");
        private Dimension requirementSize = ConfigurationManager.getInstance().getDimension("requirementSize");
        private Color stakeholderStrokeColor = ConfigurationManager.getInstance().getColor("stakeholderStrokeColor");
        private Color stakeholderPrimaryColor = ConfigurationManager.getInstance().getColor("stakeholderFillPrimColor");
        private Color stakeholderSecondaryColor = ConfigurationManager.getInstance().getColor("stakeholderFillSecColor");
        private float stakeholderStrokeThickness = ConfigurationManager.getInstance().getFloat("stakeholderStrokeThickness");
        private Dimension stakeholderSize = ConfigurationManager.getInstance().getDimension("stakeholderSize");
        private Color topicStrokeColor = ConfigurationManager.getInstance().getColor("topicStrokeColor");
        private Color topicPrimaryColor = ConfigurationManager.getInstance().getColor("topicFillPrimColor");
        private Color topicSecondaryColor = ConfigurationManager.getInstance().getColor("topicFillSecColor");
        private float topicStrokeThickness = ConfigurationManager.getInstance().getFloat("topicStrokeThickness");
        private Dimension topicSize = ConfigurationManager.getInstance().getDimension("topicSize");

        public Tabs() {
            this.tpNodes.addTab(Messages.getString("defaultNodeProperties.72"), this.pArgument);
            this.tpNodes.addTab(Messages.getString("defaultNodeProperties.73"), this.pAssumption);
            this.tpNodes.addTab(Messages.getString("defaultNodeProperties.109"), this.pDecision);
            this.tpNodes.addTab(Messages.getString("defaultNodeProperties.110"), this.pPosition);
            this.tpNodes.addTab(Messages.getString("defaultNodeProperties.111"), this.pRequirement);
            this.tpNodes.addTab(Messages.getString("defaultNodeProperties.112"), this.pStakeholder);
            this.tpNodes.addTab(Messages.getString("defaultNodeProperties.113"), this.pTopic);
            this.initialiseArgumentTab();
            this.initialiseAssumptionTab();
            this.initialiseDecisionTab();
            this.initialisePositionTab();
            this.initialiseRequirementTab();
            this.initialiseStakeholderTab();
            this.initialiseTopicTab();
            this.add(this.tpNodes);
        }

        public void initialiseArgumentTab() {
            this.cbArgumentStrokeThickness.setPreferredSize(new Dimension(50, 20));
            this.cbArgumentStrokeThickness.setEditable(true);
            this.btnArgumentSecondary.setEnabled(false);
            this.btnArgumentStrokeColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getArgumentStrokeColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setArgumentStrokeColor(cw.getColor());
                    }
                }
            });
            this.btnArgumentPrimary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getArgumentPrimaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setArgumentPrimaryColor(cw.getColor());
                    }
                }
            });
            this.btnArgumentSecondary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getArgumentSecondaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setArgumentSecondaryColor(cw.getColor());
                    }
                }
            });
            this.cbArgumentStrokeThickness.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        Tabs.this.setArgumentStrokeThickness(Float.parseFloat(Tabs.this.cbArgumentStrokeThickness.getSelectedItem().toString()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("defaultNodeProperties.114"), Messages.getString("defaultNodeProperties.115"), 1);
                        Tabs.this.cbArgumentStrokeThickness.setSelectedItem(Float.valueOf(Tabs.this.getArgumentStrokeThickness()));
                    }
                }
            });
            this.chbArgumentGradient.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Tabs.this.chbArgumentGradient.isSelected()) {
                        Tabs.this.btnArgumentSecondary.setEnabled(true);
                    } else {
                        Tabs.this.btnArgumentSecondary.setEnabled(false);
                    }
                }
            });
            try {
                MaskFormatter mask0 = new MaskFormatter("##**");
                mask0.setValidCharacters("0123456789 ");
                this.tfArgumentWidth = new JFormattedTextField(mask0);
                this.tfArgumentWidth.setColumns(5);
                MaskFormatter mask1 = new MaskFormatter("##**");
                mask1.setValidCharacters("0123456789 ");
                this.tfArgumentHeight = new JFormattedTextField(mask1);
                this.tfArgumentHeight.setColumns(5);
            }
            catch (ParseException mask0) {
                // empty catch block
            }
            GridBagConstraints c00 = new GridBagConstraints();
            c00.gridx = 0;
            c00.gridy = 0;
            c00.anchor = 13;
            c00.insets = new Insets(20, 20, 0, 0);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.gridx = 1;
            c10.gridy = 0;
            c10.weightx = 1.0;
            c10.anchor = 17;
            c10.insets = new Insets(20, 20, 0, 20);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.gridx = 0;
            c01.gridy = 1;
            c01.anchor = 13;
            c01.insets = new Insets(10, 20, 0, 0);
            GridBagConstraints c11 = new GridBagConstraints();
            c11.gridx = 1;
            c11.gridy = 1;
            c11.weightx = 1.0;
            c11.anchor = 17;
            c11.insets = new Insets(10, 17, 0, 20);
            GridBagConstraints c12 = new GridBagConstraints();
            c12.gridx = 1;
            c12.gridy = 2;
            c12.weightx = 1.0;
            c12.anchor = 17;
            c12.insets = new Insets(10, 20, 0, 20);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.gridx = 0;
            c03.gridy = 3;
            c03.anchor = 13;
            c03.insets = new Insets(10, 20, 20, 0);
            GridBagConstraints c13 = new GridBagConstraints();
            c13.gridx = 1;
            c13.gridy = 3;
            c13.weightx = 1.0;
            c13.anchor = 17;
            c13.insets = new Insets(10, 20, 20, 20);
            this.pArgument.add((Component)this.lblArgumentSize, c00);
            this.argumentSizeBox.add(this.lblArgumentWidth);
            this.argumentSizeBox.add(Box.createHorizontalStrut(10));
            this.argumentSizeBox.add(this.tfArgumentWidth);
            this.argumentSizeBox.add(Box.createHorizontalStrut(20));
            this.argumentSizeBox.add(this.lblArgumentHeight);
            this.argumentSizeBox.add(Box.createHorizontalStrut(10));
            this.argumentSizeBox.add(this.tfArgumentHeight);
            this.pArgument.add((Component)this.argumentSizeBox, c10);
            this.pArgument.add((Component)this.lblArgumentFill, c01);
            this.pArgument.add((Component)this.chbArgumentGradient, c11);
            this.argumentFillBox.add(this.btnArgumentPrimary);
            this.argumentFillBox.add(Box.createHorizontalStrut(20));
            this.argumentFillBox.add(this.btnArgumentSecondary);
            this.pArgument.add((Component)this.argumentFillBox, c12);
            this.pArgument.add((Component)this.lblArgumentStroke, c03);
            this.argumentStroke.add(this.btnArgumentStrokeColor);
            this.argumentStroke.add(Box.createHorizontalStrut(15));
            this.argumentStroke.add(this.lblArgumentThickness);
            this.argumentStroke.add(Box.createHorizontalStrut(15));
            this.argumentStroke.add(this.cbArgumentStrokeThickness);
            this.pArgument.add((Component)this.argumentStroke, c13);
        }

        public void initialiseAssumptionTab() {
            this.cbAssumptionStrokeThickness.setPreferredSize(new Dimension(50, 20));
            this.cbAssumptionStrokeThickness.setEditable(true);
            this.btnAssumptionSecondary.setEnabled(false);
            this.btnAssumptionStrokeColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getAssumptionStrokeColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setAssumptionStrokeColor(cw.getColor());
                    }
                }
            });
            this.btnAssumptionPrimary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getAssumptionPrimaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setAssumptionPrimaryColor(cw.getColor());
                    }
                }
            });
            this.btnAssumptionSecondary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getAssumptionSecondaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setAssumptionSecondaryColor(cw.getColor());
                    }
                }
            });
            this.cbAssumptionStrokeThickness.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        Tabs.this.setAssumptionStrokeThickness(Float.parseFloat(Tabs.this.cbAssumptionStrokeThickness.getSelectedItem().toString()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("defaultNodeProperties.116"), Messages.getString("defaultNodeProperties.117"), 1);
                        Tabs.this.cbAssumptionStrokeThickness.setSelectedItem(Float.valueOf(Tabs.this.getAssumptionStrokeThickness()));
                    }
                }
            });
            this.chbAssumptionGradient.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Tabs.this.chbAssumptionGradient.isSelected()) {
                        Tabs.this.btnAssumptionSecondary.setEnabled(true);
                    } else {
                        Tabs.this.btnAssumptionSecondary.setEnabled(false);
                    }
                }
            });
            try {
                MaskFormatter mask0 = new MaskFormatter("##**");
                mask0.setValidCharacters("0123456789 ");
                this.tfAssumptionWidth = new JFormattedTextField(mask0);
                this.tfAssumptionWidth.setColumns(5);
                MaskFormatter mask1 = new MaskFormatter("##**");
                mask1.setValidCharacters("0123456789 ");
                this.tfAssumptionHeight = new JFormattedTextField(mask1);
                this.tfAssumptionHeight.setColumns(5);
            }
            catch (ParseException mask0) {
                // empty catch block
            }
            GridBagConstraints c00 = new GridBagConstraints();
            c00.gridx = 0;
            c00.gridy = 0;
            c00.anchor = 13;
            c00.insets = new Insets(20, 20, 0, 0);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.gridx = 1;
            c10.gridy = 0;
            c10.weightx = 1.0;
            c10.anchor = 17;
            c10.insets = new Insets(20, 20, 0, 20);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.gridx = 0;
            c01.gridy = 1;
            c01.anchor = 13;
            c01.insets = new Insets(10, 20, 0, 0);
            GridBagConstraints c11 = new GridBagConstraints();
            c11.gridx = 1;
            c11.gridy = 1;
            c11.weightx = 1.0;
            c11.anchor = 17;
            c11.insets = new Insets(10, 17, 0, 20);
            GridBagConstraints c12 = new GridBagConstraints();
            c12.gridx = 1;
            c12.gridy = 2;
            c12.weightx = 1.0;
            c12.anchor = 17;
            c12.insets = new Insets(10, 20, 0, 20);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.gridx = 0;
            c03.gridy = 3;
            c03.anchor = 13;
            c03.insets = new Insets(10, 20, 20, 0);
            GridBagConstraints c13 = new GridBagConstraints();
            c13.gridx = 1;
            c13.gridy = 3;
            c13.weightx = 1.0;
            c13.anchor = 17;
            c13.insets = new Insets(10, 20, 20, 20);
            this.pAssumption.add((Component)this.lblAssumptionSize, c00);
            this.assumptionSizeBox.add(this.lblAssumptionWidth);
            this.assumptionSizeBox.add(Box.createHorizontalStrut(10));
            this.assumptionSizeBox.add(this.tfAssumptionWidth);
            this.assumptionSizeBox.add(Box.createHorizontalStrut(20));
            this.assumptionSizeBox.add(this.lblAssumptionHeight);
            this.assumptionSizeBox.add(Box.createHorizontalStrut(10));
            this.assumptionSizeBox.add(this.tfAssumptionHeight);
            this.pAssumption.add((Component)this.assumptionSizeBox, c10);
            this.pAssumption.add((Component)this.lblAssumptionFill, c01);
            this.pAssumption.add((Component)this.chbAssumptionGradient, c11);
            this.assumptionFillBox.add(this.btnAssumptionPrimary);
            this.assumptionFillBox.add(Box.createHorizontalStrut(20));
            this.assumptionFillBox.add(this.btnAssumptionSecondary);
            this.pAssumption.add((Component)this.assumptionFillBox, c12);
            this.pAssumption.add((Component)this.lblAssumptionStroke, c03);
            this.assumptionStroke.add(this.btnAssumptionStrokeColor);
            this.assumptionStroke.add(Box.createHorizontalStrut(15));
            this.assumptionStroke.add(this.lblAssumptionThickness);
            this.assumptionStroke.add(Box.createHorizontalStrut(15));
            this.assumptionStroke.add(this.cbAssumptionStrokeThickness);
            this.pAssumption.add((Component)this.assumptionStroke, c13);
        }

        public void initialiseDecisionTab() {
            this.cbDecisionStrokeThickness.setPreferredSize(new Dimension(50, 20));
            this.cbDecisionStrokeThickness.setEditable(true);
            this.btnDecisionSecondary.setEnabled(false);
            this.btnDecisionStrokeColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getDecisionStrokeColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setDecisionStrokeColor(cw.getColor());
                    }
                }
            });
            this.btnDecisionPrimary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getDecisionPrimaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setDecisionPrimaryColor(cw.getColor());
                    }
                }
            });
            this.btnDecisionSecondary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getDecisionSecondaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setDecisionSecondaryColor(cw.getColor());
                    }
                }
            });
            this.cbDecisionStrokeThickness.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        Tabs.this.setDecisionStrokeThickness(Float.parseFloat(Tabs.this.cbDecisionStrokeThickness.getSelectedItem().toString()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("defaultNodeProperties.118"), Messages.getString("defaultNodeProperties.119"), 1);
                        Tabs.this.cbDecisionStrokeThickness.setSelectedItem(Float.valueOf(Tabs.this.getDecisionStrokeThickness()));
                    }
                }
            });
            this.chbDecisionGradient.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Tabs.this.chbDecisionGradient.isSelected()) {
                        Tabs.this.btnDecisionSecondary.setEnabled(true);
                    } else {
                        Tabs.this.btnDecisionSecondary.setEnabled(false);
                    }
                }
            });
            try {
                MaskFormatter mask0 = new MaskFormatter("##**");
                mask0.setValidCharacters("0123456789 ");
                this.tfDecisionWidth = new JFormattedTextField(mask0);
                this.tfDecisionWidth.setColumns(5);
                MaskFormatter mask1 = new MaskFormatter("##**");
                mask1.setValidCharacters("0123456789 ");
                this.tfDecisionHeight = new JFormattedTextField(mask1);
                this.tfDecisionHeight.setColumns(5);
            }
            catch (ParseException mask0) {
                // empty catch block
            }
            GridBagConstraints c00 = new GridBagConstraints();
            c00.gridx = 0;
            c00.gridy = 0;
            c00.anchor = 13;
            c00.insets = new Insets(20, 20, 0, 0);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.gridx = 1;
            c10.gridy = 0;
            c10.weightx = 1.0;
            c10.anchor = 17;
            c10.insets = new Insets(20, 20, 0, 20);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.gridx = 0;
            c01.gridy = 1;
            c01.anchor = 13;
            c01.insets = new Insets(10, 20, 0, 0);
            GridBagConstraints c11 = new GridBagConstraints();
            c11.gridx = 1;
            c11.gridy = 1;
            c11.weightx = 1.0;
            c11.anchor = 17;
            c11.insets = new Insets(10, 17, 0, 20);
            GridBagConstraints c12 = new GridBagConstraints();
            c12.gridx = 1;
            c12.gridy = 2;
            c12.weightx = 1.0;
            c12.anchor = 17;
            c12.insets = new Insets(10, 20, 0, 20);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.gridx = 0;
            c03.gridy = 3;
            c03.anchor = 13;
            c03.insets = new Insets(10, 20, 20, 0);
            GridBagConstraints c13 = new GridBagConstraints();
            c13.gridx = 1;
            c13.gridy = 3;
            c13.weightx = 1.0;
            c13.anchor = 17;
            c13.insets = new Insets(10, 20, 20, 20);
            this.pDecision.add((Component)this.lblDecisionSize, c00);
            this.decisionSizeBox.add(this.lblDecisionWidth);
            this.decisionSizeBox.add(Box.createHorizontalStrut(10));
            this.decisionSizeBox.add(this.tfDecisionWidth);
            this.decisionSizeBox.add(Box.createHorizontalStrut(20));
            this.decisionSizeBox.add(this.lblDecisionHeight);
            this.decisionSizeBox.add(Box.createHorizontalStrut(10));
            this.decisionSizeBox.add(this.tfDecisionHeight);
            this.pDecision.add((Component)this.decisionSizeBox, c10);
            this.pDecision.add((Component)this.lblDecisionFill, c01);
            this.pDecision.add((Component)this.chbDecisionGradient, c11);
            this.decisionFillBox.add(this.btnDecisionPrimary);
            this.decisionFillBox.add(Box.createHorizontalStrut(20));
            this.decisionFillBox.add(this.btnDecisionSecondary);
            this.pDecision.add((Component)this.decisionFillBox, c12);
            this.pDecision.add((Component)this.lblDecisionStroke, c03);
            this.decisionStroke.add(this.btnDecisionStrokeColor);
            this.decisionStroke.add(Box.createHorizontalStrut(15));
            this.decisionStroke.add(this.lblDecisionThickness);
            this.decisionStroke.add(Box.createHorizontalStrut(15));
            this.decisionStroke.add(this.cbDecisionStrokeThickness);
            this.pDecision.add((Component)this.decisionStroke, c13);
        }

        public void initialisePositionTab() {
            this.cbPositionStrokeThickness.setPreferredSize(new Dimension(50, 20));
            this.cbPositionStrokeThickness.setEditable(true);
            this.btnPositionSecondary.setEnabled(false);
            this.btnPositionStrokeColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getPositionStrokeColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setPositionStrokeColor(cw.getColor());
                    }
                }
            });
            this.btnPositionPrimary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getPositionPrimaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setPositionPrimaryColor(cw.getColor());
                    }
                }
            });
            this.btnPositionSecondary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getPositionSecondaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setPositionSecondaryColor(cw.getColor());
                    }
                }
            });
            this.cbPositionStrokeThickness.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        Tabs.this.setPositionStrokeThickness(Float.parseFloat(Tabs.this.cbPositionStrokeThickness.getSelectedItem().toString()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("defaultNodeProperties.120"), Messages.getString("defaultNodeProperties.121"), 1);
                        Tabs.this.cbPositionStrokeThickness.setSelectedItem(Float.valueOf(Tabs.this.getPositionStrokeThickness()));
                    }
                }
            });
            this.chbPositionGradient.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Tabs.this.chbPositionGradient.isSelected()) {
                        Tabs.this.btnPositionSecondary.setEnabled(true);
                    } else {
                        Tabs.this.btnPositionSecondary.setEnabled(false);
                    }
                }
            });
            try {
                MaskFormatter mask0 = new MaskFormatter("##**");
                mask0.setValidCharacters("0123456789 ");
                this.tfPositionWidth = new JFormattedTextField(mask0);
                this.tfPositionWidth.setColumns(5);
                MaskFormatter mask1 = new MaskFormatter("##**");
                mask1.setValidCharacters("0123456789 ");
                this.tfPositionHeight = new JFormattedTextField(mask1);
                this.tfPositionHeight.setColumns(5);
            }
            catch (ParseException mask0) {
                // empty catch block
            }
            GridBagConstraints c00 = new GridBagConstraints();
            c00.gridx = 0;
            c00.gridy = 0;
            c00.anchor = 13;
            c00.insets = new Insets(20, 20, 0, 0);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.gridx = 1;
            c10.gridy = 0;
            c10.weightx = 1.0;
            c10.anchor = 17;
            c10.insets = new Insets(20, 20, 0, 20);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.gridx = 0;
            c01.gridy = 1;
            c01.anchor = 13;
            c01.insets = new Insets(10, 20, 0, 0);
            GridBagConstraints c11 = new GridBagConstraints();
            c11.gridx = 1;
            c11.gridy = 1;
            c11.weightx = 1.0;
            c11.anchor = 17;
            c11.insets = new Insets(10, 17, 0, 20);
            GridBagConstraints c12 = new GridBagConstraints();
            c12.gridx = 1;
            c12.gridy = 2;
            c12.weightx = 1.0;
            c12.anchor = 17;
            c12.insets = new Insets(10, 20, 0, 20);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.gridx = 0;
            c03.gridy = 3;
            c03.anchor = 13;
            c03.insets = new Insets(10, 20, 20, 0);
            GridBagConstraints c13 = new GridBagConstraints();
            c13.gridx = 1;
            c13.gridy = 3;
            c13.weightx = 1.0;
            c13.anchor = 17;
            c13.insets = new Insets(10, 20, 20, 20);
            this.pPosition.add((Component)this.lblPositionSize, c00);
            this.positionSizeBox.add(this.lblPositionWidth);
            this.positionSizeBox.add(Box.createHorizontalStrut(10));
            this.positionSizeBox.add(this.tfPositionWidth);
            this.positionSizeBox.add(Box.createHorizontalStrut(20));
            this.positionSizeBox.add(this.lblPositionHeight);
            this.positionSizeBox.add(Box.createHorizontalStrut(10));
            this.positionSizeBox.add(this.tfPositionHeight);
            this.pPosition.add((Component)this.positionSizeBox, c10);
            this.pPosition.add((Component)this.lblPositionFill, c01);
            this.pPosition.add((Component)this.chbPositionGradient, c11);
            this.positionFillBox.add(this.btnPositionPrimary);
            this.positionFillBox.add(Box.createHorizontalStrut(20));
            this.positionFillBox.add(this.btnPositionSecondary);
            this.pPosition.add((Component)this.positionFillBox, c12);
            this.pPosition.add((Component)this.lblPositionStroke, c03);
            this.positionStroke.add(this.btnPositionStrokeColor);
            this.positionStroke.add(Box.createHorizontalStrut(15));
            this.positionStroke.add(this.lblPositionThickness);
            this.positionStroke.add(Box.createHorizontalStrut(15));
            this.positionStroke.add(this.cbPositionStrokeThickness);
            this.pPosition.add((Component)this.positionStroke, c13);
        }

        public void initialiseRequirementTab() {
            this.cbRequirementStrokeThickness.setPreferredSize(new Dimension(50, 20));
            this.cbRequirementStrokeThickness.setEditable(true);
            this.btnRequirementSecondary.setEnabled(false);
            this.btnRequirementStrokeColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getRequirementStrokeColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setRequirementStrokeColor(cw.getColor());
                    }
                }
            });
            this.btnRequirementPrimary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getRequirementPrimaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setRequirementPrimaryColor(cw.getColor());
                    }
                }
            });
            this.btnRequirementSecondary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getRequirementSecondaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setRequirementSecondaryColor(cw.getColor());
                    }
                }
            });
            this.cbRequirementStrokeThickness.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        Tabs.this.setRequirementStrokeThickness(Float.parseFloat(Tabs.this.cbRequirementStrokeThickness.getSelectedItem().toString()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("defaultNodeProperties.122"), Messages.getString("defaultNodeProperties.123"), 1);
                        Tabs.this.cbRequirementStrokeThickness.setSelectedItem(Float.valueOf(Tabs.this.getRequirementStrokeThickness()));
                    }
                }
            });
            this.chbRequirementGradient.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Tabs.this.chbRequirementGradient.isSelected()) {
                        Tabs.this.btnRequirementSecondary.setEnabled(true);
                    } else {
                        Tabs.this.btnRequirementSecondary.setEnabled(false);
                    }
                }
            });
            try {
                MaskFormatter mask0 = new MaskFormatter("##**");
                mask0.setValidCharacters("0123456789 ");
                this.tfRequirementWidth = new JFormattedTextField(mask0);
                this.tfRequirementWidth.setColumns(5);
                MaskFormatter mask1 = new MaskFormatter("##**");
                mask1.setValidCharacters("0123456789 ");
                this.tfRequirementHeight = new JFormattedTextField(mask1);
                this.tfRequirementHeight.setColumns(5);
            }
            catch (ParseException mask0) {
                // empty catch block
            }
            GridBagConstraints c00 = new GridBagConstraints();
            c00.gridx = 0;
            c00.gridy = 0;
            c00.anchor = 13;
            c00.insets = new Insets(20, 20, 0, 0);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.gridx = 1;
            c10.gridy = 0;
            c10.weightx = 1.0;
            c10.anchor = 17;
            c10.insets = new Insets(20, 20, 0, 20);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.gridx = 0;
            c01.gridy = 1;
            c01.anchor = 13;
            c01.insets = new Insets(10, 20, 0, 0);
            GridBagConstraints c11 = new GridBagConstraints();
            c11.gridx = 1;
            c11.gridy = 1;
            c11.weightx = 1.0;
            c11.anchor = 17;
            c11.insets = new Insets(10, 17, 0, 20);
            GridBagConstraints c12 = new GridBagConstraints();
            c12.gridx = 1;
            c12.gridy = 2;
            c12.weightx = 1.0;
            c12.anchor = 17;
            c12.insets = new Insets(10, 20, 0, 20);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.gridx = 0;
            c03.gridy = 3;
            c03.anchor = 13;
            c03.insets = new Insets(10, 20, 20, 0);
            GridBagConstraints c13 = new GridBagConstraints();
            c13.gridx = 1;
            c13.gridy = 3;
            c13.weightx = 1.0;
            c13.anchor = 17;
            c13.insets = new Insets(10, 20, 20, 20);
            this.pRequirement.add((Component)this.lblRequirementSize, c00);
            this.requirementSizeBox.add(this.lblRequirementWidth);
            this.requirementSizeBox.add(Box.createHorizontalStrut(10));
            this.requirementSizeBox.add(this.tfRequirementWidth);
            this.requirementSizeBox.add(Box.createHorizontalStrut(20));
            this.requirementSizeBox.add(this.lblRequirementHeight);
            this.requirementSizeBox.add(Box.createHorizontalStrut(10));
            this.requirementSizeBox.add(this.tfRequirementHeight);
            this.pRequirement.add((Component)this.requirementSizeBox, c10);
            this.pRequirement.add((Component)this.lblRequirementFill, c01);
            this.pRequirement.add((Component)this.chbRequirementGradient, c11);
            this.requirementFillBox.add(this.btnRequirementPrimary);
            this.requirementFillBox.add(Box.createHorizontalStrut(20));
            this.requirementFillBox.add(this.btnRequirementSecondary);
            this.pRequirement.add((Component)this.requirementFillBox, c12);
            this.pRequirement.add((Component)this.lblRequirementStroke, c03);
            this.requirementStroke.add(this.btnRequirementStrokeColor);
            this.requirementStroke.add(Box.createHorizontalStrut(15));
            this.requirementStroke.add(this.lblRequirementThickness);
            this.requirementStroke.add(Box.createHorizontalStrut(15));
            this.requirementStroke.add(this.cbRequirementStrokeThickness);
            this.pRequirement.add((Component)this.requirementStroke, c13);
        }

        public void initialiseStakeholderTab() {
            this.cbStakeholderStrokeThickness.setPreferredSize(new Dimension(50, 20));
            this.cbStakeholderStrokeThickness.setEditable(true);
            this.btnStakeholderSecondary.setEnabled(false);
            this.btnStakeholderStrokeColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getStakeholderStrokeColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setStakeholderStrokeColor(cw.getColor());
                    }
                }
            });
            this.btnStakeholderPrimary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getStakeholderPrimaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setStakeholderPrimaryColor(cw.getColor());
                    }
                }
            });
            this.btnStakeholderSecondary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getStakeholderSecondaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setStakeholderSecondaryColor(cw.getColor());
                    }
                }
            });
            this.cbStakeholderStrokeThickness.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        Tabs.this.setStakeholderStrokeThickness(Float.parseFloat(Tabs.this.cbStakeholderStrokeThickness.getSelectedItem().toString()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("defaultNodeProperties.124"), Messages.getString("defaultNodeProperties.125"), 1);
                        Tabs.this.cbStakeholderStrokeThickness.setSelectedItem(Float.valueOf(Tabs.this.getStakeholderStrokeThickness()));
                    }
                }
            });
            this.chbStakeholderGradient.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Tabs.this.chbStakeholderGradient.isSelected()) {
                        Tabs.this.btnStakeholderSecondary.setEnabled(true);
                    } else {
                        Tabs.this.btnStakeholderSecondary.setEnabled(false);
                    }
                }
            });
            try {
                MaskFormatter mask0 = new MaskFormatter("##**");
                mask0.setValidCharacters("0123456789 ");
                this.tfStakeholderWidth = new JFormattedTextField(mask0);
                this.tfStakeholderWidth.setColumns(5);
                MaskFormatter mask1 = new MaskFormatter("##**");
                mask1.setValidCharacters("0123456789 ");
                this.tfStakeholderHeight = new JFormattedTextField(mask1);
                this.tfStakeholderHeight.setColumns(5);
            }
            catch (ParseException mask0) {
                // empty catch block
            }
            GridBagConstraints c00 = new GridBagConstraints();
            c00.gridx = 0;
            c00.gridy = 0;
            c00.anchor = 13;
            c00.insets = new Insets(20, 20, 0, 0);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.gridx = 1;
            c10.gridy = 0;
            c10.weightx = 1.0;
            c10.anchor = 17;
            c10.insets = new Insets(20, 20, 0, 20);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.gridx = 0;
            c01.gridy = 1;
            c01.anchor = 13;
            c01.insets = new Insets(10, 20, 0, 0);
            GridBagConstraints c11 = new GridBagConstraints();
            c11.gridx = 1;
            c11.gridy = 1;
            c11.weightx = 1.0;
            c11.anchor = 17;
            c11.insets = new Insets(10, 17, 0, 20);
            GridBagConstraints c12 = new GridBagConstraints();
            c12.gridx = 1;
            c12.gridy = 2;
            c12.weightx = 1.0;
            c12.anchor = 17;
            c12.insets = new Insets(10, 20, 0, 20);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.gridx = 0;
            c03.gridy = 3;
            c03.anchor = 13;
            c03.insets = new Insets(10, 20, 20, 0);
            GridBagConstraints c13 = new GridBagConstraints();
            c13.gridx = 1;
            c13.gridy = 3;
            c13.weightx = 1.0;
            c13.anchor = 17;
            c13.insets = new Insets(10, 20, 20, 20);
            this.pStakeholder.add((Component)this.lblStakeholderSize, c00);
            this.stakeholderSizeBox.add(this.lblStakeholderWidth);
            this.stakeholderSizeBox.add(Box.createHorizontalStrut(10));
            this.stakeholderSizeBox.add(this.tfStakeholderWidth);
            this.stakeholderSizeBox.add(Box.createHorizontalStrut(20));
            this.stakeholderSizeBox.add(this.lblStakeholderHeight);
            this.stakeholderSizeBox.add(Box.createHorizontalStrut(10));
            this.stakeholderSizeBox.add(this.tfStakeholderHeight);
            this.pStakeholder.add((Component)this.stakeholderSizeBox, c10);
            this.pStakeholder.add((Component)this.lblStakeholderFill, c01);
            this.pStakeholder.add((Component)this.chbStakeholderGradient, c11);
            this.stakeholderFillBox.add(this.btnStakeholderPrimary);
            this.stakeholderFillBox.add(Box.createHorizontalStrut(20));
            this.stakeholderFillBox.add(this.btnStakeholderSecondary);
            this.pStakeholder.add((Component)this.stakeholderFillBox, c12);
            this.pStakeholder.add((Component)this.lblStakeholderStroke, c03);
            this.stakeholderStroke.add(this.btnStakeholderStrokeColor);
            this.stakeholderStroke.add(Box.createHorizontalStrut(15));
            this.stakeholderStroke.add(this.lblStakeholderThickness);
            this.stakeholderStroke.add(Box.createHorizontalStrut(15));
            this.stakeholderStroke.add(this.cbStakeholderStrokeThickness);
            this.pStakeholder.add((Component)this.stakeholderStroke, c13);
        }

        public void initialiseTopicTab() {
            this.cbTopicStrokeThickness.setPreferredSize(new Dimension(50, 20));
            this.cbTopicStrokeThickness.setEditable(true);
            this.btnTopicSecondary.setEnabled(false);
            this.btnTopicStrokeColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getTopicStrokeColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setTopicStrokeColor(cw.getColor());
                    }
                }
            });
            this.btnTopicPrimary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getTopicPrimaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setTopicPrimaryColor(cw.getColor());
                    }
                }
            });
            this.btnTopicSecondary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorWindow cw = Application.getInstance().getMainWindow().colorWindow;
                    cw.setColor(Tabs.this.getTopicSecondaryColor());
                    cw.setVisible(true);
                    if (cw.isDialogResult()) {
                        Tabs.this.setTopicSecondaryColor(cw.getColor());
                    }
                }
            });
            this.cbTopicStrokeThickness.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        Tabs.this.setTopicStrokeThickness(Float.parseFloat(Tabs.this.cbTopicStrokeThickness.getSelectedItem().toString()));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Application.getInstance().getView(), Messages.getString("defaultNodeProperties.126"), Messages.getString("defaultNodeProperties.127"), 1);
                        Tabs.this.cbTopicStrokeThickness.setSelectedItem(Float.valueOf(Tabs.this.getTopicStrokeThickness()));
                    }
                }
            });
            this.chbTopicGradient.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Tabs.this.chbTopicGradient.isSelected()) {
                        Tabs.this.btnTopicSecondary.setEnabled(true);
                    } else {
                        Tabs.this.btnTopicSecondary.setEnabled(false);
                    }
                }
            });
            try {
                MaskFormatter mask0 = new MaskFormatter("##**");
                mask0.setValidCharacters("0123456789 ");
                this.tfTopicWidth = new JFormattedTextField(mask0);
                this.tfTopicWidth.setColumns(5);
                MaskFormatter mask1 = new MaskFormatter("##**");
                mask1.setValidCharacters("0123456789 ");
                this.tfTopicHeight = new JFormattedTextField(mask1);
                this.tfTopicHeight.setColumns(5);
            }
            catch (ParseException mask0) {
                // empty catch block
            }
            GridBagConstraints c00 = new GridBagConstraints();
            c00.gridx = 0;
            c00.gridy = 0;
            c00.anchor = 13;
            c00.insets = new Insets(20, 20, 0, 0);
            GridBagConstraints c10 = new GridBagConstraints();
            c10.gridx = 1;
            c10.gridy = 0;
            c10.weightx = 1.0;
            c10.anchor = 17;
            c10.insets = new Insets(20, 20, 0, 20);
            GridBagConstraints c01 = new GridBagConstraints();
            c01.gridx = 0;
            c01.gridy = 1;
            c01.anchor = 13;
            c01.insets = new Insets(10, 20, 0, 0);
            GridBagConstraints c11 = new GridBagConstraints();
            c11.gridx = 1;
            c11.gridy = 1;
            c11.weightx = 1.0;
            c11.anchor = 17;
            c11.insets = new Insets(10, 17, 0, 20);
            GridBagConstraints c12 = new GridBagConstraints();
            c12.gridx = 1;
            c12.gridy = 2;
            c12.weightx = 1.0;
            c12.anchor = 17;
            c12.insets = new Insets(10, 20, 0, 20);
            GridBagConstraints c03 = new GridBagConstraints();
            c03.gridx = 0;
            c03.gridy = 3;
            c03.anchor = 13;
            c03.insets = new Insets(10, 20, 20, 0);
            GridBagConstraints c13 = new GridBagConstraints();
            c13.gridx = 1;
            c13.gridy = 3;
            c13.weightx = 1.0;
            c13.anchor = 17;
            c13.insets = new Insets(10, 20, 20, 20);
            this.pTopic.add((Component)this.lblTopicSize, c00);
            this.topicSizeBox.add(this.lblTopicWidth);
            this.topicSizeBox.add(Box.createHorizontalStrut(10));
            this.topicSizeBox.add(this.tfTopicWidth);
            this.topicSizeBox.add(Box.createHorizontalStrut(20));
            this.topicSizeBox.add(this.lblTopicHeight);
            this.topicSizeBox.add(Box.createHorizontalStrut(10));
            this.topicSizeBox.add(this.tfTopicHeight);
            this.pTopic.add((Component)this.topicSizeBox, c10);
            this.pTopic.add((Component)this.lblTopicFill, c01);
            this.pTopic.add((Component)this.chbTopicGradient, c11);
            this.topicFillBox.add(this.btnTopicPrimary);
            this.topicFillBox.add(Box.createHorizontalStrut(20));
            this.topicFillBox.add(this.btnTopicSecondary);
            this.pTopic.add((Component)this.topicFillBox, c12);
            this.pTopic.add((Component)this.lblTopicStroke, c03);
            this.topicStroke.add(this.btnTopicStrokeColor);
            this.topicStroke.add(Box.createHorizontalStrut(15));
            this.topicStroke.add(this.lblTopicThickness);
            this.topicStroke.add(Box.createHorizontalStrut(15));
            this.topicStroke.add(this.cbTopicStrokeThickness);
            this.pTopic.add((Component)this.topicStroke, c13);
        }

        public void fillAllFields() {
            this.setArgumentWidth("" + this.argumentSize.width);
            this.setArgumentHeight("" + this.argumentSize.height);
            boolean argumentGradient = false;
            if (!this.argumentPrimaryColor.equals(this.argumentSecondaryColor)) {
                argumentGradient = true;
                this.btnArgumentSecondary.setEnabled(true);
            }
            this.setArgumentGradient(argumentGradient);
            this.setCbArgumentStrokeThickness(this.argumentStrokeThickness);
            this.setAssumptionWidth("" + this.assumptionSize.width);
            this.setAssumptionHeight("" + this.assumptionSize.height);
            boolean assumptionGradient = false;
            if (!this.assumptionPrimaryColor.equals(this.assumptionSecondaryColor)) {
                assumptionGradient = true;
                this.btnAssumptionSecondary.setEnabled(true);
            }
            this.setAssumptionGradient(assumptionGradient);
            this.setCbAssumptionStrokeThickness(this.assumptionStrokeThickness);
            this.setDecisionWidth("" + this.decisionSize.width);
            this.setDecisionHeight("" + this.decisionSize.height);
            boolean decisionGradient = false;
            if (!this.decisionPrimaryColor.equals(this.decisionSecondaryColor)) {
                decisionGradient = true;
                this.btnDecisionSecondary.setEnabled(true);
            }
            this.setDecisionGradient(decisionGradient);
            this.setCbDecisionStrokeThickness(this.decisionStrokeThickness);
            this.setPositionWidth("" + this.positionSize.width);
            this.setPositionHeight("" + this.positionSize.height);
            boolean positionGradient = false;
            if (!this.positionPrimaryColor.equals(this.positionSecondaryColor)) {
                positionGradient = true;
                this.btnPositionSecondary.setEnabled(true);
            }
            this.setPositionGradient(positionGradient);
            this.setCbPositionStrokeThickness(this.positionStrokeThickness);
            this.setRequirementWidth("" + this.requirementSize.width);
            this.setRequirementHeight("" + this.requirementSize.height);
            boolean requirementGradient = false;
            if (!this.requirementPrimaryColor.equals(this.requirementSecondaryColor)) {
                requirementGradient = true;
                this.btnRequirementSecondary.setEnabled(true);
            }
            this.setRequirementGradient(requirementGradient);
            this.setCbRequirementStrokeThickness(this.requirementStrokeThickness);
            this.setStakeholderWidth("" + this.stakeholderSize.width);
            this.setStakeholderHeight("" + this.stakeholderSize.height);
            boolean stakeholderGradient = false;
            if (!this.stakeholderPrimaryColor.equals(this.stakeholderSecondaryColor)) {
                stakeholderGradient = true;
                this.btnStakeholderSecondary.setEnabled(true);
            }
            this.setStakeholderGradient(stakeholderGradient);
            this.setCbStakeholderStrokeThickness(this.stakeholderStrokeThickness);
            this.setTopicWidth("" + this.topicSize.width);
            this.setTopicHeight("" + this.topicSize.height);
            boolean topicGradient = false;
            if (!this.topicPrimaryColor.equals(this.topicSecondaryColor)) {
                topicGradient = true;
                this.btnTopicSecondary.setEnabled(true);
            }
            this.setTopicGradient(topicGradient);
            this.setCbTopicStrokeThickness(this.topicStrokeThickness);
        }

        public Color getArgumentStrokeColor() {
            return this.argumentStrokeColor;
        }

        public void setArgumentStrokeColor(Color argumentStrokeColor) {
            this.argumentStrokeColor = argumentStrokeColor;
        }

        public Color getArgumentPrimaryColor() {
            return this.argumentPrimaryColor;
        }

        public void setArgumentPrimaryColor(Color argumentPrimaryColor) {
            this.argumentPrimaryColor = argumentPrimaryColor;
        }

        public Color getArgumentSecondaryColor() {
            return this.argumentSecondaryColor;
        }

        public void setArgumentSecondaryColor(Color argumentSecondaryColor) {
            this.argumentSecondaryColor = argumentSecondaryColor;
        }

        public float getArgumentStrokeThickness() {
            return this.argumentStrokeThickness;
        }

        public void setArgumentStrokeThickness(float argumentStrokeThickness) {
            this.argumentStrokeThickness = argumentStrokeThickness;
        }

        public Dimension getArgumentSize() {
            return this.argumentSize;
        }

        public void setArgumentSize(Dimension argumentSize) {
            this.argumentSize = argumentSize;
        }

        public Color getAssumptionStrokeColor() {
            return this.assumptionStrokeColor;
        }

        public void setAssumptionStrokeColor(Color assumptionStrokeColor) {
            this.assumptionStrokeColor = assumptionStrokeColor;
        }

        public Color getAssumptionPrimaryColor() {
            return this.assumptionPrimaryColor;
        }

        public void setAssumptionPrimaryColor(Color assumptionPrimaryColor) {
            this.assumptionPrimaryColor = assumptionPrimaryColor;
        }

        public Color getAssumptionSecondaryColor() {
            return this.assumptionSecondaryColor;
        }

        public void setAssumptionSecondaryColor(Color assumptionSecondaryColor) {
            this.assumptionSecondaryColor = assumptionSecondaryColor;
        }

        public float getAssumptionStrokeThickness() {
            return this.assumptionStrokeThickness;
        }

        public void setAssumptionStrokeThickness(float assumptionStrokeThickness) {
            this.assumptionStrokeThickness = assumptionStrokeThickness;
        }

        public Dimension getAssumptionSize() {
            return this.assumptionSize;
        }

        public void setAssumptionSize(Dimension assumptionSize) {
            this.assumptionSize = assumptionSize;
        }

        public Color getDecisionStrokeColor() {
            return this.decisionStrokeColor;
        }

        public void setDecisionStrokeColor(Color decisionStrokeColor) {
            this.decisionStrokeColor = decisionStrokeColor;
        }

        public Color getDecisionPrimaryColor() {
            return this.decisionPrimaryColor;
        }

        public void setDecisionPrimaryColor(Color decisionPrimaryColor) {
            this.decisionPrimaryColor = decisionPrimaryColor;
        }

        public Color getDecisionSecondaryColor() {
            return this.decisionSecondaryColor;
        }

        public void setDecisionSecondaryColor(Color decisionSecondaryColor) {
            this.decisionSecondaryColor = decisionSecondaryColor;
        }

        public float getDecisionStrokeThickness() {
            return this.decisionStrokeThickness;
        }

        public void setDecisionStrokeThickness(float decisionStrokeThickness) {
            this.decisionStrokeThickness = decisionStrokeThickness;
        }

        public Dimension getDecisionSize() {
            return this.decisionSize;
        }

        public void setDecisionSize(Dimension decisionSize) {
            this.decisionSize = decisionSize;
        }

        public Color getPositionStrokeColor() {
            return this.positionStrokeColor;
        }

        public void setPositionStrokeColor(Color positionStrokeColor) {
            this.positionStrokeColor = positionStrokeColor;
        }

        public Color getPositionPrimaryColor() {
            return this.positionPrimaryColor;
        }

        public void setPositionPrimaryColor(Color positionPrimaryColor) {
            this.positionPrimaryColor = positionPrimaryColor;
        }

        public Color getPositionSecondaryColor() {
            return this.positionSecondaryColor;
        }

        public void setPositionSecondaryColor(Color positionSecondaryColor) {
            this.positionSecondaryColor = positionSecondaryColor;
        }

        public float getPositionStrokeThickness() {
            return this.positionStrokeThickness;
        }

        public void setPositionStrokeThickness(float positionStrokeThickness) {
            this.positionStrokeThickness = positionStrokeThickness;
        }

        public Dimension getPositionSize() {
            return this.positionSize;
        }

        public void setPositionSize(Dimension positionSize) {
            this.positionSize = positionSize;
        }

        public Color getRequirementStrokeColor() {
            return this.requirementStrokeColor;
        }

        public void setRequirementStrokeColor(Color requirementStrokeColor) {
            this.requirementStrokeColor = requirementStrokeColor;
        }

        public Color getRequirementPrimaryColor() {
            return this.requirementPrimaryColor;
        }

        public void setRequirementPrimaryColor(Color requirementPrimaryColor) {
            this.requirementPrimaryColor = requirementPrimaryColor;
        }

        public Color getRequirementSecondaryColor() {
            return this.requirementSecondaryColor;
        }

        public void setRequirementSecondaryColor(Color requirementSecondaryColor) {
            this.requirementSecondaryColor = requirementSecondaryColor;
        }

        public float getRequirementStrokeThickness() {
            return this.requirementStrokeThickness;
        }

        public void setRequirementStrokeThickness(float requirementStrokeThickness) {
            this.requirementStrokeThickness = requirementStrokeThickness;
        }

        public Dimension getRequirementSize() {
            return this.requirementSize;
        }

        public void setRequirementSize(Dimension requirementSize) {
            this.requirementSize = requirementSize;
        }

        public Color getStakeholderStrokeColor() {
            return this.stakeholderStrokeColor;
        }

        public void setStakeholderStrokeColor(Color stakeholderStrokeColor) {
            this.stakeholderStrokeColor = stakeholderStrokeColor;
        }

        public Color getStakeholderPrimaryColor() {
            return this.stakeholderPrimaryColor;
        }

        public void setStakeholderPrimaryColor(Color stakeholderPrimaryColor) {
            this.stakeholderPrimaryColor = stakeholderPrimaryColor;
        }

        public Color getStakeholderSecondaryColor() {
            return this.stakeholderSecondaryColor;
        }

        public void setStakeholderSecondaryColor(Color stakeholderSecondaryColor) {
            this.stakeholderSecondaryColor = stakeholderSecondaryColor;
        }

        public float getStakeholderStrokeThickness() {
            return this.stakeholderStrokeThickness;
        }

        public void setStakeholderStrokeThickness(float stakeholderStrokeThickness) {
            this.stakeholderStrokeThickness = stakeholderStrokeThickness;
        }

        public Dimension getStakeholderSize() {
            return this.stakeholderSize;
        }

        public void setStakeholderSize(Dimension stakeholderSize) {
            this.stakeholderSize = stakeholderSize;
        }

        public Color getTopicStrokeColor() {
            return this.topicStrokeColor;
        }

        public void setTopicStrokeColor(Color topicStrokeColor) {
            this.topicStrokeColor = topicStrokeColor;
        }

        public Color getTopicPrimaryColor() {
            return this.topicPrimaryColor;
        }

        public void setTopicPrimaryColor(Color topicPrimaryColor) {
            this.topicPrimaryColor = topicPrimaryColor;
        }

        public Color getTopicSecondaryColor() {
            return this.topicSecondaryColor;
        }

        public void setTopicSecondaryColor(Color topicSecondaryColor) {
            this.topicSecondaryColor = topicSecondaryColor;
        }

        public float getTopicStrokeThickness() {
            return this.topicStrokeThickness;
        }

        public void setTopicStrokeThickness(float topicStrokeThickness) {
            this.topicStrokeThickness = topicStrokeThickness;
        }

        public Dimension getTopicSize() {
            return this.topicSize;
        }

        public void setTopicSize(Dimension topicSize) {
            this.topicSize = topicSize;
        }

        public String getArgumentWidth() {
            return this.tfArgumentWidth.getText();
        }

        public void setArgumentWidth(String argumentWidth) {
            this.tfArgumentWidth.setText(argumentWidth);
        }

        public String getArgumentHeight() {
            return this.tfArgumentHeight.getText();
        }

        public void setArgumentHeight(String argumentHeight) {
            this.tfArgumentHeight.setText(argumentHeight);
        }

        public boolean isArgumentGradient() {
            return this.chbArgumentGradient.isSelected();
        }

        public void setArgumentGradient(boolean argumentGradient) {
            this.chbArgumentGradient.setSelected(argumentGradient);
        }

        public float getCbArgumentStrokeThickness() {
            return Float.parseFloat(this.cbArgumentStrokeThickness.getSelectedItem().toString());
        }

        public void setCbArgumentStrokeThickness(float cbArgumentStrokeThickness) {
            this.cbArgumentStrokeThickness.setSelectedItem(Float.valueOf(cbArgumentStrokeThickness));
        }

        public String getAssumptionWidth() {
            return this.tfAssumptionWidth.getText();
        }

        public void setAssumptionWidth(String assumptionWidth) {
            this.tfAssumptionWidth.setText(assumptionWidth);
        }

        public String getAssumptionHeight() {
            return this.tfAssumptionHeight.getText();
        }

        public void setAssumptionHeight(String assumptionHeight) {
            this.tfAssumptionHeight.setText(assumptionHeight);
        }

        public boolean isAssumptionGradient() {
            return this.chbAssumptionGradient.isSelected();
        }

        public void setAssumptionGradient(boolean assumptionGradient) {
            this.chbAssumptionGradient.setSelected(assumptionGradient);
        }

        public float getCbAssumptionStrokeThickness() {
            return Float.parseFloat(this.cbAssumptionStrokeThickness.getSelectedItem().toString());
        }

        public void setCbAssumptionStrokeThickness(float cbAssumptionStrokeThickness) {
            this.cbAssumptionStrokeThickness.setSelectedItem(Float.valueOf(cbAssumptionStrokeThickness));
        }

        public String getDecisionWidth() {
            return this.tfDecisionWidth.getText();
        }

        public void setDecisionWidth(String decisionWidth) {
            this.tfDecisionWidth.setText(decisionWidth);
        }

        public String getDecisionHeight() {
            return this.tfDecisionHeight.getText();
        }

        public void setDecisionHeight(String decisionHeight) {
            this.tfDecisionHeight.setText(decisionHeight);
        }

        public boolean isDecisionGradient() {
            return this.chbDecisionGradient.isSelected();
        }

        public void setDecisionGradient(boolean decisionGradient) {
            this.chbDecisionGradient.setSelected(decisionGradient);
        }

        public float getCbDecisionStrokeThickness() {
            return Float.parseFloat(this.cbDecisionStrokeThickness.getSelectedItem().toString());
        }

        public void setCbDecisionStrokeThickness(float cbDecisionStrokeThickness) {
            this.cbDecisionStrokeThickness.setSelectedItem(Float.valueOf(cbDecisionStrokeThickness));
        }

        public String getPositionWidth() {
            return this.tfPositionWidth.getText();
        }

        public void setPositionWidth(String positionWidth) {
            this.tfPositionWidth.setText(positionWidth);
        }

        public String getPositionHeight() {
            return this.tfPositionHeight.getText();
        }

        public void setPositionHeight(String positionHeight) {
            this.tfPositionHeight.setText(positionHeight);
        }

        public boolean isPositionGradient() {
            return this.chbPositionGradient.isSelected();
        }

        public void setPositionGradient(boolean positionGradient) {
            this.chbPositionGradient.setSelected(positionGradient);
        }

        public float getCbPositionStrokeThickness() {
            return Float.parseFloat(this.cbPositionStrokeThickness.getSelectedItem().toString());
        }

        public void setCbPositionStrokeThickness(float cbPositionStrokeThickness) {
            this.cbPositionStrokeThickness.setSelectedItem(Float.valueOf(cbPositionStrokeThickness));
        }

        public String getRequirementWidth() {
            return this.tfRequirementWidth.getText();
        }

        public void setRequirementWidth(String requirementWidth) {
            this.tfRequirementWidth.setText(requirementWidth);
        }

        public String getRequirementHeight() {
            return this.tfRequirementHeight.getText();
        }

        public void setRequirementHeight(String requirementHeight) {
            this.tfRequirementHeight.setText(requirementHeight);
        }

        public boolean isRequirementGradient() {
            return this.chbRequirementGradient.isSelected();
        }

        public void setRequirementGradient(boolean requirementGradient) {
            this.chbRequirementGradient.setSelected(requirementGradient);
        }

        public float getCbRequirementStrokeThickness() {
            return Float.parseFloat(this.cbRequirementStrokeThickness.getSelectedItem().toString());
        }

        public void setCbRequirementStrokeThickness(float cbRequirementStrokeThickness) {
            this.cbRequirementStrokeThickness.setSelectedItem(Float.valueOf(cbRequirementStrokeThickness));
        }

        public String getStakeholderWidth() {
            return this.tfStakeholderWidth.getText();
        }

        public void setStakeholderWidth(String stakeholderWidth) {
            this.tfStakeholderWidth.setText(stakeholderWidth);
        }

        public String getStakeholderHeight() {
            return this.tfStakeholderHeight.getText();
        }

        public void setStakeholderHeight(String stakeholderHeight) {
            this.tfStakeholderHeight.setText(stakeholderHeight);
        }

        public boolean isStakeholderGradient() {
            return this.chbStakeholderGradient.isSelected();
        }

        public void setStakeholderGradient(boolean stakeholderGradient) {
            this.chbStakeholderGradient.setSelected(stakeholderGradient);
        }

        public float getCbStakeholderStrokeThickness() {
            return Float.parseFloat(this.cbStakeholderStrokeThickness.getSelectedItem().toString());
        }

        public void setCbStakeholderStrokeThickness(float cbStakeholderStrokeThickness) {
            this.cbStakeholderStrokeThickness.setSelectedItem(Float.valueOf(cbStakeholderStrokeThickness));
        }

        public String getTopicWidth() {
            return this.tfTopicWidth.getText();
        }

        public void setTopicWidth(String topicWidth) {
            this.tfTopicWidth.setText(topicWidth);
        }

        public String getTopicHeight() {
            return this.tfTopicHeight.getText();
        }

        public void setTopicHeight(String topicHeight) {
            this.tfTopicHeight.setText(topicHeight);
        }

        public boolean isTopicGradient() {
            return this.chbTopicGradient.isSelected();
        }

        public void setTopicGradient(boolean topicGradient) {
            this.chbTopicGradient.setSelected(topicGradient);
        }

        public float getCbTopicStrokeThickness() {
            return Float.parseFloat(this.cbTopicStrokeThickness.getSelectedItem().toString());
        }

        public void setCbTopicStrokeThickness(float cbTopicStrokeThickness) {
            this.cbTopicStrokeThickness.setSelectedItem(Float.valueOf(cbTopicStrokeThickness));
        }

        public void setNewDefaultSettings() {
            this.setArgumentSize(new Dimension(Integer.parseInt(this.getArgumentWidth().trim()), Integer.parseInt(this.getArgumentHeight().trim())));
            this.setArgumentStrokeThickness(this.getCbArgumentStrokeThickness());
            this.setDecisionSize(new Dimension(Integer.parseInt(this.getDecisionWidth().trim()), Integer.parseInt(this.getDecisionHeight().trim())));
            this.setDecisionStrokeThickness(this.getCbDecisionStrokeThickness());
            this.setAssumptionSize(new Dimension(Integer.parseInt(this.getAssumptionWidth().trim()), Integer.parseInt(this.getAssumptionHeight().trim())));
            this.setAssumptionStrokeThickness(this.getCbAssumptionStrokeThickness());
            this.setPositionSize(new Dimension(Integer.parseInt(this.getPositionWidth().trim()), Integer.parseInt(this.getPositionHeight().trim())));
            this.setPositionStrokeThickness(this.getCbPositionStrokeThickness());
            this.setRequirementSize(new Dimension(Integer.parseInt(this.getRequirementWidth().trim()), Integer.parseInt(this.getRequirementHeight().trim())));
            this.setRequirementStrokeThickness(this.getCbRequirementStrokeThickness());
            this.setStakeholderSize(new Dimension(Integer.parseInt(this.getStakeholderWidth().trim()), Integer.parseInt(this.getStakeholderHeight().trim())));
            this.setStakeholderStrokeThickness(this.getCbStakeholderStrokeThickness());
            this.setTopicSize(new Dimension(Integer.parseInt(this.getTopicWidth().trim()), Integer.parseInt(this.getTopicHeight().trim())));
            this.setTopicStrokeThickness(this.getCbTopicStrokeThickness());
        }
    }
}

