/*
 * Decompiled with CFR 0.152.
 */
package germ.gui.workspace;

import germ.app.Application;
import germ.gui.windows.PropertyWindow;
import germ.gui.workspace.CustomIconRenderer;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.event.UpdateEvent;
import germ.model.event.UpdateListener;
import germ.model.workspace.Project;
import germ.model.workspace.Workspace;
import germ.view.GERMView;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WorkspaceTree
extends JTree
implements UpdateListener,
TreeSelectionListener {
    DefaultTreeModel model = (DefaultTreeModel)this.getModel();
    MouseListener ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            GERMModel m;
            Object node;
            TreePath selPath = WorkspaceTree.this.getPathForLocation(e.getX(), e.getY());
            if (e.getClickCount() == 1) {
                if (e.getButton() == 1) {
                    if (selPath != null) {
                        node = selPath.getLastPathComponent();
                        WorkspaceTree.this.refreshStatusBar(node);
                        if (node instanceof Node) {
                            m = Application.getInstance().getModel();
                            GERMView v = Application.getInstance().getView();
                            if (m == selPath.getParentPath().getLastPathComponent()) {
                                if (e.isControlDown()) {
                                    if (!m.isNodeIsSelected((Node)node).booleanValue()) {
                                        m.selectNode((Node)node);
                                        v.centerNode((Node)node);
                                    } else {
                                        m.deselectNode((Node)node);
                                    }
                                } else {
                                    m.deselectAllNodes();
                                    m.selectNode((Node)node);
                                    v.centerNode((Node)node);
                                }
                                m.updatePerformed();
                            }
                        }
                        if (node instanceof GERMModel) {
                            m = (GERMModel)node;
                            int noNodes = m.getNodeCount();
                            Application.getInstance().getMainWindow().setStatusBarMessage(String.valueOf(Messages.getString("WorkspaceTree.0")) + noNodes, 0);
                            Application.getInstance().setModel(m);
                            m.updatePerformed();
                        }
                    }
                } else if (e.getButton() == 2) {
                    if (selPath != null && (node = selPath.getLastPathComponent()) instanceof Node && (m = Application.getInstance().getModel()) == selPath.getParentPath().getLastPathComponent()) {
                        m.deselectNode((Node)node);
                        m.removeNode((Node)node);
                        WorkspaceTree.this.updatePerformed(null);
                    }
                } else if (e.getButton() == 3 && selPath != null) {
                    JPopupMenu pop;
                    node = selPath.getLastPathComponent();
                    WorkspaceTree.this.refreshStatusBar(node);
                    WorkspaceTree.this.setSelectionPath(selPath);
                    if (node instanceof Node && (m = Application.getInstance().getModel()) == selPath.getParentPath().getLastPathComponent()) {
                        if (e.isControlDown()) {
                            if (!m.isNodeIsSelected((Node)node).booleanValue()) {
                                m.selectNode((Node)node);
                            } else {
                                m.deselectNode((Node)node);
                            }
                            m.updatePerformed();
                        } else {
                            m.deselectAllNodes();
                            m.updatePerformed();
                        }
                    }
                    if (node instanceof GERMModel) {
                        Application.getInstance().getMainWindow().addDiagram(((GERMModel)node).getView());
                    }
                    if (node instanceof Node) {
                        pop = Application.getInstance().getMainWindow().getTreePopNode();
                        if (Application.getInstance().getClipboard().isEmpty()) {
                            pop.getComponents()[2].setEnabled(false);
                        } else {
                            pop.getComponents()[2].setEnabled(true);
                        }
                        if ((GERMModel)selPath.getParentPath().getLastPathComponent() != Application.getInstance().getModel()) {
                            pop.getComponents()[0].setEnabled(false);
                            pop.getComponents()[1].setEnabled(false);
                            pop.getComponents()[4].setEnabled(false);
                        } else {
                            pop.getComponents()[0].setEnabled(true);
                            pop.getComponents()[1].setEnabled(true);
                            pop.getComponents()[4].setEnabled(true);
                        }
                        GERMModel model = (GERMModel)selPath.getParentPath().getLastPathComponent();
                        Node n = (Node)node;
                        Application.getInstance().getActionManager().getCenterNodeAction().setCenterData(model, n);
                        Application.getInstance().setModel(model);
                        model.selectNode(n);
                        pop.show(WorkspaceTree.this, e.getX(), e.getY());
                    }
                    if (node instanceof GERMModel) {
                        pop = Application.getInstance().getMainWindow().getTreePopDiagram();
                        Application.getInstance().getActionManager().getDeleteDiagramAction().setDiagram((GERMModel)node);
                        pop.show(WorkspaceTree.this, e.getX(), e.getY());
                    }
                    if (node instanceof Project) {
                        pop = Application.getInstance().getMainWindow().getTreePopProject();
                        Application.getInstance().getActionManager().getRenameProjectAction().setProject((Project)node);
                        Application.getInstance().getActionManager().getCreateNewDiagramAction().setProject((Project)node);
                        Application.getInstance().getActionManager().getExportACtion().setProjectToExport((Project)node);
                        Application.getInstance().getActionManager().getDeleteProjectAction().setProject((Project)node);
                        pop.show(WorkspaceTree.this, e.getX(), e.getY());
                    }
                    if (node instanceof Workspace) {
                        pop = Application.getInstance().getMainWindow().getTreePopWorkspace();
                        pop.show(WorkspaceTree.this, e.getX(), e.getY());
                    }
                }
            }
            if (e.getClickCount() == 2 && selPath != null) {
                node = selPath.getLastPathComponent();
                if (e.getButton() == 1 && node instanceof Node && (m = Application.getInstance().getModel()) == selPath.getParentPath().getLastPathComponent()) {
                    PropertyWindow pw = ((Node)node).getPropertyWindow();
                    pw.setVisible(true);
                    ((Node)node).setProperties(pw.isDialogResult());
                    m.updatePerformed();
                }
            }
        }
    };

    public WorkspaceTree() {
        this.addMouseListener(this.ml);
        this.setEditable(false);
        this.setCellRenderer(new CustomIconRenderer());
    }

    public void treeNodesInserted(TreeModelEvent arg0) {
    }

    public void treeNodesRemoved(TreeModelEvent arg0) {
    }

    public void treeStructureChanged(TreeModelEvent arg0) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        GERMModel m;
        Object node = e.getPath().getLastPathComponent();
        this.expandPath(e.getPath());
        if (node instanceof GERMModel) {
            m = (GERMModel)node;
            Application.getInstance().setModel(m);
            Application.getInstance().getView().repaint();
            m.updatePerformed();
        }
        if (node instanceof Node && (m = Application.getInstance().getModel()) == e.getPath().getParentPath().getLastPathComponent()) {
            m.deselectAllNodes();
            m.selectNode((Node)node);
            m.updatePerformed();
        }
    }

    public TreePath getPathForLocation(int x, int y) {
        return super.getPathForLocation(x, y);
    }

    public void updatePerformed(UpdateEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkspaceTree.this.updateUI();
            }
        });
    }

    public void updateUI() {
        super.updateUI();
    }

    public void refreshStatusBar(Object node) {
        if (node instanceof GERMModel) {
            GERMModel m = (GERMModel)node;
            int noNodes = m.getNodeCount();
            Application.getInstance().getMainWindow().setStatusBarMessage(String.valueOf(Messages.getString("WorkspaceTree.0")) + noNodes, 0);
            Application.getInstance().setModel(m);
            Application.getInstance().getView().repaint();
        } else if (node instanceof Project) {
            Project p = (Project)node;
            int noDiagrams = p.getDiagramCount();
            int noNodes = 0;
            int i = 0;
            while (i != p.getDiagramCount()) {
                noNodes += p.getDiagram(i).getNodeCount();
                ++i;
            }
            Application.getInstance().getMainWindow().setStatusBarMessage(String.valueOf(Messages.getString("WorkspaceTree.2")) + noDiagrams + Messages.getString("WorkspaceTree.3") + noNodes, 0);
        } else if (node instanceof Workspace) {
            Workspace w = (Workspace)node;
            int noNodes = 0;
            int noDiagrams = 0;
            int noProjects = w.getProjectsCount();
            int i = 0;
            while (i != noProjects) {
                noDiagrams += w.getProject(i).getDiagramCount();
                int j = 0;
                while (j != w.getProject(i).getDiagramCount()) {
                    noNodes += w.getProject(i).getDiagram(j).getNodeCount();
                    ++j;
                }
                ++i;
            }
            String message = String.valueOf(Messages.getString("WorkspaceTree.4")) + noProjects + Messages.getString("WorkspaceTree.5") + noDiagrams + Messages.getString("WorkspaceTree.3") + noNodes;
            Application.getInstance().getMainWindow().setStatusBarMessage(message, 0);
        }
    }
}

