/*
 * Decompiled with CFR 0.152.
 */
package germ.logging;

import germ.configuration.ConfigurationManager;
import germ.logging.LogFormater;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager {
    private static Logger logger = Logger.getLogger("germ");

    static {
        try {
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.ALL);
            ConfigurationManager cm = ConfigurationManager.getInstance();
            LogFormater defaultLogFormater = new LogFormater();
            if (cm.getConfigParameter("logToFile").equals("true")) {
                FileHandler fh = new FileHandler(cm.getConfigParameter("logFileName"), 1000000, 3, true);
                fh.setFormatter(defaultLogFormater);
                logger.addHandler(fh);
            }
            if (Boolean.valueOf(cm.getConfigParameter("logToConsole").equals("true")).booleanValue()) {
                ConsoleHandler ch = new ConsoleHandler();
                ch.setFormatter(defaultLogFormater);
                logger.addHandler(ch);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Logger getLogger() {
        return logger;
    }
}

