/*
 * Decompiled with CFR 0.152.
 */
package germ.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.DomDriver;
import germ.actions.ActionManager;
import germ.app.Application;
import germ.command.CommandManager;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.MainWindow;
import germ.i18n.Messages;
import germ.model.Link;
import germ.model.Node;
import germ.model.event.UpdateEvent;
import germ.model.event.UpdateListener;
import germ.model.workspace.Project;
import germ.util.Counter;
import germ.util.Cursors;
import germ.view.GERMView;
import germ.view.LinkPainter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GERMModel {
    protected ArrayList<Node> nodes = new ArrayList();
    protected ArrayList<Node> nodesImmutableIndexes = new ArrayList();
    protected ArrayList<Node> ghostNodes = new ArrayList();
    protected transient ArrayList<Node> selectedNodes = new ArrayList();
    protected transient Node mouseOverNode;
    protected ArrayList<Link> links = new ArrayList();
    protected transient Link selectedLink = null;
    protected transient Point selectedBreakpoint = null;
    protected transient ArrayList<Link> alteredLinks = new ArrayList();
    protected transient Point lasoBegin = new Point();
    protected transient Point lasoEnd = new Point();
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient UpdateEvent updateEvent = null;
    protected transient Project project;
    private String name;
    private AffineTransform transform;
    protected transient GERMView view;
    protected transient CommandManager commandManager;
    protected transient boolean changed = false;
    private transient int commandsCountOnSave = 0;
    protected Hashtable<String, Counter> counters = new Hashtable();

    public GERMModel(String name, Project project) {
        this.name = name;
        this.project = project;
        this.view = new GERMView(this);
        this.transform = this.view.getTransform();
        this.commandManager = new CommandManager(this);
        this.addUpdateListener(this.view);
        this.initaliseCounters();
        this.fireUpdatePerformed();
    }

    private void initaliseCounters() {
        this.counters.put("stakeholder", new Counter());
        this.counters.put("assumption", new Counter());
        this.counters.put("argument", new Counter());
        this.counters.put("position", new Counter());
        this.counters.put("decision", new Counter());
        this.counters.put("topic", new Counter());
        this.counters.put("requirement", new Counter());
    }

    public long getCounter(String type) {
        return this.counters.get(type).next();
    }

    public ArrayList<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public ArrayList<Node> getGhostNodes() {
        return this.ghostNodes;
    }

    public void addLink(Link link) {
        this.links.add(link);
        for (Node node : this.nodes) {
            if (link.source != node && link.destination != node) continue;
            node.addLink(link);
        }
        this.fireUpdatePerformed();
    }

    public Link getLastLink() {
        if (this.links.isEmpty()) {
            return null;
        }
        return this.links.get(this.getLinkCount() - 1);
    }

    public void removeLink(Link link) {
        this.links.remove(link);
        this.selectedLink = null;
        for (Node node : this.nodes) {
            if (link.source != node && link.destination != node) continue;
            node.removeLink(link);
        }
        this.fireUpdatePerformed();
    }

    public void updatePerformed() {
        this.fireUpdatePerformed();
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public Link getLinkAt(int i) {
        return this.links.get(i);
    }

    public Iterator<Link> getLinkIterator() {
        return this.links.iterator();
    }

    public Iterator<Node> getGhostNodesIterator() {
        return this.ghostNodes.iterator();
    }

    public void addGhostNode(Node node) {
        this.ghostNodes.add((Node)node.clone());
    }

    public void selectNode(Node node) {
        this.selectedNodes.add(node);
        this.updateSelectionStatusBar();
        this.fireUpdatePerformed();
    }

    public void deselectAllNodes() {
        this.selectedNodes.clear();
        this.updateSelectionStatusBar();
        this.fireUpdatePerformed();
    }

    public void deselectNode(Node node) {
        this.selectedNodes.remove(node);
        this.updateSelectionStatusBar();
        this.fireUpdatePerformed();
    }

    public void selectNode(Shape s) {
        Iterator<Node> it = this.getNodeIterator();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        while (it.hasNext()) {
            Node n = it.next();
            rect.setFrame(n.getPosition().getX(), n.getPosition().getY(), n.getSize().width, n.getSize().height);
            if (!s.intersects(rect)) continue;
            this.toggleNodeSelect(n, false);
        }
        this.updateSelectionStatusBar();
        this.fireUpdatePerformed();
    }

    public Iterator<Node> getSelectedNodesIterator() {
        return this.selectedNodes.iterator();
    }

    public int selectedNodesCount() {
        return this.selectedNodes.size();
    }

    public Boolean isNodeIsSelected(Node node) {
        if (this.selectedNodes.contains(node)) {
            return true;
        }
        return false;
    }

    public void inverseSelection() {
        for (Node node : this.nodes) {
            this.toggleNodeSelect(node, false);
        }
        this.updateSelectionStatusBar();
        this.fireUpdatePerformed();
    }

    public void selectAllNodes() {
        this.selectedNodes.clear();
        this.selectedNodes = (ArrayList)this.nodes.clone();
        this.updateSelectionStatusBar();
        this.fireUpdatePerformed();
    }

    public void toggleNodeSelect(Node node, boolean updateNeeded) {
        if (this.selectedNodes.contains(node)) {
            this.selectedNodes.remove(node);
        } else {
            this.selectedNodes.add(node);
        }
        this.updateSelectionStatusBar();
        if (updateNeeded) {
            this.fireUpdatePerformed();
        }
    }

    public void updateSelectedNodesPosition(int offsetX, int offsetY) {
        this.alteredLinks.clear();
        for (Node current : this.selectedNodes) {
            current.position.setLocation(current.getPosition().getX() - (double)offsetX, current.getPosition().getY() - (double)offsetY);
            this.updateLinkBreakpointPosition(current, offsetX, offsetY);
        }
        this.fireUpdatePerformed();
    }

    public void updateSelectedNodesPosition90(Node hitNode, int offsetX, int offsetY) {
        boolean movedX = false;
        boolean movedY = false;
        int newOffsetX = 0;
        int newOffsetY = 0;
        for (Link link : hitNode.getLinks()) {
            Point centerNodePoint;
            Point comparePoint;
            if (movedX && movedY) break;
            if (link.getSource() == hitNode) {
                comparePoint = link.getBreakPointCount() > 0 ? link.getBreakPointAt(0) : link.getDestinationCenterPosition();
                centerNodePoint = link.getSourceCenterPosition();
            } else {
                comparePoint = link.getBreakPointCount() > 0 ? link.getBreakPointAt(link.getBreakPointCount() - 1) : link.getSourceCenterPosition();
                centerNodePoint = link.getDestinationCenterPosition();
            }
            if (!movedX && this.snapByX(centerNodePoint, comparePoint, true)) {
                newOffsetX = centerNodePoint.x - comparePoint.x;
                movedX = true;
            }
            if (movedY || !this.snapByY(centerNodePoint, comparePoint, true)) continue;
            newOffsetY = centerNodePoint.y - comparePoint.y;
            movedY = true;
        }
        if (!movedX) {
            newOffsetX = offsetX;
        }
        if (!movedY) {
            newOffsetY = offsetY;
        }
        this.updateSelectedNodesPosition(newOffsetX, newOffsetY);
    }

    public void updateSelectedBreakPointPosition() {
        GERMView v = this.getView();
        if (this.selectedBreakpoint != null) {
            this.selectedBreakpoint.setLocation(v.lastPosition);
            this.fireUpdatePerformed();
        }
    }

    public void updateSelectedBreakPointPosition90() {
        if (this.selectedBreakpoint != null) {
            int selectedNo = this.selectedLink.getBreakPoints().lastIndexOf(this.selectedBreakpoint);
            Point nextBreakpoint = selectedNo == this.selectedLink.getBreakPoints().size() - 1 ? this.selectedLink.getDestinationCenterPosition() : this.selectedLink.getBreakPointAt(selectedNo + 1);
            Point prevBreakpoint = selectedNo == 0 ? this.selectedLink.getSourceCenterPosition() : this.selectedLink.getBreakPointAt(selectedNo - 1);
            GERMView v = this.getView();
            if (prevBreakpoint != null && this.snapByX(prevBreakpoint, this.selectedBreakpoint, false)) {
                this.selectedBreakpoint.setLocation((double)prevBreakpoint.x, this.selectedBreakpoint.getLocation().getY());
            } else if (nextBreakpoint != null && this.snapByX(nextBreakpoint, this.selectedBreakpoint, false)) {
                this.selectedBreakpoint.setLocation((double)nextBreakpoint.x, this.selectedBreakpoint.getLocation().getY());
            } else {
                this.selectedBreakpoint.setLocation(v.lastPosition.getX(), this.selectedBreakpoint.getY());
            }
            if (prevBreakpoint != null && this.snapByY(prevBreakpoint, this.selectedBreakpoint, false)) {
                this.selectedBreakpoint.setLocation(this.selectedBreakpoint.getLocation().getX(), (double)prevBreakpoint.y);
            } else if (nextBreakpoint != null && this.snapByY(nextBreakpoint, this.selectedBreakpoint, false)) {
                this.selectedBreakpoint.setLocation(this.selectedBreakpoint.getLocation().getX(), (double)nextBreakpoint.y);
            } else {
                this.selectedBreakpoint.setLocation(this.selectedBreakpoint.getX(), v.lastPosition.getY());
            }
            this.fireUpdatePerformed();
        }
    }

    boolean snapByX(Point breakpoint, Point otherBreakpoint, boolean nodeInc) {
        GERMView v = this.getView();
        double minimumScale = v.getTransform().getScaleX();
        if (minimumScale < 0.9) {
            minimumScale = 0.9;
        }
        double tol = 14.0 / minimumScale;
        if (nodeInc) {
            tol += 6.0;
        }
        return (double)breakpoint.x - tol < (double)otherBreakpoint.x && (double)breakpoint.x + tol > (double)otherBreakpoint.x && v.lastPosition.getX() < (double)otherBreakpoint.x + 2.0 * tol && v.lastPosition.getX() > (double)otherBreakpoint.x - 2.0 * tol;
    }

    boolean snapByY(Point breakpoint, Point otherBreakpoint, boolean nodeInc) {
        GERMView v = this.getView();
        double minimumScale = v.getTransform().getScaleX();
        if (minimumScale < 0.9) {
            minimumScale = 0.9;
        }
        double tol = 14.0 / minimumScale;
        if (nodeInc) {
            tol += 6.0;
        }
        return (double)breakpoint.y - tol < (double)otherBreakpoint.y && (double)breakpoint.y + tol > (double)otherBreakpoint.y && v.lastPosition.getY() < (double)otherBreakpoint.y + 2.0 * tol && v.lastPosition.getY() > (double)otherBreakpoint.y - 2.0 * tol;
    }

    public void updateLinkBreakpointPosition(Node node, int offsetX, int offsetY) {
        for (Link link : node.links) {
            if (this.alteredLinks.contains(link) || !this.otherNodeHasLink(link, node)) continue;
            for (Point current : link.breakPoints) {
                current.setLocation(current.getX() - (double)offsetX, current.getY() - (double)offsetY);
            }
            this.alteredLinks.add(link);
        }
    }

    public ArrayList<Link> loadAlteredLinks() {
        this.alteredLinks.clear();
        for (Node current : this.nodes) {
            for (Link link : current.links) {
                if (this.alteredLinks.contains(link) || !this.otherNodeHasLink(link, current)) continue;
                this.alteredLinks.add(link);
            }
        }
        return this.alteredLinks;
    }

    private boolean otherNodeHasLink(Link link, Node node) {
        for (Node current : this.selectedNodes) {
            if (current == node || current != link.source && current != link.destination) continue;
            return true;
        }
        return false;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        this.nodesImmutableIndexes.add(node);
        this.fireUpdatePerformed();
    }

    public void removeNode(Node node) {
        if (this.isNodeIsSelected(node).booleanValue()) {
            this.deselectNode(node);
        }
        this.nodes.remove(node);
        this.nodesImmutableIndexes.remove(node);
        for (Link l : node.getLinks()) {
            this.removeLink(l);
        }
        this.setMouseOverNode(null);
        this.fireUpdatePerformed();
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public Node getNodeAt(int i) {
        return this.nodes.get(i);
    }

    public Iterator<Node> getNodeIterator() {
        return this.nodes.iterator();
    }

    public int getNodeAtPosition(Point2D point) {
        int i = this.getNodeCount() - 1;
        while (i >= 0) {
            Node node = this.getNodeAt(i);
            if (node.getPainter().isElementAt(point)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int getLinkAtPosition(Point2D point) {
        int i = this.getLinkCount() - 1;
        while (i >= 0) {
            Link link = this.getLinkAt(i);
            if (link.getPainter().isElementAt(point)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void setSelectedBreakpoint(Point lastPosition) {
        Point bp = null;
        if (this.selectedLink != null) {
            bp = ((LinkPainter)this.selectedLink.getPainter()).getBreakpointAt(lastPosition);
        }
        this.selectedBreakpoint = bp;
    }

    public Point getSelectedBreakpoint() {
        return this.selectedBreakpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rectangle getBestFitRectangle(boolean selectionOnly) {
        Node node;
        Iterator<Node> it;
        if (selectionOnly) {
            if (this.selectedNodesCount() <= 0) return null;
            it = this.getSelectedNodesIterator();
            node = this.selectedNodes.get(0);
        } else {
            if (this.getNodeCount() <= 0) return null;
            it = this.getNodeIterator();
            node = this.nodes.get(0);
        }
        Point2D current = node.getPosition();
        double x1 = current.getX();
        double x2 = current.getX();
        double y1 = current.getY();
        double y2 = current.getY();
        while (it.hasNext()) {
            node = it.next();
            current = node.getPosition();
            Dimension dim = node.getSize();
            if (current.getX() < x1) {
                x1 = current.getX();
            }
            if (current.getX() + ((Dimension2D)dim).getWidth() > x2) {
                x2 = current.getX() + ((Dimension2D)dim).getWidth();
            }
            if (current.getY() < y1) {
                y1 = current.getY();
            }
            if (!(current.getY() + ((Dimension2D)dim).getHeight() > y2)) continue;
            y2 = current.getY() + ((Dimension2D)dim).getHeight();
        }
        Rectangle result = new Rectangle();
        result.setFrameFromDiagonal(x1 - 10.0, y1 - 10.0, x2 + 10.0, y2 + 30.0);
        return result;
    }

    public void nodeToFront(int nodeInMotion) {
        this.nodes.add(this.getNodeCount(), this.nodes.get(nodeInMotion));
        this.nodes.remove(nodeInMotion);
    }

    public void addUpdateListener(UpdateListener l) {
        this.listenerList.add(UpdateListener.class, l);
    }

    public void removeUpdateListener(UpdateListener l) {
        this.listenerList.remove(UpdateListener.class, l);
    }

    public Point getLasoBegin() {
        return this.lasoBegin;
    }

    public void setLasoBegin(Point lasoBegin) {
        this.lasoBegin = lasoBegin;
    }

    public Point getLasoEnd() {
        return this.lasoEnd;
    }

    public void setLasoEnd(Point lasoEnd) {
        this.lasoEnd = lasoEnd;
        this.fireUpdatePerformed();
    }

    public Link getSelectedLink() {
        return this.selectedLink;
    }

    public Node getMouseOverNode() {
        return this.mouseOverNode;
    }

    public void setMouseOverNode(Node n) {
        this.mouseOverNode = n;
    }

    public void setSelectedLink(Link selectedLink) {
        this.selectedLink = selectedLink;
        Application app = Application.getInstance();
        if (selectedLink == null) {
            app.getView().setCursor(Cursors.getCursor("default"));
            this.selectedBreakpoint = null;
        } else {
            app.getView().setCursor(Cursors.getCursor("inverse"));
        }
        this.updateActionButtons(app);
        this.fireUpdatePerformed();
    }

    public ArrayList<Link> getLinks() {
        return this.links;
    }

    public Node getNodeAtImmutableIndex(int i) {
        return this.nodesImmutableIndexes.get(i);
    }

    public int getNodeIndexImmutable(Node gate) {
        return this.nodesImmutableIndexes.indexOf(gate);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public String getFileName() {
        return String.valueOf(this.getName()) + "." + "drm";
    }

    protected void fireUpdatePerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == UpdateListener.class) {
                if (this.updateEvent == null) {
                    this.updateEvent = new UpdateEvent(this);
                }
                ((UpdateListener)listeners[i + 1]).updatePerformed(this.updateEvent);
            }
            i -= 2;
        }
    }

    public GERMView getView() {
        return this.view;
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        Application.getInstance().getMainWindow().renameDiagram(this);
    }

    public void commandExecuted() {
        if (this.commandManager.getCommandsCount() == this.commandsCountOnSave) {
            this.setChanged(false);
        } else {
            this.setChanged(true);
        }
    }

    public void save() {
        try {
            String diagramFile = String.valueOf(this.project.getProjectDir().getCanonicalPath()) + File.separator + this.getFileName();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(diagramFile), "UTF8"));
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.toXML((Object)this, (Writer)out);
            this.setChanged(false);
            this.commandsCountOnSave = this.commandManager.getCommandsCount();
        }
        catch (XStreamException e) {
            System.err.println(String.valueOf(Messages.getString("GERMModel.11")) + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            String diagramFile = String.valueOf(this.project.getProjectDir().getCanonicalPath()) + File.separator + this.name + "." + "drm";
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(diagramFile), "UTF8"));
            xstream.fromXML((Reader)in, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (StreamException e) {
            System.err.println(Messages.getString("GERMModel.13"));
        }
    }

    public Project getProject() {
        return this.project;
    }

    public void updateSelectionStatusBar() {
        MainWindow mw = Application.getInstance().getMainWindow();
        this.updateActionButtons(Application.getInstance());
        if (this.selectedNodes.size() > 0) {
            if (this.selectedNodes.size() == 1) {
                mw.setStatusBarMessage(String.valueOf(Messages.getString("GERMModel.10")) + this.selectedNodes.get((int)0).name, 0);
            } else if (this.selectedNodes.size() == this.nodes.size()) {
                mw.setStatusBarMessage(String.valueOf(Messages.getString("GERMModel.9")) + this.nodes.size() + ")", 0);
            } else {
                String kobaja = new String();
                String selectionPrefix = Messages.getString("GERMModel.8");
                int i = 0;
                while (i < this.selectedNodes.size()) {
                    Node current = this.selectedNodes.get(i);
                    int max = ConfigurationManager.getInstance().getInt("maxStatusLabel0Length");
                    if (selectionPrefix.length() + kobaja.length() + current.name.length() < max) {
                        kobaja = String.valueOf(kobaja) + current.name;
                        if (i + 1 < this.selectedNodes.size()) {
                            kobaja = String.valueOf(kobaja) + ", ";
                        }
                    } else {
                        kobaja = String.valueOf(kobaja) + "...";
                        break;
                    }
                    ++i;
                }
                mw.setStatusBarMessage(String.valueOf(selectionPrefix) + " (" + this.selectedNodes.size() + "): " + kobaja, 0);
            }
        } else {
            mw.setStatusBarMessage(Messages.getString("GERMModel.7"), 0);
        }
    }

    public void updateActionButtons(Application app) {
        ActionManager am = app.getActionManager();
        if (this.selectedNodes.size() == 0) {
            am.getCutAction().setEnabled(false);
            am.getCopyAction().setEnabled(false);
            am.getDeleteAction().setEnabled(false);
            am.getDistributeHorizontalAction().setEnabled(false);
            am.getDistributeVerticalAction().setEnabled(false);
            am.getAlignBottomAction().setEnabled(false);
            am.getAlignLeftAction().setEnabled(false);
            am.getAlignRightAction().setEnabled(false);
            am.getAlignTopAction().setEnabled(false);
        }
        if (this.selectedNodes.size() == 1) {
            am.getCutAction().setEnabled(true);
            am.getCopyAction().setEnabled(true);
            am.getDeleteAction().setEnabled(true);
            am.getDistributeHorizontalAction().setEnabled(false);
            am.getDistributeVerticalAction().setEnabled(false);
            am.getAlignBottomAction().setEnabled(false);
            am.getAlignLeftAction().setEnabled(false);
            am.getAlignRightAction().setEnabled(false);
            am.getAlignTopAction().setEnabled(false);
        }
        if (this.selectedNodes.size() > 1) {
            am.getCutAction().setEnabled(true);
            am.getCopyAction().setEnabled(true);
            am.getDeleteAction().setEnabled(true);
            am.getDistributeHorizontalAction().setEnabled(true);
            am.getDistributeVerticalAction().setEnabled(true);
            am.getAlignBottomAction().setEnabled(true);
            am.getAlignLeftAction().setEnabled(true);
            am.getAlignRightAction().setEnabled(true);
            am.getAlignTopAction().setEnabled(true);
        }
        if (this.selectedLink != null && this.selectedLink.source != null && this.selectedLink.destination != null) {
            am.getDeleteAction().setEnabled(true);
        }
    }

    private GERMModel readResolve() {
        this.nodesImmutableIndexes = (ArrayList)this.nodes.clone();
        if (this.transform != null) {
            this.view.setTransform(this.transform);
        }
        return this;
    }

    public String getDiagramPath() throws IOException {
        String diagramPath = String.valueOf(this.getProject().getProjectDir().getCanonicalPath()) + File.separator + this.getFileName();
        return diagramPath;
    }

    public File getDiagramDir() {
        try {
            File diagramDir = new File(this.getDiagramPath());
            return diagramDir;
        }
        catch (IOException e) {
            return null;
        }
    }

    public ArrayList<Link> getAlteredLinks() {
        return this.alteredLinks;
    }
}

