/*
 * Decompiled with CFR 0.152.
 */
package germ.model;

import germ.view.GraphElementPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public abstract class GraphElement {
    protected Paint paint;
    protected String name;
    protected String description;
    private float strokeThickness = 3.0f;
    private Color primColor = Color.WHITE;
    private Color secColor = Color.WHITE;
    private Color strokeColor = Color.BLACK;
    protected Stroke stroke = new BasicStroke(this.strokeThickness, 0, 2);
    protected Paint strokePaint = this.strokeColor;
    protected GraphElementPainter graphElementPainter;

    public GraphElement() {
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public GraphElement(Stroke stroke, Paint paint) {
        this.stroke = stroke;
        this.paint = paint;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GraphElementPainter getPainter() {
        return this.graphElementPainter;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Color getPrimColor() {
        return this.primColor;
    }

    public void setPrimColor(Color primColor) {
        this.primColor = primColor;
    }

    public Color getSecColor() {
        return this.secColor;
    }

    public void setSecColor(Color secColor) {
        this.secColor = secColor;
    }

    public float getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setStrokeThickness(float strokeThickness) {
        this.strokeThickness = strokeThickness;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    protected GraphElement clone(GraphElement ge) {
        ge.setName(this.getName());
        ge.setPaint(this.getPaint());
        ge.graphElementPainter = this.getPainter();
        ge.setStroke(this.getStroke());
        ge.setStrokePaint(this.getStrokePaint());
        ge.setPrimColor(this.getPrimColor());
        ge.setSecColor(this.getSecColor());
        ge.setStrokeColor(this.getStrokeColor());
        return ge;
    }

    public abstract GraphElement clone();
}

