/*
 * Decompiled with CFR 0.152.
 */
package germ.model;

import germ.configuration.InternalConfiguration;
import germ.i18n.Messages;
import germ.model.GraphElement;
import germ.model.Node;
import germ.view.GraphElementPainter;
import germ.view.LinkPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Link
extends GraphElement {
    protected Node source;
    protected Node destination;
    protected ArrayList<Point> breakPoints = new ArrayList();

    private Link() {
    }

    public ArrayList<Point> getBreakPoints() {
        return this.breakPoints;
    }

    public void setBreakPoints(ArrayList<Point> newBreakPoints) {
        this.breakPoints = newBreakPoints;
    }

    public Link(Stroke stroke, Paint paint, Node source) {
        super(stroke, paint);
        this.source = source;
        this.graphElementPainter = new LinkPainter(this);
    }

    public static Link createDefault(Point2D pos, int elemNo, Node source) {
        Point2D position = (Point2D)pos.clone();
        position.setLocation(position.getX() - 50.0, position.getY() - 25.0);
        GradientPaint fill = new GradientPaint(0.0f, 0.0f, Color.BLACK, 100.0f, 50.0f, Color.BLACK);
        Link l = new Link(new BasicStroke(3.0f, 1, 1), fill, source);
        l.setName(String.valueOf(Messages.getString("Link.0")) + new Integer(elemNo));
        return l;
    }

    public void deleteBreakpoint(Point point) {
        this.breakPoints.remove(point);
    }

    public void addBreakPoint(Point p) {
        this.breakPoints.add((Point)p.clone());
    }

    public void addBreakPointBegining(Point p) {
        this.breakPoints.add(0, (Point)p.clone());
    }

    public void deleteBreakpointTail() {
        this.breakPoints.remove(this.breakPoints.size() - 1);
    }

    public void deleteBreakpointHead() {
        this.breakPoints.remove(0);
    }

    public void insertNewBreakpoint(Point pos) {
        boolean inserted = false;
        float tol = InternalConfiguration.LINK_HIT_TOLERANCE;
        double newX = this.source.getSize().getWidth() / 2.0 + this.source.position.getX();
        double newY = this.source.getSize().getHeight() / 2.0 + this.source.position.getY();
        Line2D.Double line = new Line2D.Double(newX, newY, 0.0, 0.0);
        int i = 0;
        while (i < this.breakPoints.size()) {
            ((Line2D)line).setLine(((Line2D)line).getX1(), ((Line2D)line).getY1(), this.breakPoints.get(i).getX(), this.breakPoints.get(i).getY());
            if (line.intersects(pos.getX() - (double)tol, pos.getY() - (double)tol, 2.0f * tol, 2.0f * tol)) {
                this.breakPoints.add(i, (Point)pos.clone());
                inserted = true;
                break;
            }
            ((Line2D)line).setLine(this.breakPoints.get(i).getX(), this.breakPoints.get(i).getY(), 0.0, 0.0);
            ++i;
        }
        if (!inserted) {
            this.breakPoints.add((Point)pos.clone());
        }
    }

    public void removeBreakPoint(Point p) {
        this.breakPoints.remove(p);
    }

    public Point getBreakPointAt(int i) {
        return this.breakPoints.get(i);
    }

    public int getBreakPointCount() {
        return this.breakPoints.size();
    }

    public Iterator<Point> getBreakPointIterator() {
        return this.breakPoints.iterator();
    }

    public Node getDestination() {
        return this.destination;
    }

    public void setDestination(Node destination) {
        this.destination = destination;
        if (destination != null) {
            destination.addLink(this);
        }
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
        if (source != null) {
            source.addLink(this);
        }
    }

    public Point getSourceCenterPosition() {
        if (this.source == null) {
            return null;
        }
        Point point = new Point();
        point.setLocation(this.getSource().getPosition().getX() + this.getSource().getSize().getWidth() / 2.0, this.getSource().getPosition().getY() + this.getSource().getSize().getHeight() / 2.0);
        return point;
    }

    public Point getDestinationCenterPosition() {
        if (this.destination == null) {
            return null;
        }
        Point point = new Point();
        point.setLocation(this.getDestination().getPosition().getX() + this.getDestination().getSize().getWidth() / 2.0, this.getDestination().getPosition().getY() + this.getDestination().getSize().getHeight() / 2.0);
        return point;
    }

    public boolean hasBreakPoints() {
        return !this.breakPoints.isEmpty();
    }

    @Override
    public GraphElementPainter getPainter() {
        return this.graphElementPainter;
    }

    @Override
    public Link clone() {
        Link l = new Link();
        super.clone(l);
        l.setDestination(this.getDestination());
        l.setSource(this.getSource());
        Iterator<Point> it = this.getBreakPointIterator();
        while (it.hasNext()) {
            l.addBreakPoint((Point)it.next().clone());
        }
        return l;
    }
}

