/*
 * Decompiled with CFR 0.152.
 */
package germ.model;

import germ.gui.windows.PropertyWindow;
import germ.model.GraphElement;
import germ.model.Link;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
extends GraphElement {
    protected Dimension size;
    protected Point2D position;
    protected Calendar creationDate;
    protected Calendar lastChangeDate;
    protected ArrayList<Link> links = new ArrayList();
    protected double scaleX = 1.0;
    protected double scaleY = 1.0;
    protected int flip = 1;

    public Node() {
    }

    public Node(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(stroke, paint);
        this.size = size;
        this.position = position;
    }

    public ArrayList<Link> getLinks() {
        return this.links;
    }

    public void addLink(Link l) {
        this.links.add(l);
    }

    public void removeLink(Link l) {
        this.links.remove(l);
    }

    public void removeAllLinks() {
        this.links.clear();
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public Dimension getSize() {
        Dimension dim = new Dimension();
        dim = (Dimension)this.size.clone();
        dim.setSize(dim.getWidth() * this.scaleX, dim.getHeight() * this.scaleY);
        return dim;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public Calendar getLastChangeDate() {
        return this.lastChangeDate;
    }

    public void setLastChangeDate(Calendar lastChangeDate) {
        this.lastChangeDate = lastChangeDate;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(double scaleX) {
        if (scaleX < 0.1) {
            scaleX = 0.1;
        }
        if (scaleX > 10.0) {
            scaleX = 10.0;
        }
        this.scaleX = scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(double scaleY) {
        if (scaleY < 0.1) {
            scaleY = 0.1;
        }
        if (scaleY > 10.0) {
            scaleY = 10.0;
        }
        this.scaleY = scaleY;
    }

    public int getFlip() {
        return this.flip;
    }

    public void setFlip(int flip) {
        this.flip = flip;
    }

    public Node clone(Node n) {
        super.clone(n);
        n.setPosition((Point2D)this.getPosition().clone());
        n.setSize(new Dimension(this.size.width, this.size.height));
        n.setCreationDate(this.getCreationDate());
        n.setFlip(this.getFlip());
        n.setScaleX(this.getScaleX());
        n.setScaleY(this.getScaleY());
        return n;
    }

    public void setColorProperties(boolean gradient, Color fillPrim, Color fillSec, Color strokeCol, float strokeThickness) {
        if (fillPrim != null) {
            this.setPrimColor(fillPrim);
            if (!gradient) {
                this.setSecColor(fillPrim);
            }
        }
        if (fillSec != null) {
            if (gradient) {
                this.setSecColor(fillSec);
            } else {
                this.setSecColor(fillPrim);
            }
        }
        this.setPaint(new GradientPaint(0.0f, 0.0f, this.getPrimColor(), this.size.width, this.size.height, this.getSecColor()));
        if (strokeCol != null) {
            this.setStrokeColor(strokeCol);
        }
        this.setStrokePaint(this.getStrokeColor());
        if (strokeThickness != 0.0f) {
            this.setStrokeThickness(strokeThickness);
            this.setStroke(new BasicStroke(strokeThickness, 0, 2));
        }
    }

    public abstract PropertyWindow getPropertyWindow();

    public abstract void setProperties(boolean var1);

    protected HashMap<String, Object> getNodeProperties() {
        HashMap<String, Object> rez = new HashMap<String, Object>();
        rez.put("name", this.getName());
        rez.put("description", this.getDescription());
        rez.put("primColor", this.getPrimColor());
        rez.put("secColor", this.getSecColor());
        rez.put("paint", this.getPaint());
        rez.put("strokeColor", this.getStrokeColor());
        rez.put("strokePaint", this.getStrokePaint());
        rez.put("strokeThickness", Float.valueOf(this.getStrokeThickness()));
        rez.put("stroke", this.getStroke());
        rez.put("lastChangedDate", this.getLastChangeDate());
        return rez;
    }

    protected void setNodeProperties(HashMap<String, Object> properties) {
        this.setName((String)properties.get("name"));
        this.setDescription((String)properties.get("description"));
        this.setPrimColor((Color)properties.get("primColor"));
        this.setSecColor((Color)properties.get("secColor"));
        this.setPaint((Paint)properties.get("paint"));
        this.setStrokeColor((Color)properties.get("strokeColor"));
        this.setStrokePaint((Paint)properties.get("strokePaint"));
        this.setStrokeThickness(((Float)properties.get("strokeThickness")).floatValue());
        this.setStroke((Stroke)properties.get("stroke"));
        this.setLastChangeDate((Calendar)properties.get("lastChangedDate"));
    }

    public String toString() {
        return this.getName();
    }

    public abstract HashMap<String, Object> getProperties();

    public abstract void setProperties(HashMap<String, Object> var1);

    public void flip() {
        this.flip = -this.flip;
    }
}

