/*
 * Decompiled with CFR 0.152.
 */
package germ.model.nodes;

import germ.app.Application;
import germ.command.SetPropertiesCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.ArgumentProperties;
import germ.gui.windows.PropertyWindow;
import germ.i18n.Messages;
import germ.model.Node;
import germ.model.nodes.ArgumentValue;
import germ.view.painters.ArgumentPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Argument
extends Node {
    private String author;
    private ArgumentValue value = ArgumentValue.ARG_NEUTRAL;
    protected static PropertyWindow nodePropertyWindow = new ArgumentProperties();

    private Argument() {
    }

    public Argument(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(position, size, stroke, paint);
        this.graphElementPainter = new ArgumentPainter(this);
    }

    public static Node createDefault(Point2D pos, int elemNo) {
        Point2D position = (Point2D)pos.clone();
        Argument r = new Argument();
        r.setSize(ConfigurationManager.getInstance().getDimension("argumentSize"));
        r.setStrokeThickness(ConfigurationManager.getInstance().getFloat("argumentStrokeThickness"));
        r.setStrokeColor(ConfigurationManager.getInstance().getColor("argumentStrokeColor"));
        r.setPrimColor(ConfigurationManager.getInstance().getColor("argumentFillPrimColor"));
        r.setSecColor(ConfigurationManager.getInstance().getColor("argumentFillSecColor"));
        position.setLocation(position.getX() - (double)(r.getSize().width / 2), position.getY() - (double)(r.getSize().height / 2));
        r.setPosition(position);
        r.setStroke(new BasicStroke(r.getStrokeThickness(), 0, 1));
        r.setPaint(new GradientPaint(0.0f, 0.0f, r.getPrimColor(), r.size.width, r.size.height, r.getSecColor()));
        r.setStrokePaint(r.getStrokeColor());
        r.setCreationDate(Calendar.getInstance());
        r.graphElementPainter = new ArgumentPainter(r);
        r.setName(String.valueOf(Messages.getString("Argument.5")) + Application.getInstance().getModel().getCounter("argument"));
        return r;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Calendar getLastChangeDate() {
        return this.lastChangeDate;
    }

    @Override
    public void setLastChangeDate(Calendar lastChangeDate) {
        this.lastChangeDate = lastChangeDate;
    }

    public ArgumentValue getValue() {
        return this.value;
    }

    public void setValue(ArgumentValue value) {
        this.value = value;
        ((ArgumentPainter)this.graphElementPainter).reshape(this);
    }

    @Override
    public Node clone() {
        Argument a = new Argument();
        super.clone(a);
        a.graphElementPainter = new ArgumentPainter(a);
        a.setAuthor(this.getAuthor());
        a.setLastChangeDate(this.getLastChangeDate());
        a.setValue(this.getValue());
        return a;
    }

    @Override
    public PropertyWindow getPropertyWindow() {
        ArgumentProperties properties = (ArgumentProperties)nodePropertyWindow;
        properties.setName(this.getName());
        properties.setDescription(this.getDescription());
        properties.setAuthor(this.getAuthor());
        properties.setValue(this.getValue());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        return nodePropertyWindow;
    }

    @Override
    public void setProperties(boolean result) {
        if (result) {
            HashMap<String, Object> oldProperties = this.getProperties();
            ArgumentProperties properties = (ArgumentProperties)nodePropertyWindow;
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            newProperties.put("name", properties.getName());
            newProperties.put("description", properties.getDescription());
            newProperties.put("author", properties.getAuthor());
            newProperties.put("value", (Object)properties.getValue());
            newProperties.put("primColor", properties.getFillPrimColor());
            if (properties.isGradient()) {
                newProperties.put("secColor", properties.getFillSecColor());
            } else {
                newProperties.put("secColor", properties.getFillPrimColor());
            }
            newProperties.put("paint", new GradientPaint(0.0f, 0.0f, (Color)newProperties.get("primColor"), this.size.width, this.size.height, (Color)newProperties.get("secColor")));
            newProperties.put("strokeColor", properties.getStrokeColor());
            newProperties.put("strokePaint", properties.getStrokeColor());
            newProperties.put("strokeThickness", Float.valueOf(properties.getStrokeThickness()));
            newProperties.put("stroke", new BasicStroke(properties.getStrokeThickness(), 0, 2));
            newProperties.put("lastChangedDate", Calendar.getInstance());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(this);
            SetPropertiesCommand propetiesCommand = new SetPropertiesCommand(nodes, oldProperties, newProperties);
            Application.getInstance().getCommandManager().doCommand(propetiesCommand);
        }
    }

    @Override
    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> rez = super.getNodeProperties();
        rez.put("author", this.getAuthor());
        rez.put("value", (Object)this.getValue());
        return rez;
    }

    @Override
    public void setProperties(HashMap<String, Object> properties) {
        super.setNodeProperties(properties);
        this.setAuthor((String)properties.get("author"));
        this.setValue((ArgumentValue)((Object)properties.get("value")));
    }
}

