/*
 * Decompiled with CFR 0.152.
 */
package germ.model.nodes;

import germ.app.Application;
import germ.command.SetPropertiesCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.AssumptionProperties;
import germ.gui.windows.PropertyWindow;
import germ.i18n.Messages;
import germ.model.Node;
import germ.view.painters.AssumptionPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assumption
extends Node {
    private String probability;
    private String source;
    private static PropertyWindow nodePropertyWindow = new AssumptionProperties();

    private Assumption() {
    }

    public Assumption(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(position, size, stroke, paint);
        this.graphElementPainter = new AssumptionPainter(this);
    }

    public static Node createDefault(Point2D pos, int elemNo) {
        Point2D position = (Point2D)pos.clone();
        Assumption r = new Assumption();
        r.setSize(ConfigurationManager.getInstance().getDimension("assumptionSize"));
        r.setStrokeThickness(ConfigurationManager.getInstance().getFloat("assumptionStrokeThickness"));
        r.setStrokeColor(ConfigurationManager.getInstance().getColor("assumptionStrokeColor"));
        r.setPrimColor(ConfigurationManager.getInstance().getColor("assumptionFillPrimColor"));
        r.setSecColor(ConfigurationManager.getInstance().getColor("assumptionFillSecColor"));
        position.setLocation(position.getX() - (double)(r.getSize().width / 2), position.getY() - (double)(r.getSize().height / 2));
        r.setPosition(position);
        r.setStroke(new BasicStroke(r.getStrokeThickness(), 0, 2));
        r.setPaint(new GradientPaint(0.0f, 0.0f, r.getPrimColor(), r.size.width, r.size.height, r.getSecColor()));
        r.setCreationDate(Calendar.getInstance());
        r.setStrokePaint(r.getStrokeColor());
        r.graphElementPainter = new AssumptionPainter(r);
        r.setName(String.valueOf(Messages.getString("Assumption.5")) + Application.getInstance().getModel().getCounter("assumption"));
        return r;
    }

    @Override
    public PropertyWindow getPropertyWindow() {
        AssumptionProperties properties = (AssumptionProperties)nodePropertyWindow;
        properties.setName(this.getName());
        properties.setDescription(this.getDescription());
        properties.setProbability(this.getProbability());
        properties.initializeSources();
        properties.setSource(this.getSource());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        return nodePropertyWindow;
    }

    public String getProbability() {
        return this.probability;
    }

    public void setProbability(String probability) {
        this.probability = probability;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public Assumption clone() {
        Assumption a = new Assumption();
        super.clone(a);
        a.graphElementPainter = new AssumptionPainter(a);
        a.setProbability(this.getProbability());
        a.setSource(this.getSource());
        return a;
    }

    @Override
    public void setProperties(boolean result) {
        if (result) {
            HashMap<String, Object> oldProperties = this.getProperties();
            AssumptionProperties properties = (AssumptionProperties)nodePropertyWindow;
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            newProperties.put("name", properties.getName());
            newProperties.put("description", properties.getDescription());
            newProperties.put("probability", properties.getProbability());
            newProperties.put("source", properties.getSource());
            newProperties.put("primColor", properties.getFillPrimColor());
            if (properties.isGradient()) {
                newProperties.put("secColor", properties.getFillSecColor());
            } else {
                newProperties.put("secColor", properties.getFillPrimColor());
            }
            newProperties.put("paint", new GradientPaint(0.0f, 0.0f, (Color)newProperties.get("primColor"), this.size.width, this.size.height, (Color)newProperties.get("secColor")));
            newProperties.put("strokeColor", properties.getStrokeColor());
            newProperties.put("strokePaint", properties.getStrokeColor());
            newProperties.put("strokeThickness", Float.valueOf(properties.getStrokeThickness()));
            newProperties.put("stroke", new BasicStroke(properties.getStrokeThickness(), 0, 2));
            newProperties.put("lastChangedDate", Calendar.getInstance());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(this);
            SetPropertiesCommand propetiesCommand = new SetPropertiesCommand(nodes, oldProperties, newProperties);
            Application.getInstance().getCommandManager().doCommand(propetiesCommand);
        }
    }

    @Override
    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> rez = super.getNodeProperties();
        rez.put("probability", this.getProbability());
        rez.put("source", this.getSource());
        return rez;
    }

    @Override
    public void setProperties(HashMap<String, Object> properties) {
        super.setNodeProperties(properties);
        this.setProbability((String)properties.get("probability"));
        this.setSource((String)properties.get("source"));
    }
}

