/*
 * Decompiled with CFR 0.152.
 */
package germ.model.nodes;

import germ.app.Application;
import germ.command.SetPropertiesCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.DecisionProperties;
import germ.gui.windows.PropertyWindow;
import germ.i18n.Messages;
import germ.model.Node;
import germ.model.nodes.DecisionValue;
import germ.view.painters.DecisionPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decision
extends Node {
    private String author;
    private boolean finalized;
    private DecisionValue value;
    private static PropertyWindow nodePropertyWindow = new DecisionProperties();

    private Decision() {
    }

    public Decision(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(position, size, stroke, paint);
        this.graphElementPainter = new DecisionPainter(this);
    }

    public static Node createDefault(Point2D pos, int elemNo) {
        Point2D position = (Point2D)pos.clone();
        Decision r = new Decision();
        r.setSize(ConfigurationManager.getInstance().getDimension("decisionSize"));
        r.setStrokeThickness(ConfigurationManager.getInstance().getFloat("decisionStrokeThickness"));
        r.setStrokeColor(ConfigurationManager.getInstance().getColor("decisionStrokeColor"));
        r.setPrimColor(ConfigurationManager.getInstance().getColor("decisionFillPrimColor"));
        r.setSecColor(ConfigurationManager.getInstance().getColor("decisionFillSecColor"));
        position.setLocation(position.getX() - (double)(r.getSize().width / 2), position.getY() - (double)(r.getSize().height / 2));
        r.setPosition(position);
        r.setStroke(new BasicStroke(r.getStrokeThickness(), 0, 0));
        r.setPaint(new GradientPaint(0.0f, 0.0f, r.getPrimColor(), r.size.width, r.size.height, r.getSecColor()));
        r.setStrokePaint(r.getStrokeColor());
        r.setCreationDate(Calendar.getInstance());
        r.graphElementPainter = new DecisionPainter(r);
        r.setName(String.valueOf(Messages.getString("Decision.5")) + Application.getInstance().getModel().getCounter("decision"));
        r.setValue(DecisionValue.INTERNAL_DECISION);
        return r;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public DecisionValue getValue() {
        return this.value;
    }

    public void setValue(DecisionValue value) {
        this.value = value;
        ((DecisionPainter)this.graphElementPainter).repaint(this);
    }

    @Override
    public Decision clone() {
        Decision d = new Decision();
        super.clone(d);
        d.graphElementPainter = new DecisionPainter(d);
        d.setAuthor(this.getAuthor());
        d.setFinalized(this.isFinalized());
        d.setValue(this.getValue());
        return d;
    }

    @Override
    public PropertyWindow getPropertyWindow() {
        DecisionProperties properties = (DecisionProperties)nodePropertyWindow;
        properties.setName(this.getName());
        properties.setDescription(this.getDescription());
        properties.setAuthor(this.getAuthor());
        properties.setValue(this.getValue());
        properties.setFinalized(this.isFinalized());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        return nodePropertyWindow;
    }

    @Override
    public void setProperties(boolean result) {
        if (result) {
            HashMap<String, Object> oldProperties = this.getProperties();
            DecisionProperties properties = (DecisionProperties)nodePropertyWindow;
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            newProperties.put("name", properties.getName());
            newProperties.put("description", properties.getDescription());
            newProperties.put("author", properties.getAuthor());
            newProperties.put("value", (Object)properties.getValue());
            newProperties.put("primColor", properties.getFillPrimColor());
            if (properties.isGradient()) {
                newProperties.put("secColor", properties.getFillSecColor());
            } else {
                newProperties.put("secColor", properties.getFillPrimColor());
            }
            newProperties.put("paint", new GradientPaint(0.0f, 0.0f, (Color)newProperties.get("primColor"), this.size.width, this.size.height, (Color)newProperties.get("secColor")));
            newProperties.put("strokeColor", properties.getStrokeColor());
            newProperties.put("strokePaint", properties.getStrokeColor());
            newProperties.put("strokeThickness", Float.valueOf(properties.getStrokeThickness()));
            newProperties.put("stroke", new BasicStroke(properties.getStrokeThickness(), 0, 2));
            newProperties.put("lastChangedDate", Calendar.getInstance());
            newProperties.put("finalized", properties.getFinalized());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(this);
            SetPropertiesCommand propetiesCommand = new SetPropertiesCommand(nodes, oldProperties, newProperties);
            Application.getInstance().getCommandManager().doCommand(propetiesCommand);
        }
    }

    @Override
    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> rez = super.getNodeProperties();
        rez.put("author", this.getAuthor());
        rez.put("value", (Object)this.getValue());
        rez.put("finalized", this.isFinalized());
        return rez;
    }

    @Override
    public void setProperties(HashMap<String, Object> properties) {
        super.setNodeProperties(properties);
        this.setAuthor((String)properties.get("author"));
        this.setValue((DecisionValue)((Object)properties.get("value")));
        this.setFinalized((Boolean)properties.get("finalized"));
    }
}

