/*
 * Decompiled with CFR 0.152.
 */
package germ.model.nodes;

import germ.app.Application;
import germ.command.SetPropertiesCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.PositionProperties;
import germ.gui.windows.PropertyWindow;
import germ.i18n.Messages;
import germ.model.Node;
import germ.view.painters.PositionPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Position
extends Node {
    private static PropertyWindow nodePropertyWindow = new PositionProperties();

    private Position() {
    }

    public Position(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(position, size, stroke, paint);
        this.graphElementPainter = new PositionPainter(this);
    }

    public static Node createDefault(Point2D pos, int elemNo) {
        Point2D position = (Point2D)pos.clone();
        Position r = new Position();
        r.setSize(ConfigurationManager.getInstance().getDimension("positionSize"));
        position.setLocation(position.getX() - (double)(r.getSize().width / 2), position.getY() - (double)(r.getSize().height / 2));
        r.setPosition(position);
        r.setStrokeThickness(ConfigurationManager.getInstance().getFloat("positionStrokeThickness"));
        r.setStrokePaint(ConfigurationManager.getInstance().getColor("positionStrokeColor"));
        r.setStrokeColor(ConfigurationManager.getInstance().getColor("positionStrokeColor"));
        r.setPrimColor(ConfigurationManager.getInstance().getColor("positionFillPrimColor"));
        r.setSecColor(ConfigurationManager.getInstance().getColor("positionFillSecColor"));
        r.setStroke(new BasicStroke(r.getStrokeThickness(), 0, 0));
        r.setPaint(new GradientPaint(0.0f, 0.0f, r.getPrimColor(), r.size.width, r.size.height, r.getSecColor()));
        r.setCreationDate(Calendar.getInstance());
        r.graphElementPainter = new PositionPainter(r);
        r.setName(String.valueOf(Messages.getString("Position.0")) + Application.getInstance().getModel().getCounter("position"));
        return r;
    }

    @Override
    public Position clone() {
        Position p = new Position();
        super.clone(p);
        p.graphElementPainter = new PositionPainter(p);
        return p;
    }

    @Override
    public PropertyWindow getPropertyWindow() {
        PositionProperties properties = (PositionProperties)nodePropertyWindow;
        properties.setName(this.getName());
        properties.setDescription(this.getDescription());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        return nodePropertyWindow;
    }

    @Override
    public void setProperties(boolean result) {
        if (result) {
            HashMap<String, Object> oldProperties = this.getProperties();
            PositionProperties properties = (PositionProperties)nodePropertyWindow;
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            newProperties.put("name", properties.getName());
            newProperties.put("description", properties.getDescription());
            newProperties.put("primColor", properties.getFillPrimColor());
            if (properties.isGradient()) {
                newProperties.put("secColor", properties.getFillSecColor());
            } else {
                newProperties.put("secColor", properties.getFillPrimColor());
            }
            newProperties.put("paint", new GradientPaint(0.0f, 0.0f, (Color)newProperties.get("primColor"), this.size.width, this.size.height, (Color)newProperties.get("secColor")));
            newProperties.put("strokeColor", properties.getStrokeColor());
            newProperties.put("strokePaint", properties.getStrokeColor());
            newProperties.put("strokeThickness", Float.valueOf(properties.getStrokeThickness()));
            newProperties.put("stroke", new BasicStroke(properties.getStrokeThickness(), 0, 2));
            newProperties.put("lastChangedDate", Calendar.getInstance());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(this);
            SetPropertiesCommand propetiesCommand = new SetPropertiesCommand(nodes, oldProperties, newProperties);
            Application.getInstance().getCommandManager().doCommand(propetiesCommand);
        }
    }

    @Override
    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> rez = super.getNodeProperties();
        return rez;
    }

    @Override
    public void setProperties(HashMap<String, Object> properties) {
        super.setNodeProperties(properties);
    }
}

