/*
 * Decompiled with CFR 0.152.
 */
package germ.model.nodes;

import germ.app.Application;
import germ.command.SetPropertiesCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.PropertyWindow;
import germ.gui.windows.RequirementProperties;
import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.Node;
import germ.model.workspace.Project;
import germ.view.painters.RequirementPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Requirement
extends Node {
    private String priority;
    private transient GERMModel subDiagram;
    private String subDiagramName;
    private static PropertyWindow nodePropertyWindow = new RequirementProperties();
    private String requirements;
    private String author;
    private String version;
    private String source;
    private ArrayList<String> references;
    private String status;

    public Requirement(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(position, size, stroke, paint);
        this.graphElementPainter = new RequirementPainter(this);
    }

    private Requirement() {
    }

    public static Node createDefault(Point2D pos, int elemNo) {
        Point2D position = (Point2D)pos.clone();
        Requirement r = new Requirement();
        r.setSize(ConfigurationManager.getInstance().getDimension("requirementSize"));
        position.setLocation(position.getX() - (double)(r.getSize().width / 2), position.getY() - (double)(r.getSize().height / 2));
        r.setSubDiagram(null);
        r.setPosition(position);
        r.setStrokeThickness(ConfigurationManager.getInstance().getFloat("requirementStrokeThickness"));
        r.setStrokePaint(ConfigurationManager.getInstance().getColor("requirementStrokeColor"));
        r.setStrokeColor(ConfigurationManager.getInstance().getColor("requirementStrokeColor"));
        r.setPrimColor(ConfigurationManager.getInstance().getColor("requirementFillPrimColor"));
        r.setSecColor(ConfigurationManager.getInstance().getColor("requirementFillSecColor"));
        r.setStroke(new BasicStroke(r.getStrokeThickness(), 0, 1));
        r.setPaint(new GradientPaint(0.0f, 0.0f, r.getPrimColor(), r.size.width, r.size.height, r.getSecColor()));
        r.setCreationDate(Calendar.getInstance());
        r.graphElementPainter = new RequirementPainter(r);
        r.setName(String.valueOf(Messages.getString("Requirement.6")) + Application.getInstance().getModel().getCounter("requirement"));
        return r;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public boolean isComplex() {
        return this.subDiagram != null;
    }

    public void setSubDiagram(GERMModel subDiagram) {
        this.subDiagram = subDiagram;
        if (subDiagram != null) {
            this.subDiagramName = subDiagram.getName();
        }
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String requirements) {
        this.requirements = requirements;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ArrayList<String> getReferences() {
        return this.references;
    }

    public void setReferences(ArrayList<String> references) {
        this.references = references;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GERMModel getSubDiagram() {
        return this.subDiagram;
    }

    @Override
    public Requirement clone() {
        Requirement r = new Requirement();
        super.clone(r);
        r.graphElementPainter = new RequirementPainter(r);
        r.setPriority(this.getPriority());
        r.setSubDiagram(this.getSubDiagram());
        r.setAuthor(this.getAuthor());
        r.setReferences(this.getReferences());
        r.setRequirements(this.getRequirements());
        r.setSource(this.getSource());
        r.setStatus(this.getStatus());
        r.setVersion(this.getVersion());
        r.setCreationDate(this.getCreationDate());
        r.setLastChangeDate(this.getLastChangeDate());
        return r;
    }

    @Override
    public PropertyWindow getPropertyWindow() {
        RequirementProperties properties = (RequirementProperties)nodePropertyWindow;
        properties.setName(this.getName());
        properties.setRequirementName(this.getName());
        properties.setDescription(this.getDescription());
        properties.setPriority(this.getPriority());
        properties.setComplex(this.isComplex());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        properties.initializeDiagrams();
        properties.initializeNewDiagramListener();
        if (this.getSubDiagram() != null) {
            properties.setSubDiagram(this.getSubDiagram().getName());
        }
        properties.initializeAuthors();
        properties.setAuthor(this.getAuthor());
        properties.setReferences(this.getReferences());
        properties.setRequirements(this.getRequirements());
        properties.setSource(this.getSource());
        properties.setStatus(this.getStatus());
        properties.setVersion(this.getVersion());
        properties.checkRequirements();
        return nodePropertyWindow;
    }

    @Override
    public void setProperties(boolean result) {
        if (result) {
            HashMap<String, Object> oldProperties = this.getProperties();
            RequirementProperties properties = (RequirementProperties)nodePropertyWindow;
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            newProperties.put("name", properties.getName());
            newProperties.put("description", properties.getDescription());
            newProperties.put("priority", properties.getPriority());
            newProperties.put("complex", properties.getComplex());
            newProperties.put("primColor", properties.getFillPrimColor());
            if (properties.isGradient()) {
                newProperties.put("secColor", properties.getFillSecColor());
            } else {
                newProperties.put("secColor", properties.getFillPrimColor());
            }
            newProperties.put("paint", new GradientPaint(0.0f, 0.0f, (Color)newProperties.get("primColor"), this.size.width, this.size.height, (Color)newProperties.get("secColor")));
            newProperties.put("strokeColor", properties.getStrokeColor());
            newProperties.put("strokePaint", properties.getStrokeColor());
            newProperties.put("strokeThickness", Float.valueOf(properties.getStrokeThickness()));
            newProperties.put("stroke", new BasicStroke(properties.getStrokeThickness(), 0, 2));
            newProperties.put("lastChangedDate", Calendar.getInstance());
            newProperties.put("author", properties.getAuthor());
            newProperties.put("references", properties.getReferences());
            newProperties.put("requirements", properties.getRequirements());
            newProperties.put("source", properties.getSource());
            newProperties.put("status", properties.getStatus());
            newProperties.put("version", properties.getVersion());
            if (properties.getSubDiagram() != null) {
                Project currentProject = Application.getInstance().getModel().getProject();
                GERMModel subDiagram = null;
                int i = 0;
                while (i != currentProject.getDiagramCount()) {
                    if (currentProject.getDiagram(i).getName().equals(properties.getSubDiagram())) {
                        subDiagram = currentProject.getDiagram(i);
                    }
                    ++i;
                }
                if (subDiagram != null) {
                    newProperties.put("subDiagram", subDiagram);
                }
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(this);
            SetPropertiesCommand propetiesCommand = new SetPropertiesCommand(nodes, oldProperties, newProperties);
            Application.getInstance().getCommandManager().doCommand(propetiesCommand);
        }
    }

    @Override
    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> rez = super.getNodeProperties();
        rez.put("priority", this.getPriority());
        rez.put("subDiagram", this.getSubDiagram());
        rez.put("author", this.getAuthor());
        rez.put("references", this.getReferences());
        rez.put("requirements", this.getRequirements());
        rez.put("source", this.getSource());
        rez.put("status", this.getStatus());
        rez.put("version", this.getVersion());
        return rez;
    }

    @Override
    public void setProperties(HashMap<String, Object> properties) {
        super.setNodeProperties(properties);
        this.setPriority((String)properties.get("priority"));
        this.setSubDiagram((GERMModel)properties.get("subDiagram"));
        this.setAuthor((String)properties.get("author"));
        this.setReferences((ArrayList)properties.get("references"));
        this.setRequirements((String)properties.get("requirements"));
        this.setSource((String)properties.get("source"));
        this.setStatus((String)properties.get("status"));
        this.setVersion((String)properties.get("version"));
    }

    public String getSubDiagramName() {
        return this.subDiagramName;
    }

    public RequirementProperties getNewPropertyWindow() {
        RequirementProperties properties = new RequirementProperties();
        properties.setName(this.getName());
        properties.setRequirementName(this.getName());
        properties.setDescription(this.getDescription());
        properties.setPriority(this.getPriority());
        properties.setComplex(this.isComplex());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        properties.initializeDiagrams();
        properties.initializeNewDiagramListener();
        if (this.getSubDiagram() != null) {
            properties.setSubDiagram(this.getSubDiagram().getName());
        }
        properties.initializeAuthors();
        properties.setAuthor(this.getAuthor());
        properties.setReferences(this.getReferences());
        properties.setRequirements(this.getRequirements());
        properties.setSource(this.getSource());
        properties.setStatus(this.getStatus());
        properties.setVersion(this.getVersion());
        properties.checkRequirements();
        return properties;
    }
}

