/*
 * Decompiled with CFR 0.152.
 */
package germ.model.nodes;

import germ.app.Application;
import germ.command.SetPropertiesCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.PropertyWindow;
import germ.gui.windows.StakeholderProperties;
import germ.i18n.Messages;
import germ.model.Node;
import germ.view.painters.StakeholderPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stakeholder
extends Node {
    private String stakeholdersName;
    private String stakeholdersSurname;
    private String stakeholderPosition;
    private String company;
    private String adress;
    private String mail;
    private String telephone;
    private static PropertyWindow nodePropertyWindow = new StakeholderProperties();

    public Stakeholder(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(position, size, stroke, paint);
        this.graphElementPainter = new StakeholderPainter(this);
    }

    private Stakeholder() {
    }

    public static Node createDefault(Point2D pos, int elemNo) {
        Point2D position = (Point2D)pos.clone();
        Stakeholder r = new Stakeholder();
        r.setSize(ConfigurationManager.getInstance().getDimension("stakeholderSize"));
        position.setLocation(position.getX() - (double)(r.getSize().width / 2), position.getY() - (double)(r.getSize().height / 2));
        r.setPosition(position);
        r.setStrokeThickness(ConfigurationManager.getInstance().getFloat("stakeholderStrokeThickness"));
        r.setStrokePaint(ConfigurationManager.getInstance().getColor("stakeholderStrokeColor"));
        r.setStrokeColor(ConfigurationManager.getInstance().getColor("stakeholderStrokeColor"));
        r.setPrimColor(ConfigurationManager.getInstance().getColor("stakeholderFillPrimColor"));
        r.setSecColor(ConfigurationManager.getInstance().getColor("stakeholderFillSecColor"));
        r.setStroke(new BasicStroke(r.getStrokeThickness(), 0, 1));
        r.setPaint(new GradientPaint(0.0f, 0.0f, r.getPrimColor(), r.size.width, r.size.height, r.getSecColor()));
        r.setCreationDate(Calendar.getInstance());
        r.graphElementPainter = new StakeholderPainter(r);
        long no = Application.getInstance().getModel().getCounter("stakeholder");
        r.setName(String.valueOf(Messages.getString("Stakeholder.0")) + no);
        r.setStakeholdersName(Messages.getString("Stakeholder.1"));
        r.setStakeholdersSurname("" + no);
        return r;
    }

    public String getStakeholdersName() {
        return this.stakeholdersName;
    }

    public void setStakeholdersName(String stakeholdersName) {
        this.stakeholdersName = stakeholdersName;
    }

    public String getStakeholdersSurname() {
        return this.stakeholdersSurname;
    }

    public void setStakeholdersSurname(String stakeholdersSurname) {
        this.stakeholdersSurname = stakeholdersSurname;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getAdress() {
        return this.adress;
    }

    public void setAdress(String adress) {
        this.adress = adress;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setStakeholderPosition(String stakeholderPosition) {
        this.stakeholderPosition = stakeholderPosition;
    }

    public String getStakeholderPosition() {
        return this.stakeholderPosition;
    }

    @Override
    public Stakeholder clone() {
        Stakeholder s = new Stakeholder();
        super.clone(s);
        s.graphElementPainter = new StakeholderPainter(s);
        s.setName(String.valueOf(this.getStakeholdersName()) + " " + this.getStakeholdersSurname());
        s.setStakeholdersName(this.getStakeholdersName());
        s.setStakeholdersSurname(this.getStakeholdersSurname());
        s.setStakeholderPosition(this.getStakeholderPosition());
        s.setCompany(this.getCompany());
        s.setAdress(this.getAdress());
        s.setMail(this.getMail());
        s.setTelephone(this.getTelephone());
        return s;
    }

    @Override
    public PropertyWindow getPropertyWindow() {
        StakeholderProperties properties = (StakeholderProperties)nodePropertyWindow;
        properties.setName(this.getStakeholdersName());
        properties.setSurname(this.getStakeholdersSurname());
        properties.setPosition(this.getStakeholderPosition());
        properties.setCompany(this.getCompany());
        properties.setAdress(this.getAdress());
        properties.setMail(this.getMail());
        properties.setTelephone(this.getTelephone());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        return nodePropertyWindow;
    }

    @Override
    public void setProperties(boolean result) {
        if (result) {
            HashMap<String, Object> oldProperties = this.getProperties();
            StakeholderProperties properties = (StakeholderProperties)nodePropertyWindow;
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            newProperties.put("name", String.valueOf(properties.getName()) + " " + properties.getSurname());
            newProperties.put("stekeholdersSurname", properties.getSurname());
            newProperties.put("stakeholdersName", properties.getName());
            newProperties.put("stakeholdersPosition", properties.getPosition());
            newProperties.put("company", properties.getCompany());
            newProperties.put("address", properties.getAdress());
            newProperties.put("mail", properties.getMail());
            newProperties.put("telephone", properties.getTelephone());
            newProperties.put("primColor", properties.getFillPrimColor());
            if (properties.isGradient()) {
                newProperties.put("secColor", properties.getFillSecColor());
            } else {
                newProperties.put("secColor", properties.getFillPrimColor());
            }
            newProperties.put("paint", new GradientPaint(0.0f, 0.0f, (Color)newProperties.get("primColor"), this.size.width, this.size.height, (Color)newProperties.get("secColor")));
            newProperties.put("strokeColor", properties.getStrokeColor());
            newProperties.put("strokePaint", properties.getStrokeColor());
            newProperties.put("strokeThickness", Float.valueOf(properties.getStrokeThickness()));
            newProperties.put("stroke", new BasicStroke(properties.getStrokeThickness(), 0, 2));
            newProperties.put("lastChangedDate", Calendar.getInstance());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(this);
            SetPropertiesCommand propetiesCommand = new SetPropertiesCommand(nodes, oldProperties, newProperties);
            Application.getInstance().getCommandManager().doCommand(propetiesCommand);
        }
    }

    @Override
    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> rez = super.getNodeProperties();
        rez.put("stekeholdersSurname", this.getStakeholdersSurname());
        rez.put("stakeholdersName", this.getStakeholdersName());
        rez.put("stakeholdersPosition", this.getStakeholderPosition());
        rez.put("company", this.getCompany());
        rez.put("address", this.getAdress());
        rez.put("mail", this.getMail());
        rez.put("telephone", this.getTelephone());
        return rez;
    }

    @Override
    public void setProperties(HashMap<String, Object> properties) {
        super.setNodeProperties(properties);
        this.setStakeholdersName((String)properties.get("stakeholdersName"));
        this.setStakeholdersSurname((String)properties.get("stekeholdersSurname"));
        this.setStakeholderPosition((String)properties.get("stakeholdersPosition"));
        this.setCompany((String)properties.get("company"));
        this.setAdress((String)properties.get("address"));
        this.setMail((String)properties.get("mail"));
        this.setTelephone((String)properties.get("telephone"));
    }
}

