/*
 * Decompiled with CFR 0.152.
 */
package germ.model.nodes;

import germ.app.Application;
import germ.command.SetPropertiesCommand;
import germ.configuration.ConfigurationManager;
import germ.gui.windows.PropertyWindow;
import germ.gui.windows.TopicProperties;
import germ.i18n.Messages;
import germ.model.Node;
import germ.view.painters.TopicPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topic
extends Node {
    private String author;
    private boolean closed;
    private String topicCloser;
    private static PropertyWindow nodePropertyWindow = new TopicProperties();

    private Topic() {
    }

    public Topic(Point2D position, Dimension size, Stroke stroke, Paint paint) {
        super(position, size, stroke, paint);
        this.graphElementPainter = new TopicPainter(this);
    }

    public static Node createDefault(Point2D pos, int elemNo) {
        Point2D position = (Point2D)pos.clone();
        Topic r = new Topic();
        r.setSize(ConfigurationManager.getInstance().getDimension("topicSize"));
        position.setLocation(position.getX() - (double)(r.getSize().width / 2), position.getY() - (double)(r.getSize().height / 2));
        r.setPosition(position);
        r.setStrokeThickness(ConfigurationManager.getInstance().getFloat("topicStrokeThickness"));
        r.setStrokePaint(ConfigurationManager.getInstance().getColor("topicStrokeColor"));
        r.setStrokeColor(ConfigurationManager.getInstance().getColor("topicStrokeColor"));
        r.setStroke(new BasicStroke(r.getStrokeThickness(), 0, 0));
        r.setPrimColor(ConfigurationManager.getInstance().getColor("topicFillPrimColor"));
        r.setSecColor(ConfigurationManager.getInstance().getColor("topicFillSecColor"));
        r.setPaint(new GradientPaint(0.0f, 0.0f, r.getPrimColor(), r.size.width, r.size.height, r.getSecColor()));
        r.setCreationDate(Calendar.getInstance());
        r.graphElementPainter = new TopicPainter(r);
        r.setName(String.valueOf(Messages.getString("Topic.6")) + Application.getInstance().getModel().getCounter("topic"));
        return r;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public String getTopicCloser() {
        return this.topicCloser;
    }

    public void setTopicCloser(String topicCloser) {
        this.topicCloser = topicCloser;
    }

    @Override
    public Topic clone() {
        Topic t = new Topic();
        super.clone(t);
        t.graphElementPainter = new TopicPainter(t);
        t.setAuthor(this.getAuthor());
        t.setClosed(this.isClosed());
        t.setTopicCloser(this.getTopicCloser());
        return t;
    }

    @Override
    public PropertyWindow getPropertyWindow() {
        TopicProperties properties = (TopicProperties)nodePropertyWindow;
        properties.setName(this.getName());
        properties.setDescription(this.getDescription());
        properties.initializeStakeholders();
        properties.setAuthor(this.getAuthor());
        properties.setClosed(this.isClosed());
        properties.setTopicCloser(this.getTopicCloser());
        properties.setFillPrimColor(this.getPrimColor());
        properties.setFillSecColor(this.getSecColor());
        properties.setStrokeThickness(this.getStrokeThickness());
        properties.setCbStrokeThickness(properties.getStrokeThickness());
        properties.setStrokeColor(this.getStrokeColor());
        properties.setGradient(!this.getPrimColor().equals(this.getSecColor()));
        properties.setDateCreated(this.getCreationDate().getTime().toString());
        if (this.getLastChangeDate() != null) {
            properties.setDateChanged(this.getLastChangeDate().getTime().toString());
        } else {
            properties.setDateChanged("###");
        }
        return nodePropertyWindow;
    }

    @Override
    public void setProperties(boolean result) {
        if (result) {
            HashMap<String, Object> oldProperties = this.getProperties();
            TopicProperties properties = (TopicProperties)nodePropertyWindow;
            HashMap<String, Object> newProperties = new HashMap<String, Object>();
            newProperties.put("name", properties.getName());
            newProperties.put("description", properties.getDescription());
            newProperties.put("author", properties.getAuthor());
            newProperties.put("closed", properties.getClosed());
            newProperties.put("topicCloser", properties.getTopicCloser());
            newProperties.put("primColor", properties.getFillPrimColor());
            if (properties.isGradient()) {
                newProperties.put("secColor", properties.getFillSecColor());
            } else {
                newProperties.put("secColor", properties.getFillPrimColor());
            }
            newProperties.put("paint", new GradientPaint(0.0f, 0.0f, (Color)newProperties.get("primColor"), this.size.width, this.size.height, (Color)newProperties.get("secColor")));
            newProperties.put("strokeColor", properties.getStrokeColor());
            newProperties.put("strokePaint", properties.getStrokeColor());
            newProperties.put("strokeThickness", Float.valueOf(properties.getStrokeThickness()));
            newProperties.put("stroke", new BasicStroke(properties.getStrokeThickness(), 0, 2));
            newProperties.put("lastChangedDate", Calendar.getInstance());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(this);
            SetPropertiesCommand propetiesCommand = new SetPropertiesCommand(nodes, oldProperties, newProperties);
            Application.getInstance().getCommandManager().doCommand(propetiesCommand);
        }
    }

    @Override
    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> rez = super.getNodeProperties();
        rez.put("author", this.getAuthor());
        rez.put("closed", this.isClosed());
        rez.put("topicCloser", this.getTopicCloser());
        return rez;
    }

    @Override
    public void setProperties(HashMap<String, Object> properties) {
        super.setNodeProperties(properties);
        this.setAuthor((String)properties.get("author"));
        this.setClosed((Boolean)properties.get("closed"));
        this.setTopicCloser((String)properties.get("topicCloser"));
    }
}

