/*
 * Decompiled with CFR 0.152.
 */
package germ.model.workspace;

import germ.i18n.Messages;
import germ.model.GERMModel;
import germ.model.event.UpdateListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private ArrayList<GERMModel> diagrams = new ArrayList();
    private String name;
    private File projectDir;

    public Project(String name) {
        this.name = name;
    }

    public Project(String name, File projectDir, UpdateListener treeListener) {
        this.name = name;
        this.projectDir = projectDir;
        String[] stringArray = projectDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            try {
                File diagram = new File(String.valueOf(projectDir.getCanonicalPath()) + File.separator + d);
                if (!diagram.isDirectory() && d.endsWith(".drm") && d.split("\\.")[1].equals("drm")) {
                    GERMModel m = new GERMModel(d.split("\\.")[0], this);
                    m.load();
                    this.addDiagram(m);
                    m.addUpdateListener(treeListener);
                }
            }
            catch (IOException e) {
                System.err.println(Messages.getString("Project.3"));
                e.printStackTrace();
            }
            ++n2;
        }
        if (this.getDiagramCount() == 0) {
            GERMModel m = new GERMModel(Messages.getString("Project.4"), this);
            m.save();
            this.addDiagram(m);
            m.addUpdateListener(treeListener);
        }
    }

    public Project(String name, File projectDir, ArrayList<GERMModel> diagrams) {
        this.name = name;
        this.projectDir = projectDir;
        this.diagrams = diagrams;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void addDiagram(GERMModel diagram) {
        this.diagrams.add(diagram);
    }

    public void deleteDiagram(GERMModel diagram) {
        this.diagrams.remove(diagram);
    }

    public void deleteDiagramIndex(int index) {
        this.diagrams.remove(index);
    }

    public GERMModel getDiagram(int index) {
        return this.diagrams.get(index);
    }

    public int getDiagramIndex(GERMModel diagram) {
        return this.diagrams.indexOf(diagram);
    }

    public int getDiagramCount() {
        return this.diagrams.size();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectDir(String newName) {
        try {
            String oldProjectDir = this.projectDir.getCanonicalPath();
            String newProjectDir = String.valueOf(oldProjectDir.substring(0, oldProjectDir.lastIndexOf(File.separator))) + File.separator + newName;
            this.projectDir.renameTo(new File(newProjectDir));
            this.setName(newName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

